/*
   filter for Scott Adams games on Electron/Beeb (?) (8-bit executables)

   Written by Dave Lodge

   Version 1.3
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct
{
   char name[50];
   int id,header,data;
} Engine_type;

/* frig as I can't be bothered to lower_case the previous occurences... */
int HEADER_START=0x117,DATA_START=0x15e7,ID_START=0x19c;
int verbose,headers,clay=0;
FILE *outfile=stdout;
char infile[256];
Engine_type engines[5];
int no_engines=5;
int header[13];
int noun_offset,verb_offset,action_offset,message_offset,room_offset,exit_offset;

void setupengines(void)
{
   strcpy(engines[0].name,"Mysterious Adventure");
   engines[0].id=0x19c;
   engines[0].header=0x117;
   engines[0].data=0x15e7;

   strcpy(engines[1].name,"Brian Howarth v1");
   engines[1].id=0x18d;
   engines[1].header=0x1a2d;
   engines[1].data=0x1a45;

   strcpy(engines[2].name,"Brian Howarth v2");
   engines[2].id=0x18e;
   engines[2].header=0x1ace;
   engines[2].data=0x1ae6;

   strcpy(engines[3].name,"Mysterious Adventure v2");
   engines[3].id=0x9c;
   engines[3].header=0x17;
   engines[3].data=0x1497;

   strcpy(engines[4].name,"Mak Jukic");
   engines[4].id=0x1c65;
   engines[4].header=0x2036;
   engines[4].data=0x2053;
}

void readheader(in,engine)
FILE *in;
int engine;
{
   int i,value;
   header[0]=0;

   for (i = 1; i < 12; i++)
   {
      value = fgetc(in) + 256 * fgetc(in);
      if (engine == 1 && value == 0xd33)
      { /* Is it Claymorgue? */
         i--;
         DATA_START+=2;
         clay=1;
      }
      if (engine == 4)
      {
         switch (i)
         {
            case 1  : header[8]=value; break;
            case 2  : header[3]=value; break;
            case 3  : header[2]=value; break;
            case 4  : header[1]=value; break;
            case 5  : header[10]=value; break;
            case 6  : header[4]=value; break;
            case 7  : header[5]=value; break;
            case 8  : header[6]=value; break;
            case 9  : header[7]=value; break;
            case 10 : header[9]=value; break;
            case 11 : header[11]=value/256; break;
         }
      }
      else
      {
         header[i] = value;
      }
   }

   header[12]=0;
}

void syntax(char a[])
{
   printf("Syntax: %s [flags] <infile> [outfile]\n",a);
   printf("Flags are:\n");
   printf("\t-h|-?      - this message\n");
   printf("\t-s         - show the headers only\n");
   printf("\t-v         - verbose listing\n");
   exit(0);
}

void parse_arguments(argc,argv)
int argc;
char *argv[];
{
   int carg=1,c=0,carg2;

   infile[0]='\0';

   while (carg<argc)
   {
      c=0;
      switch (argv[carg][0])
      {
         case '-' :
            carg2=carg;
            while (c<strlen(argv[carg])-1)
            {
               switch(argv[carg][++c])
               {
                  case 'h' :
                  case '?' :
                     syntax(argv[0]);

                  case '-' :
                     strcpy(infile,argv[++carg2]);
                     break;

                  case 'q' :
                     printf("Here's the quote then:\n");
                     printf("\"In this asylum I cry for you\n");
                     printf(" I wanna go home\n");
                     printf(" Look what you've put me through\n");
                     printf(" Put me through\"\n");
                     printf(" - Carl McCoy 'Vet for the insane'\n");
                     exit(0);

                  case 'v' :
                     verbose=1;
                     break;

                  case 's' :
                     headers=1;
                     verbose=1;
                     break;

                  default :
                     printf("%s: Invalid flag: -%c\n",argv[0],argv[carg][c]);
                     syntax(argv[0]);
               }
            }
            carg=carg2+1;
            break;

         default :
            if (argc!=carg)
            {
               if (infile[0]=='\0') strcpy(infile,argv[carg++]);
               else
               {
                  if (outfile==stdout)
                  {
                     if ((outfile=fopen(argv[carg++],"w"))==NULL)
                     {
                        printf("%s: Cannot open outfile; aborting\n",argv[0]);
                        exit(0);
                     }
                  }
                  else
                  {
                     printf("%s: Invalid argument: %s\n",argv[0],argv[carg]);
                     syntax(argv[0]);
                  }
               }
            }
      }
   }

   if (infile[0]=='\0')
   {
      printf("%s: No input file specified\n",argv[0]);
      syntax(argv[0]);
   }

}

/* returns version of file -1=Unknown 0=MA; 1=SA (BH) etc.; */
int find_version(ptr)
FILE *ptr;
{
   int succ=0, i, j;
   char head[5];

   if (verbose) printf("Checking version of file...\n");

   for (j=0;j<no_engines;j++)
   {
      succ=fseek(ptr,engines[j].id,SEEK_SET);
      if (succ!=0) return -1;
      for (i=0;i<4;i++)
      {
         head[i]=fgetc(ptr);
      }
      head[4]='\0';
      if (!strcmp(head,"NORT"))
      {
         HEADER_START=engines[j].header;
         DATA_START=engines[j].data;
         return j;
      }
   }

   succ=fseek(ptr,engines[4].id,SEEK_SET);
   if (succ!=0) return -1;
   for (i=0;i<4;i++)
   {
      head[i]=fgetc(ptr);
   }
   head[4]='\0';
   if (!strcmp(head,"SAVE"))
   {
      HEADER_START=engines[4].header;
      DATA_START=engines[4].data;
      return 4;
   }
   return -1;
}


int main (int argc, char *argv[])
{
   int value, i, j, c;
   int actions, words, real_words, rooms, messages, items, word_len;
   int succ, engine;
   int cond, comm;
   long int tempy;
   FILE *in,*in2;

   parse_arguments(argc,argv);
   setupengines();

   if (verbose) printf("Opening files...\n");

   if ((in=fopen(infile,"rb"))==0)
   {
      printf("%s: Cannot open input file\n",argv[0]);
      if (outfile!=stdout) fclose(outfile);
      return 0;
   }

/* frig to save me having t'store position and have t'go back t'it... */
   if ((in2=fopen(infile,"rb"))==0)
   {
      printf("%s: Cannot open input file\n",argv[0]);
      fclose(in);
      if (outfile!=stdout) fclose(outfile);
      return 0;
   }

   engine=find_version(in);
   if (engine==-1)
   {
      printf("%s: Cannot understand the engine!\n",argv[0]);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      return 0;
   }

   if (verbose) printf("Engine: %s\n",engines[engine].name);

   if (verbose) printf("Finding header...\n");

/* reading / writing */
   succ=fseek(in,HEADER_START,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find header\n",argv[0]);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      return 0;
   }

/* header */
   readheader(in,engine);
   for (i = 0; i < 12; i++)
   {
      value=header[i];
      if (!headers) fprintf(outfile," %d \n", value);
      switch(i)
      {
         case 1 :
            items = value;
            if (verbose) printf("Number of items =\t%d\n",items);
            break;

         case 2 :
            actions = value;
            if (verbose) printf("Number of actions =\t%d\n",actions);
            break;

         case 3 :
            words = value;
            if (verbose) printf("Number of words =\t%d\n",words);
            break;

         case 4 :
            rooms = value;
            if (verbose) printf("Number of rooms =\t%d\n",rooms);
            break;

         case 8 :
            word_len = value;
            if (verbose) printf("Word length =\t%d\n",word_len);
            break;

         case 10 :
            messages = value;
            if (verbose) printf("Number of messages =\t%d\n",messages);
            break;

         default :
            break;
      }
   }
   fprintf(outfile," \n");

   if (headers)
   {
      fclose(in);
      fclose(in2);
      exit(0);
   }

   /* set up offsets */
   if (engine < 4)
   {
      if (engine == 3) actions -= 3;
      noun_offset=DATA_START+((actions+1)*16)+(words+1)*(word_len+1);
      verb_offset=DATA_START+((actions+1)*16);
      action_offset=DATA_START;
      room_offset=DATA_START+((actions+1)*16)+((words+1)*2)*(word_len+1);
   }
   else
   {
      noun_offset=DATA_START;
      verb_offset=DATA_START+(words+1)*(word_len+1);
      action_offset=DATA_START;
      room_offset=DATA_START;
   }

   if (verbose) printf("Finding data...\n");

   if (engine == 4)
   {
      printf("%s: cannot convert %s engine\n",argv[0],engines[engine].name);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      exit(1);
   }

   succ=fseek(in,action_offset,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find data\n",argv[0]);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      exit(1);
   }
/* actions */
   if (verbose) printf("Converting actions...\n");

   if (engine == 2)
   { /* convert compressed actions */
      for (i = 0; i < (actions); i++)
      {
         value = fgetc(in) + 256 * fgetc(in); /* verb/noun */
         fprintf(outfile," %d \n", value);
         value = fgetc(in); /* count of actions/conditions */
         cond = value & 0x1f;
         comm = (value & 0xe0) >> 5;
         for (j = 0; j < 5; j++)
         {
            if (j < cond) value = fgetc(in) + 256 * fgetc(in); else value = 0;
            fprintf(outfile," %d \n", value);
         }
         for (j = 0; j < 2; j++)
         {
            if (j < comm) value = fgetc(in) + 256 * fgetc(in); else value = 0;
            fprintf(outfile," %d \n", value);
         }
      }
      for (i = 0; i < 8; i++) fprintf(outfile," 0\n"); /* frig */
      noun_offset=ftell(in)+(words+1)*(word_len+1);
      verb_offset=ftell(in);
      room_offset=ftell(in)+((words+1)*2)*(word_len+1);
   }
   else
   {
      for (i = 0; i < ((8 * (actions + 1))); i++)
      {
         value = fgetc(in) + 256 * fgetc(in);
         fprintf(outfile," %d \n", value);
      }

      if (engine == 3)
      {
         for (i = 0; i < 24; i++) fprintf(outfile," 0\n");
         actions+=3;
      }
   }

   fprintf(outfile,"\n");

/* vocab */
   if (verbose) printf("Converting words...\n");

   succ=fseek(in,verb_offset,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find verbs\n",argv[0]);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      exit(1);
   }

   succ=fseek(in2,noun_offset,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find nouns\n",argv[0]);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      exit(1);
   }

   real_words = 2 * words;
   real_words += 2;

   for (i = 0; i <= words; i++)
   {
      fprintf (outfile,"\"");
      if (clay == 1 && i == 0)
      { /* Frig for Claymorgue */
         fprintf (outfile,"AUTO\"\n\"ANY\"\n");
         for (j = 0; j <= word_len; j++) c = fgetc(in);
         for (j = 0; j <= word_len; j++) c = fgetc(in2);
      }
      else
      {
         for (j = 0; j <= word_len; j++)
         {
            if ((c = fgetc(in)) != 0)
            fprintf (outfile,"%c", c);
         }
         fprintf (outfile,"\"\n");
         fprintf (outfile,"\"");
         for (j = 0; j <= word_len; j++)
         {
            if ((c = fgetc(in2)) != 0)
            fprintf (outfile,"%c", c);
         }
         fprintf (outfile,"\"\n");
      }
   }
   fprintf (outfile,"\n");

/* rooms */
   if (verbose) printf("Converting rooms...\n");

/* Nasty way of doing it; but oh well :) */
   succ=fseek(in,room_offset,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find room descriptions\n",argv[0]);
      return 0;
   }

   for (i = 0; i <= rooms; i++)
   {
      while ((c = fgetc(in)) != '\0');
   }
   tempy=ftell(in);
   succ=fseek(in2,tempy,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find room exits\n",argv[0]);
      return 0;
   }

   succ=fseek(in,room_offset,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find room descriptions\n",argv[0]);
      return 0;
   }

   for (i = 0; i <= rooms; i++)
   {
      for (j=0;j<6;j++)
         fprintf(outfile," %d \n",fgetc(in2));
      fprintf (outfile,"\"");
      while ((c = fgetc(in)) != '\0')
         fputc((c == 0x22) ? '`' : c,outfile);
      /* why the f**k is fputc backwards? */
      fprintf (outfile,"\"\n");
   }
   fprintf (outfile,"\n");

/* messages */
   if (verbose) printf("Converting messages...\n");

   for (i = 0; i <= messages; i++)
   {
      fprintf (outfile,"\"");
      while ((c = fgetc(in2)) != '\0')
         fputc((c == 0x22) ? '`' : c,outfile);
      fprintf (outfile,"\"\n");
   }
   fprintf (outfile,"\n");

/* items */
   if (verbose) printf("Converting items...\n");

   tempy=ftell(in2);
   succ=fseek(in,tempy,SEEK_SET);
   if (succ!=0)
   {
      printf("%s: cannot find item locations\n",argv[0]);
      fclose(in);
      fclose(in2);
      if (outfile!=stdout) fclose(outfile);
      return 0;
   }
   for (i = 0; i <= items; i++)
   {
      while ((c = fgetc(in2)) != '\0');
   }
   for (i = 0; i <= items; i++)
   {
      fprintf (outfile,"\"");
      while ((c = fgetc(in)) != '\0')
         fputc((c == 0x22) ? '`' : c,outfile);
      fprintf (outfile,"\" ");
      fprintf(outfile,"%d \n",fgetc(in2));
   }
   fprintf (outfile,"\n");


/* comments */
   if (verbose) printf("Placing Comments...\n");

   for (i = 0; i < (actions + 1); i++)
      fprintf (outfile,"\"\"\n");
   fprintf (outfile,"\n");

   fclose(in);
   fclose(in2);
   if (outfile!=stdout) fclose(outfile);
}
