/***************************************************************************

Another ScottFree Driver, revision 1.2 beta.
Derived from Alan Cox's "ScottFree" revision 1.14,
that work (C) 1993, 1994, 1995 Swansea University Computer Society.
This driver (C) 1998 Robert Schneck.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program (see the file 'license.txt'); if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Statement: Everything in this program has been deduced or obtained
solely from published material.  No game interpreter code has been
disassembled.

***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>
#include <time.h>

#include<dos.h>
#include<conio.h>

#include"asfddos.h"


typedef char boolean;


/* curryent position of output */
int outputPos;

/*  from last look, for determining whether to redraw */
extern struct {
  short playerRoom;
  short *itemLoc;
  boolean dark;
  boolean clear; /* was there a clear screen (or other overriding redraw)? */
} lastLook;


/* Print buf, breaking lines where convenient */
void Output(char *buf) {
  char word[MAX_OUTPUT_WORD_LENGTH+1];
  boolean ournewline;
  int pos;

  ournewline = FALSE;

  while(*buf) {
    /* deal with whitespace */
    while(*buf && isspace(*buf)) {
      if(*buf=='\n') {
        cprintf("\n\r");
        ournewline = FALSE;
        outputPos=0;
      }
      /* don't put spaces at the beginning of the line
         if it was a newline only because we wrapped */
      else if (outputPos>0 || !ournewline) {
        outputPos++;
        if(outputPos<(WIDTH-1)) {
          cprintf(" ");
        }
      }

      buf++;
    }
    if (*buf == 0) {
      break;
    }

    /* get the next word */
    pos = 0;
    while(*buf && !isspace(*buf)) {
      word[pos++] = *buf++;
    }
    word[pos] = 0;

    /* print the word; insert newline if needed */
    /* let sole periods go farther (this is a bit of a klug, added
       because of how I print periods after items and rooms) */
    if(strlen(word)==1 && *word=='.') {
      if (outputPos>(WIDTH-2)) {
        cprintf("\n\r");
        ournewline = TRUE;
        outputPos=0;
      }
      cprintf(".");
      outputPos++;
    }
    else {
      /* if outputPos already 0, don't put in an extra newline */
      if((outputPos>0) && (outputPos+strlen(word) > (WIDTH-3))) {
        cprintf("\n\r");
        ournewline = TRUE;
        outputPos=0;
      }

      cprintf("%s",word);
      outputPos += strlen(word);
    }
  }
}


/* get character input */
void Input(char *buf) {
  int pos=0;
  char ch;

  while(TRUE) {
    ch = getch();
    switch(ch) {
    case 10:
    case 13:
      buf[pos]=0;
      cprintf("\n\r");
      outputPos = 0;
      return;
    case 8:
    case 127:
      if (pos>0) {
        cprintf("\010 \010");
        pos--;
      }
      break;
    default:
      /* accept printable characters */
      if(ch>=' ' && ch<=126 && pos < MAX_INPUT_LENGTH) {
        buf[pos++] = ch;
        cprintf("%c",ch);
      }
      break;
    }
  }
}


/* Functions to print in various styles */

void PrintTitle(char *buf) {
  textcolor(TITLE_COLOR);
  Output(buf);
}

void PrintLook(char *buf) {
  textcolor(LOOK_COLOR);
  Output(buf);
}

void PrintCommand(char *buf) {
  textcolor(COMMAND_COLOR);
  Output(buf);
}

void PrintMessage(char *buf) {
  textcolor(MESSAGE_COLOR);
  Output(buf);
}

void PrintDiag(char *buf) {
  textcolor(DIAG_COLOR);
  Output(buf);
}

void PrintMessageString(char *buf,char *string) {
  char result[MAX_OUTPUT_LENGTH+1];
  sprintf(result,buf,string);
  PrintMessage(result);
}

void PrintMessageNum(char *buf,int num) {
  char result[MAX_OUTPUT_LENGTH+1];
  sprintf(result,buf,num);
  PrintMessage(result);
}

void PrintDiagNum(char *buf,int num) {
  char result[MAX_OUTPUT_LENGTH+1];
  sprintf(result,buf,num);
  PrintDiag(result);
}


void ClearScreen() {
  clrscr();
  outputPos = 0;
  lastLook.clear = TRUE;
}

void Exit(int status) {
  exit(status);
}

/* anything we need to do before we start playing */
void Initialize() {
  srand(time(NULL));
}

void Delay() {
  sleep(1);
}
