#include <tads.h>

/*
 * An XTads test game.
 * Focus is on sizing horiz. text banner to contents.
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeText, BannerAlignBottom,
                       50, BannerSizePercent,
                       0);
    bannerSay(b1, 'b1 (child of b0) is a horiz text banner\nbelow b0 sized to 50% of its parent\nline 3. ');
    "Press a key to continue...\n";
    inputKey();
    "after inputKey #1...\n"; //TODO not printed after 1st key press, but bannerSizeToContents happens

    bannerSizeToContents(b1);
    "after resize #1\n";
    "\bb1 should now be sized to content: 3 lines.\n";
    inputKey();
    "after inputKey #2...\n";

    bannerSay(b1, '\nline 4.\nline 5.\nline 6.\nline 7.');
    "\bb1 should now have 7 lines, but still have size 3.\b";
    "Press a key to continue...\n";
    inputKey();
    "after inputKey #3...\n";

    bannerSizeToContents(b1);
    "after resize #2\n";
    "\bb1 should now be sized to content: 7 lines.\n";
    inputKey();
    "after inputKey #4...\n";

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
