#charset "us-ascii"

/*
RAP 1.2 Testgame

Copyright (c) Steve Breslin


License:

You may borrow from this material however you like, and may strip
the license and copyright if you are simply copying some of the
code into your own game.

You may redistribute this verbatim or in modified form only if you
keep the copyright and license intact.

Feel encouraged to release your source code along with your game,
though this isn't a requirement.

*/

#include <adv3.h>
#include <en_us.h>

/* call the map handler to build the map, to set up RAP's map-crawling
 * ability.
 */
rMapInitializer: PreinitObject
    execute() {
        rMapHandler.rBuildMap(); // this is a RAP function.
    }
;

// Actor Definitions

rupert: Rapper, Person

    /* You can call your rapper NPC's animation daemon whenever you
     * want; we're calling it from initializeActor() because we want
     * our dog Rupert to begin the game already animated. If, for
     * example, Rupert were a robot, we might have put the animation
     * initialization in rupert.doTurnOn or something like that.
     */
    initializeActor() {
        inherited();
        gPlayerChar = me; // since we execute before main, we assign
                          // gPlayerChar, as RAP may need to know
                          // this value.

        /* "rPlaying" is a custom plan, the top-level goal (the primary
         * goal) which we've written special for this testgame.
         */
// rupert's animation is temporarily deactivated.
//        rupert.rAnimate(rPlaying, nil);
    }

    obeyCommand(issuer, action) { return true; }

    location = LivingRoom
    isProperName = true
    noun = 'rupert'
    name = 'Rupert'
    desc() {
        "Rupert is a dog. ";
        if (contents.length() == 0)
            "His mouth is empty.";
    }
;


// Special rStep for this testgame. Rupert's animation uses this:

rPlaying: rStep
    name = 'rPlaying'

    rTrue(a,p) {
        return (nil);
    }

    rPlans(a,p) {
        if (!rHave.rTrue(rupert,Ball))
            return ( [ [rBe, rHave, Ball] ] );
        return ( [ [rBe, rGiveTo, [me, Ball]] ] );
    }
;

bob: Rapper, Person
    obeyCommand(i, a) { return true; }
    location = LivingRoom
    isProperName = true
    noun = 'bob'
    name = 'Bob'
    desc() {
        "Bob is a test for the knowledge & order sub-module. ";
    }
    seenProp = &bobSeen
    knownProp = &bobKnown
    initiallySeen = [KitchenTable, BigBox, SmallBox, Ball]
;

LivingRoom: Room 'Living Room'
    "Living room. South to bedroom. North to kitchen."
    vocabWords = 'living room/livingroom'
    south = Bedroom
    north = Kitchen
;

+me: Actor, Rapper
    rObjectRequest(actor, obj) {
        if (rCooperatesWith.indexOf(actor))
            rapAct(rGiveTo, [actor, obj]);
    }
    rCooperatesWith = [rupert]
;

Bedroom: Room 'Bedroom'
    "Bedroom. North to living room. West (through door) to closet."
    vocabWords = 'bed room/bedroom'
    north = LivingRoom
    west = BedroomClosetDoor
;

+BedroomClosetDoor: LockableWithKey, Door
    'closet door' 'closet door'
    keyList = [IronKey]
;

BedroomCloset: Room 'BedroomCloset'
    "Bedroom closet. East (through door) to bedroom"
    noun = 'closet'
    east = ClosetDoor
;

+ClosetDoor: LockableWithKey, Door -> BedroomClosetDoor
    'closet door' 'closet door'
    keyList = [IronKey]
;

+LockBox: LockableWithKey, OpenableContainer 'lock box' 'lock box'
    "It's a small box with a keyed-lock in the side. "
    keyList = [BronzeKey]
    initiallyLocked = true
;

++Ball: Thing 'ball' 'ball'
    "It's a ball. "
;

Bathroom: Room 'Bathroom'
    "A bathroom. Northwest to Kitchen.\nThere's a small cupboard."
    vocabWords = 'bath room/bathroom'
    northwest = Kitchen
;

+Cupboard: OpenableContainer, Fixture 'cupboard' 'cupboard'
    "It's a bathroom cupboard. "
;
++BronzeKey: Key 'bronze key' 'bronze key'
    "It's a small bronze key. "
;

Kitchen: Room 'Kitchen'
    "Kitchen. South to living room. Southeast to Bathroom."
    noun = 'kitchen'
    south = LivingRoom
    southeast = Bathroom
;

+KitchenTable: Surface 'kitchen table' 'kitchen table'
    "It's a sturdy wooden table. "
;

++BigBox: OpenableContainer 'big box' 'big box'
    "It's shoebox-sized. "
;

+++SmallBox: OpenableContainer 'small box' 'small box'
    "It's slightly bigger than a key. "
;

++++IronKey: Key 'iron key' 'iron key' "It's an iron key. "
;

versionInfo: GameID
    name = '<b>RAP TESTBED</b>\nReactive Agent Planner ver.\ 1.2 testbed\n'
    byline = RAPModuleID.byline
    htmlByline = RAPModuleID.htmlByline
    authorEmail = 'Steve Breslin <versim@hotmail.com> or
                   Nate Cull <nate@natecull.org>'
    version = '1.2'

    showCredit() {
        "Testbed for <<RAPModuleID.name>> <<RAPModuleID.byline>>";
    }
    showAbout() {
        "This is a simple testbed for RAP (Reactive Agent Planner)
        version 1.2 for TADS 3.\b

        The game is a simple map of a small apartment. There's a key in
        the kitchen, another in the bathroom cabinet, and a ball locked
        in a lockbox in the bedroom closet (also locked).\b

        There is one RAP-enabled actor, a dog named Rupert, who starts
        in the living room with you, the player. His primary goal is to
        get the ball and put it on the kitchen table. As the planbase is not
        sophisticated, Rupert has perfect knowledge of the state and
        location of all objects at all times.

        \bThis test map is trivial, but it does demonstrate a RAP
        actor's ability to react to game events - Rupert will begin by
        seeking two keys, one for the closet door, the other for the
        lockbox; if you get the keys, he will ask you for them and
        follow you. [In this version of the testgame, the PC is also a
        RAP-enabled actor, and will automatically give items asked
        for; this is just for testing and probably not good default
        behavior.] If you unlock the obstacles yourself he will ignore
        the keys and go straight for the ball. If you have the ball he
        will follow you, and ask you for it. If he gets the ball, he
        will give it to you; then he will ask for it back.\b

        Test: the player is also a RAP-enabled actor, and is programmed
        to automatically accept Rupert's request for items.\b

        The debugging spell >RAPTRACE RUPERT will let you read Rupert's
        thought processes. (The verb is only available in debug
        mode.)\b

        Test: Rupert is temporarily disabled, in favor of Bob, who is
        designed to test t3knowledge and t3rapOrder.\n
        Try:\n >BOB, PUT BALL ON TABLE\b";
    }
;

gameMain: GameMainDef
    initialPlayerChar = me
    showIntro() {
        "<hr>";
        versionInfo.showAbout();
        "<<versionInfo.name>><<versionInfo.byline>>\b";
    }
;

