#charset "us-ascii"

/* 
 *  Copyright (c) 2008 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Rulebooks library extension
 *
 *  rulebook.t
 */

#include <t3.h>
#include <tads.h>

/*--------------------------------------------------------------------
 *
 *  A Rulebook is an Association for which ONE 
 *  association must evaluate TRUE (or NIL depending on subclass)
 *  for its exec() method to be invoked. 
 *
 *  By default this class returns TRUE.
 */
class Rulebook: Association
{
    evalCtl     = EvalCtlExistTrue
    execCtl     = ExecCtlRetTrue
}

/*--------------------------------------------------------------------
 *
 *  A RulebookExistTrueRetVal is a Rulebook for which ONE 
 *  association must evaluate TRUE for its exec() method 
 *  to be invoked. 
 *
 *  By default this class returns its exec() return VALUE.
 */
class RulebookExistTrueRetVal: Rulebook
{
    execCtl     = ExecCtlRetVal
}

/*--------------------------------------------------------------------
 *
 *  A RulebookExistTrueRetNil is a Rulebook for which ONE 
 *  association must evaluate TRUE for its exec() method 
 *  to be invoked. 
 *
 *  By default this class returns NIL.
 */
class RulebookExistTrueRetNil: Rulebook
{
    execCtl     = ExecCtlRetNil
}

/*--------------------------------------------------------------------
 *
 *  A RulebookExistTrueRetTrue is a Rulebook for which ONE 
 *  association must evaluate TRUE for its exec() method 
 *  to be invoked. 
 *
 *  By default this class returns TRUE.
 */
class RulebookExistTrueRetTrue: Rulebook
;

/*--------------------------------------------------------------------
 *
 *  A RulebookExistNilRetVal is a Rulebook for which ONE 
 *  association must evaluate NIL for its exec() method 
 *  to be invoked. 
 *
 *  By default this class returns its exec() return VALUE.
 */
class RulebookExistNilRetVal: Rulebook
{
    evalCtl     = EvalCtlExistNil
    execCtl     = ExecCtlRetVal
}

/*--------------------------------------------------------------------
 *
 *  A RulebookExistNilRetNil is a Rulebook for which ONE 
 *  association must evaluate NIL for its exec() method 
 *  to be invoked. 
 *
 *  By default this class returns NIL.
 */
class RulebookExistNilRetNil: Rulebook
{
    evalCtl     = EvalCtlExistNil
    execCtl     = ExecCtlRetNil
}

/*--------------------------------------------------------------------
 *
 *  A RulebookExistNilRetTrue is a Rulebook for which ONE 
 *  association must evaluate NIL for its exec() method 
 *  to be invoked. 
 *
 *  By default this class returns TRUE.
 */
class RulebookExistNilRetTrue: Rulebook
{
    evalCtl     = EvalCtlExistNil
    execCtl     = ExecCtlRetTrue
}