#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTextFont.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Text Font 
 */ 
class HtmlTextFont: HtmlTag
{
    tagRoot     = '<font'
    beginTag    = ''
    endTag      = '</font>'

    bold        = nil
    italic      = nil

    stringList  = []

    getBold()
    {
        return bold;
    }

    setBold(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                bold = nil;
                break;

            case TypeTrue:
                bold = val;
                break;
        }
    }

    getColor()
    {
        return getHtmlAttributes.getColor();
    }

    setColor(val)
    {
        getHtmlAttributes.setColor(val);
    }

    getItalic()
    {
        return italic;
    }

    setItalic(val)
    {
        switch(dataType(val))
        {
            case TypeNil:
                italic = nil;
                break;

            case TypeTrue:
                italic = val;
                break;
        }
    }

    getSize()
    {
        return getHtmlAttributes.getSize();
    }

    setSize(val)
    {
        getHtmlAttributes.setSize(val);
    }

    getFace()
    {
        return getHtmlAttributes.getFace();
    }

    setFace(val)
    {
        getHtmlAttributes.setFace(val);
    }

    generate()
    {
        beginTag = generateTag();

        say(beginTag);

        if (getBold())
            say('<b>');

        if (getItalic())
            say('<i>');

        for (local i = 1; i <= stringList.length(); ++i)
        {
            say(stringList[i].htmlify(HtmlifyTranslateWhitespace));
            if (i < stringList.length())
                "<br>";
        }

        if (getItalic())
            say('</i>');

        if (getBold())
            say('</b>');

        say(endTag);
    }

    generateTag()
    {
        local str = '';

        str += tagRoot;
        
        str += getColor();
        str += getSize();
        str += getFace();

        str += '>';
    
        return str;
    }

    construct(attr, [strList])
    {
        inherited(attr);

        setColor('black');
        setFace('\"Courier New,Courier New\"');
        setSize('\"+1\"');

        foreach (local str in strList)
        {
            try
            {
                if (dataType(str) == TypeSString)
                    stringList += str;
            }
            catch(RuntimeError e) {}
        }
    }
}