#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTag.t
 */

#include "html.h"

/*
 *  A base class for HTML Tags.
 */
class HtmlTag: object
{
    htmlAttributes  = nil

    getHtmlAttributes()
    {
        return htmlAttributes;
    }

    setHtmlAttributes(attr)
    {
        switch(dataType(attr))
        {
            case TypeNil:
                htmlAttributes = new HtmlAttributes();
                break;

            case TypeObject:
                if (attr.ofKind(HtmlAttributes))
                    htmlAttributes = attr;
                break;

            default:
                "Invalid value for HtmlTable attributes. ";
        }
    }

    construct(attr)
    {
        setHtmlAttributes(attr);
    }
}