#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTable.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Tables
 */
class HtmlTable: HtmlTag
{
    tagRoot         = '<table'
    beginTag        = ''
    endTag          = '</table>'

    pageAlignBegin  = '<br><p><center>'
    pageAlignEnd    = '</center></p>'

    tableCaption    = nil
    tableRowList    = []

    getBorder()
    {
        return getHtmlAttributes.getBorder();
    }

    setBorder(val)
    {
        getHtmlAttributes.setBorder(val);
    }

    getCellPadding()
    {
        return getHtmlAttributes.getCellPadding();
    }

    setCellPadding(val)
    {
        getHtmlAttributes.setCellPadding(val);
    }

    getCellSpacing()
    {
        return getHtmlAttributes.getCellSpacing();
    }

    setCellSpacing(val)
    {
        getHtmlAttributes.setCellSpacing(val);
    }

    getWidth()
    {
        return getHtmlAttributes.getWidth();
    }
  
    setWidth(val)
    {
        getHtmlAttributes.setWidth(val);
    }

    getHeight()
    {
        return getHtmlAttributes.getHeight();
    }

    setHeight(val)
    {
        getHtmlAttributes.setHeight(val);
    }

    getBgColor()
    {
        return getHtmlAttributes.getBgColor();
    }

    setBgColor(val)
    {
        getHtmlAttributes.setBgColor(val);
    }

    generate()
    {
        beginTag = generateTag();

        say(pageAlignBegin);

        say(beginTag);

        if (tableCaption)
            tableCaption.generate();

        foreach(local tableRow in tableRowList)
            tableRow.generate();

        say(endTag);

        say(pageAlignEnd);
    }

    generateTag()
    {
        local str = '';

        str += tagRoot;

        str += getBorder();
        str += getCellPadding();
        str += getCellSpacing();
        str += getWidth();
        str += getHeight();
        str += getBgColor();

        str += '>';

        return str;
    }

    construct(attr, [trList])
    {
        inherited(attr);

        /*
         *  Only table rows and captions
         *  can be added to a table.
         */
        foreach(local tr in trList)
        {
            try
            {
                if (dataType(tr) != TypeObject)
                    continue;

                // Only the last caption is used
                if (tr.ofKind(HtmlTableCaption))
                    tableCaption = tr;

                if (tr.ofKind(HtmlTableRow))
                    tableRowList += tr;
            }
            catch(RuntimeError e) {}
        }
    }
}