#charset "us-ascii"

/* 
 *  Copyright (c) 2004 - 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 London Cabs Library Extension
 *
 *  lc_msg_neu.t
 *
 *  Modifications to playerActionMessages for cab-related 
 *  travel messages.
 *
 *  All Text Messages here are copyright (c) Activision.
 *  Sherlock: The Riddle of the Crown Jewels (1987)
 */

#include <adv3.h>
#include <en_us.h>

modify playerActionMessages
{
    cannotBlow = 'Blowing on {the dobj/him} would not do anything 
        useful. '
    
    okayBlowWhistle = 'Tweeeeeeeeee! '
    
    callCabFailure = 'There is a cab here already. '
    
    announceCabArrival(obj) 
    {
        gMessageParams(obj);
        return '{A obj/him} pulls up beside {you/him}. ';
    }
    
    whereToQuery = '<.p><q>Where to, guv\'nor?</q>'
    
    hansomCabTravel = '<q>Right-o.</q>\bThe cab speeds through the 
        streets, whizzing past famous landmarks. Only a few minutes 
        later, you arrive at your destination.\b'
    
    hansomCabNoTravel = '<q>We\'re already here, guv.</q>'
    
    growlerCabTravel = '<q>Oh good! I\'ve never been THERE before.</q>\b
        This is odd...\bAfter a wild ride through the streets of London,
        the cab finally careens to a halt and the cabbie says brightly,
        <q>Here we are!</q>\b'
    
    cabDepartMsg = 'You get out of the cab. After you get out, 
        it drives off. '
    
    cabDrivesOffMsg(obj)
    {
        gMessageParams(obj);
        return '{The obj/him} drives off. ';
    }

    exitCabMsg(obj)
    {
        gMessageParams(obj);
        return '{You/he} would have to get out of {the obj/him} 
            first. ';
    }
    
    hansomDesc = 'It is a small cab with two wheels and room 
        for only two persons, drawn by a single horse. '

    hansomStateDesc = 'The cabbie appears to be restless. '

    hansomSpecialDesc = 'The cabbie sits attentively, awaiting
        your request. '
    
    hansomDefault = '<q>Sorry, sir. No time to chat.</q> '
    
    growlerDesc = 'It is a large cab with four wheels and room 
        for four persons, drawn by a single horse. '

    growlerStateDesc = 'The cabbie sits scratching his head. '

    growlerSpecialDesc = 'The cabbie sits fidgeting while he awaits 
        your request. '

    growlerDefault = 'The growler cabbie says brightly, 
        <q>Hello,</q> and looks at you expectantly. '
}