#charset "us-ascii"

/* commonSpace
 * by Eric Eve, 2004
 *
 * This is a part of the Tads-3 ECC/ConSpace extension.
 *
 * Here we add actions, and modify and define objects common to both
 * ECC and ConSpace.
 *
 * This module is language independent; the language-dependent stuff
 * is in Space_en_us.t, which should be bundled with this module.
 */

#include <adv3.h>
#include <en_us.h>

#ifdef DEBUG__
ECCConSpaceDebugger: PreinitObject
    execute()
    {
        for (local obj = firstObj(ECContainer) ; obj ; 
             obj = nextObj(obj, ECContainer))
        {
            if (obj.subUnderside && obj.underLoc)
                "warning: there's both a subUnderside and an underLoc
                defined for <<obj.theName>> in
                <<obj.location.theName>>.\n";
            if (obj.subRear && obj.behindLoc)
                "warning: there's both a subRear and an behindLoc
                defined for <<obj.theName>> in
                <<obj.location.theName>>.\n";
        }
    }
;
#endif

  
enum posNear, posUnder, posBehind, posFront, posIn, posOn;

 /*
  *  A NestedSpace is a NestedRoom that can be used as the value of
  *  a locNear, locBehind or locUnder property instead of a room.
  *
  *  Note that it should only be used as such with objects that
  *  are NonPortable
  *
  *  NestedSpace is designed for use as an anonymous nested object, e.g.:
  *
  *  mirror : Fixture 'mirror' 'mirror'
  *     "It's hung high up on the wall. "
  *      locUnder : NestedSpace { actorInPrep = 'under' }
  *  ;
  */

class NestedSpace: Platform, Fixture

  /* By default we define targetObj as the lexicalParent, but this
   * can be overridden to point to another object if it is desired to
   * define a NestedSpace a separate object for any reason.
   */
  targetObj = (lexicalParent)

  /*
   *   Take our name and location from our targetObj; we don't use NameAsParent
   *   to do this since it has a lot of mappings we don't want.
   */

  name = (targetObj.name)
  theName = (targetObj.theName)
  aName = (targetObj.aName)
  isPlural = (targetObj.isPlural)
  location = (targetObj.location)
  
  contentsLister = generalContentsLister  
  lookInLister = generalContentsLister

  hideFromDefault(action)
    {
        return (!action.ofKind(GoAwayFromAction)
                && !action.ofKind(GetOutOfAction)
//                && !action.ofKind(GetOffOfAction)
                && inherited(action));
    }

  dobjFor(GoAwayFrom)
  {
    preCond { return preCondDobjGetOutOf; }
    verify()
    {
       if(gActor.isIn(self))
         logicalRank(150, 'actor in me');
       else
         illogicalNow(&alreadyAwayFromMsg);
    }
    check() { checkDobjGetOutOf; }
    action() { actionDobjGetOutOf; }
  }
  
  

  /*
   *  We define the next two methods using tryImplictActionMsg in order
   *  to obtain more appropriate reports of implicit actions when the
   *  player char is moved into or out of us implicitly.
   */

   tryRemovingFromNested()
   {
      return tryImplicitActionMsg(&leaveNestedSpaceMsg, GetOutOf, self);
   }

  /* The following is necessary to prevent an OUT command resulting
   * in a "What do you want to get out of?" message instead of just
   * taking the actor out.
   */
   tryMovingIntoNested()
   {
      return tryImplicitActionMsg(&enterNestedSpaceMsg, StandOn, self);
   }


   /*
    *  By default we'll assume that an OUT command should take an actor out
    *  of this NestedSpace. If instead you want an OUT command to take an
    *  actor out of the NestedSpace's outermost room, where this defines
    *  an out property, change this to nil.    *
    */
    
   out: nestedRoomOut { travelAction = GoAwayFromAction } 
//    out = nil  
   
   dobjFor(StandOn)
   {
      verify()  {  nonObvious;  }
   }
   dobjFor(SitOn)
   {
      verify()
      {
        if(gActor.isIn(self) || gActor.posture == sitting)
          inherited;
        else
          nonObvious;
      }
   }
   dobjFor(LieOn)
   {
      verify()
      {
        if(gActor.isIn(self) || gActor.posture == lying)
          inherited;
        else
          nonObvious;
      }
   }
   
   
   
   /* if the player types GET OUT/OFF, make it clear that we're interpreting it as
    * MOVE AWAY FROM
    */
   
   disembarkRoom()
   {
      if(gActionIs(GetOut))
      {
        nestedAction(GoAwayFrom, self);
        if(CSGetOutermostRoom.out != nil && out == nil)
          nestedAction(TravelVia,CSGetOutermostRoom.out);
        else if(!gAction.isImplicit)
          mainReport(&okayMoveAwayFromMsg, self);
      }
      else
        inherited;
   }
   
   
;



//-----------------------------------------------------------------------------
//    New and modified verbs for ConSpace & EnterableComplexContainer
//-----------------------------------------------------------------------------


DefineTIAction(PutNear);

DefineTIAction(PutInFront);

DefineTAction(StandInFront);

DefineTAction(StandNear);

DefineTAction(StandUnder);

DefineTAction(StandBehind);

DefineTAction(StandIn);

DefineTAction(SitInFront);

DefineTAction(SitNear);

DefineTAction(SitUnder);

DefineTAction(SitBehind);

DefineTAction(SitIn);

DefineTAction(LieInFront);

DefineTAction(LieNear);

DefineTAction(LieUnder);

DefineTAction(LieBehind);

DefineTAction(LieIn);

DefineTAction(WalkOverTo);

DefineTAction(GoAwayFrom);

DefineTAction(GoFromUnder);

DefineTAction(GoFromBehind);

DefineTAction(GetUnder);



/* ================================================================*\
|*   Modifications to library classes, to support the new verbs.   *|
\* =============================================================== */


modify TravelPushable
    dobjFor(PutNear) { verify() { inherited Thing;}  }
    dobjFor(MoveTo) asDobjFor(PutNear)
;

modify Thing

    dobjFor(PutUnder) { preCond = [objHeld] }

    dobjFor(StandIn)
    {
        preCond = [touchObj]
        verify() { illogical(&cannotStandCloseMsg, posIn); }
    }

    dobjFor(SitIn) asDobjFor(SitOn)    

    dobjFor(LieIn) asDobjFor(LieOn)
    
    dobjFor(SitOn)
    {
        preCond = [touchObj]
        verify() { illogical(&cannotSitCloseMsg, posOn); }
    }

    dobjFor(LieOn)
    {
        preCond = [touchObj]
        verify() { illogical(&cannotLieCloseMsg, posOn); }
    }
;


  /* Modification to BasicPlatform enforce restrictions on standing
   * and also use custom listers.
   */
   
modify BasicPlatform

  /* Don't allow the stand action here if standing is not one of our allowed Postures */

  makeStandingUp
   {
     if(allowedPostures.indexOf(standing) == nil)    
     {
         tryRemovingFromNested();
         if(gActor.isIn(self))  // the attempt to remove from nested failed
         {
           reportFailure(&noRoomToStandHereMsg);
           exit;
         }
     }     
     gActor.makePosture(standing);
     defaultReport(&okayNewPostureMsg); 
   }  
   
   /*
    *  If there's a Hidden object in me, mention that the player char
    *  discovers it when he enters me.
    */
   
   performEntry(posture)
    {
      local foundList = [];
      foreach(local cur in contents)
        if(cur.ofKind(Hidden) && !cur.discovered)
        {
          cur.discover();
          foundList += cur;
        }
      if (foundList.length > 0)
      {
         foundContentsLister.showCustomList(foundList, ListContents, 0, self);
      }
      inherited(posture);
    }
    
    
    /* Define my listers: for definitions of these listers see
     * Space_en_us.t
     */ 
    
    contentsLister = generalContentsLister
    lookInLister = generalContentsLister
    foundContentsLister = discoverContentsLister
;

 /*
  *  For BasicChair and its descendants we want a nearObj precondition run before
  *  the standard precondition so that the actor can be moved into the chair's
  *  staging location before the inherited precondition can stop the action
  *  before the actor moves.
  */


modify BasicChair
  dobjFor(SitOn)
  {
    preCond = [nearObjFirst] + nilToList(inherited);
  }  
  dobjFor(LieOn)  
  {
    preCond = [nearObjFirst] + nilToList(inherited);
  }
  dobjFor(StandOn)
  {
    preCond = [nearObjFirst] + nilToList(inherited);
  }
;

 /*
  *  For a NestedRoom we want the nearLoc to be the nearest enclosing roomLocation,
  *  not the NestedRoom itself.
  */

modify NestedRoom
  nearLoc = (location.roomLocation)
;