//
//  XTUIUtils.m
//  TadsTerp
//
//  Created by Rune Berg on 29/09/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTUIUtils.h"
#import "XTNotifications.h"
#import "XTLogger.h"


@implementation XTUIUtils

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTUIUtils class]];
}

- (void)showModalErrorDialogWithMessageText:(NSString *)messageText
{
	NSAlert *alert = [[NSAlert alloc] init];
	[alert setMessageText:messageText];
	NSAlertStyle alertStyle = NSWarningAlertStyle; //NSInformationalAlertStyle;
	[alert setAlertStyle:alertStyle];
	//TODO ideally call setIcon too
	[alert addButtonWithTitle:@"OK"];
	
	[XTNotifications notifyModalPanelOpened:self];

	NSInteger answer = [alert runModal];

	[XTNotifications notifyModalPanelClosed:self];
}

- (BOOL)confirmAbortRunningGameInWindow:(NSWindow *)window
							messageText:(NSString *)messageText
						informativeText:(NSString *)informativeText
			  continuePlayingButtonText:(NSString *)continuePlayingButtonText
				  quitPlayingButtonText:(NSString *)quitPlayingButtonText
{
	XT_DEF_SELNAME;
	
	BOOL res = NO; // default is: "continue playing"
	
	NSAlert *alert = [[NSAlert alloc] init];
	[alert setMessageText:messageText];
	[alert setInformativeText:informativeText];
	[alert addButtonWithTitle:continuePlayingButtonText];
	[alert addButtonWithTitle:quitPlayingButtonText];
	[alert setAlertStyle:NSWarningAlertStyle];
	
	NSInteger buttonIdx = [self runModalSheet:alert forWindow:window];

	if (buttonIdx != NSAlertFirstButtonReturn) {
		res = YES;
	}
	
	XT_TRACE_1(@"-> %d", res);
	
	return res;
}

- (NSInteger)runModalSheet:(NSAlert *)sheet forWindow:(NSWindow *)window
{
	// beginSheetModalForWindow doesn't block, but I found a solution here:
	// http://stackoverflow.com/questions/604768/wait-for-nsalert-beginsheetmodalforwindow
	// (Note: blocks in a app-global fashion, but we can live with that :-))

	XT_DEF_SELNAME;
	
	[XTNotifications notifyModalPanelOpened:self];

	[sheet beginSheetModalForWindow:window completionHandler:^(NSModalResponse returnCode) {
		[NSApp stopModalWithCode:returnCode];
	}];
	
	NSInteger modalCode = [NSApp runModalForWindow:window];
	
	[XTNotifications notifyModalPanelClosed:self];

	XT_TRACE_1(@"-> %d", modalCode);
	
	return modalCode;
}

- (NSURL *)runModalOpenDirectorySheetForWindow:(NSWindow *)window
						   defaultDirectoryUrl:(NSURL *)defaultDirectoryUrl
{
	XT_DEF_SELNAME;

	NSOpenPanel* panel = [NSOpenPanel openPanel];
	[panel setTitle:@"Select Directory"];
	[panel setCanChooseFiles:NO];
	[panel setCanChooseDirectories:YES];
	[panel setDirectoryURL:defaultDirectoryUrl];
	//TODO try to hide files
	
	NSURL* __block tempDirUrl = nil;

	[XTNotifications notifyModalPanelOpened:self];
	
	[panel beginSheetModalForWindow:window completionHandler:^(NSModalResponse returnCode) {
		tempDirUrl = [[panel URLs] objectAtIndex:0];
		XT_TRACE_2(@"completionHandler got: \"%@\" (%ld)", tempDirUrl, returnCode);
		[NSApp stopModalWithCode:returnCode];
	}];
	
	NSInteger modalCode = [NSApp runModalForWindow:window];
	
	[XTNotifications notifyModalPanelClosed:self];
	
	NSURL*  dirUrl = nil;
	if (modalCode == 1) {
		// "Open" selected
		dirUrl = tempDirUrl;
	}
	
	XT_TRACE_2(@"-> modalCode=%ld, dirUrl=\"%@\"", modalCode, dirUrl);
	
	return dirUrl;
}

@end
