//
//  XTGameWindowController.h
//  TadsTerp
//
//  Created by Rune Berg on 14/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XTGameRunnerProtocol.h"


@interface XTGameWindowController : NSWindowController <NSWindowDelegate, NSTextViewDelegate, XTGameRunnerProtocol>

@property BOOL gameIsRunning;

+ (XTGameWindowController *)controller;

- (BOOL)canLoadAndStartGameFile;

- (BOOL)loadAndStartGameFile:(NSURL *)gameFileUrl;

- (BOOL)confirmQuitGameIfRunning:(NSString *)informativeText;

- (BOOL)confirmQuitTerpIfGameRunning:(NSString *)informativeText;

- (void)quitGameIfRunning;

- (void)closeWindow;

- (BOOL)reloadGameFile;

//TODO very clumsy to have this here
- (BOOL)handleSelectAll;

- (BOOL)isWaitingForKeyPressed;

@end
