//
//  XTHtmlTagBasefont.m
//  XTads
//
//  Created by Rune Berg on 21/04/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTHtmlTagBasefont.h"
#import "XTFormattingSpecificationForHtmlTag.h"
#import "XTHtmlUtils.h"


@implementation XTHtmlTagBasefont

+ (NSString *)name
{
	return @"basefont";
}

+ (BOOL)standalone
{
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	// <basefont> is not a container, so do it here:
	
	XTFormattingSpecification *fmtSpec = [formatter getFormattingSpecificationForBasefont];
	
	[XTHtmlUtils extractBaseHtmlFontSizeFromTag:self toFormattingSpec:fmtSpec];
	fmtSpec.htmlSize = fmtSpec.baseHtmlSize;
	[XTHtmlUtils extractHtmlFontFaceFromTag:self toFormattingSpec:fmtSpec];
	[XTHtmlUtils extractHtmlFontColorFromTag:self toFormattingSpec:fmtSpec];

	[formatter setFormattingSpecificationForBasefont:fmtSpec];
}

@end
