//
//  XTTextView.h
//  XTads
//
//  Created by Rune Berg on 28/01/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XTPrefs.h"

@class XTOutputFormatter;


@interface XTTextView : NSTextView

@property XTPrefs *prefs;

@property (weak) XTOutputFormatter *outputFormatter;

@property (readonly) CGFloat leftRightInset;
@property (readonly) CGFloat topBottomInset;

@property BOOL tableCellChangedContentRect;

- (void)customInit;

- (void)teardown;

- (void)syncWithPrefs;

- (CGFloat)findTotalWidthAdjustedForInset;

- (CGFloat)findYCoordOfInsertionPoint;

- (BOOL)shouldLogDodgyReturnFromFindYCoordOfInsertionPoint;
	//TODO mv to private .h

- (CGFloat)findXCoordOfInsertionPointRaw;

- (CGFloat)findStartXCoordOfTextInRange:(NSRange)range;

- (CGFloat)findEndXCoordOfTextInRange:(NSRange)range;

- (void)ensureLayoutForTextContainer;

- (BOOL)recalcsTabsInLiveResize;

- (void)forceNewLayoutForTextContainer;

- (void)setInsertionPointAtEndOfText;

- (NSUInteger)endOfOutputPosition;

- (CGFloat)findCoordOfRhsOfView;

- (CGFloat)findCoordOfTabAtHalfwayToRhsOfViewFromLoc:(CGFloat)fromLoc;

- (CGFloat)findTotalHeight;

- (CGFloat)findVisibleHeight;

- (CGFloat)totalHorizontalInset:(BOOL)respectInsetsIfNoText;

- (CGFloat)totalVerticalInset:(BOOL)respectInsetsIfNoText;

- (void)scrollToBottom;

- (void)removeText:(NSRange)range;

- (void)removeLastChar;

- (void)removeAttributedStringFromEnd:(NSAttributedString *)attrString;

- (CGFloat)removeTextFromStart:(NSUInteger)numCharsToRemove;

- (void)removeTextFromEnd:(NSUInteger)numCharsToRemove;

- (NSString *)stringInRange:(NSRange)range;

@end
