//
//  XTLogger.h
//  TadsTerp
//
//  Created by Rune Berg on 14/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTLoggerLevel.h"
#import "XTLogConfig.h"

#define XT_DEF_SELNAME  NSString *selName = NSStringFromSelector(_cmd);
#define XT_SELNAME      selName
#define XT_TRACE_ENTRY  XT_DEF_SELNAME; [logger trace:@"%@ entry", XT_SELNAME];
#define XT_TRACE_0(fmt) [logger trace:@"%@ " fmt, XT_SELNAME];
#define XT_TRACE_1(fmt,arg1) [logger trace:@"%@ " fmt, XT_SELNAME, arg1];
#define XT_TRACE_2(fmt,arg1,arg2) [logger trace:@"%@ " fmt, XT_SELNAME, arg1, arg2];
#define XT_TRACE_3(fmt,arg1,arg2,arg3) [logger trace:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3];
#define XT_TRACE_4(fmt,arg1,arg2,arg3,arg4) [logger trace:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4];
#define XT_TRACE_5(fmt,arg1,arg2,arg3,arg4,arg5) [logger trace:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5];
#define XT_TRACE_6(fmt,arg1,arg2,arg3,arg4,arg5,arg6) [logger trace:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6];
#define XT_WARN_ENTRY  XT_DEF_SELNAME; [logger warn:@"%@ entry", XT_SELNAME];
#define XT_WARN_0(fmt) [logger warn:@"%@ " fmt, XT_SELNAME];
#define XT_WARN_1(fmt,arg1) [logger warn:@"%@ " fmt, XT_SELNAME, arg1];
#define XT_WARN_2(fmt,arg1,arg2) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2];
#define XT_WARN_3(fmt,arg1,arg2,arg3) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3];
#define XT_WARN_4(fmt,arg1,arg2,arg3,arg4) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4];
#define XT_WARN_5(fmt,arg1,arg2,arg3,arg4,arg5) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5];
#define XT_WARN_6(fmt,arg1,arg2,arg3,arg4,arg5,arg6) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6];
#define XT_WARN_7(fmt,arg1,arg2,arg3,arg4,arg5, arg6, arg7) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6, arg7];
#define XT_WARN_8(fmt,arg1,arg2,arg3,arg4,arg5, arg6, arg7, arg8) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8];
#define XT_WARN_9(fmt,arg1,arg2,arg3,arg4,arg5, arg6, arg7, arg8, arg9) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9];
#define XT_WARN_10(fmt,arg1,arg2,arg3,arg4,arg5, arg6, arg7, arg8, arg9, arg10) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10];
#define XT_WARN_12(fmt,arg1,arg2,arg3,arg4,arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12) [logger warn:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12];
#define XT_ERROR_ENTRY  XT_DEF_SELNAME; [logger error:@"%@ entry", XT_SELNAME];
#define XT_ERROR_0(fmt) [logger error:@"%@ " fmt, XT_SELNAME];
#define XT_ERROR_1(fmt,arg1) [logger error:@"%@ " fmt, XT_SELNAME, arg1];
#define XT_ERROR_2(fmt,arg1,arg2) [logger error:@"%@ " fmt, XT_SELNAME, arg1, arg2];
#define XT_ERROR_3(fmt,arg1,arg2,arg3) [logger error:@"%@ " fmt, XT_SELNAME, arg1, arg2, arg3];
#define XT_TRACE_ON ([XTLogConfig levelForName:logger.name] >= XT_LEVEL_TRACE)


@interface XTLogger : NSObject

@property NSString *name;

+ (instancetype)loggerForClass:(Class)aClass;

+ (instancetype)loggerForName:(NSString *)name;

- (id)initWithName:(NSString *)name;

- (void)trace:(NSString *)format, ...;

- (void)debug:(NSString *)format, ...;

- (void)info:(NSString *)format, ...;

- (void)warn:(NSString *)format, ...;

- (void)error:(NSString *)format, ...;

- (void)fatal:(NSString *)format, ...;

@end
