//
//  XTHtmlTagHx.m
//  XTads
//
//  Created by Rune Berg on 01/07/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTHtmlTagHx.h"
#import "XTHtmlTag_private.h"
#import "XTHtmlTagContainer_private.h"
#import "XTHtmlTagCenter.h"
#import "XTHtmlTagDiv.h"
#import "XTHtmlUtils.h"
#import "XTLogger.h"


@implementation XTHtmlTagHx

static XTLogger* logger;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTHtmlTagHx class]];
}

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	BOOL res = [self isAllowed];
	return res;
}

- (BOOL)blockLevelSpacingBefore
{
	BOOL res = [self isAllowed];
	return res;
}

- (BOOL)blockLevelSpacingAfter
{
	BOOL res = [self isAllowed];
	return res;
}

- (NSUInteger)headingHtmlFontSize
{
	XT_WARN_ENTRY(@"headingHtmlFontSize not overridden");
	return 3;
}

- (BOOL)shouldInheritHorizAlignmentFromContainer
{
	return [XTHtmlUtils tagIsEnclosedByDivOrCenter:self];
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	XTHtmlTagContainer *tagContainer = self.formattingSpecForHtmlTag.oldFormattingSpecForHtmlTag.tagContainer;
	if ([tagContainer isKindOfClass:[XTHtmlTagCenter class]] || [tagContainer isKindOfClass:[XTHtmlTagDiv class]]) {
		// nothing - keep container's text alignment
	} else {
		self.formattingSpecForHtmlTag.oldFormattingSpecForHtmlTag.formattingSpec.textAlignMode = XT_TEXT_ALIGN_LEFT;
	}
	
	[super formatExit:formatter textHandler:textHandler];
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationWithDefaults];
	
	// <h1> etc. are not allowed in lists
	if (! [self isAllowed]) {
		return res;
	}
	
	res.htmlSize = [self headingHtmlFontSize];
	res.bold = YES;
	
	res.inAboutBox = formattingSpec.inAboutBox;
	
	XTTextAlignMode defaultTextAlignMode = XT_TEXT_ALIGN_LEFT;
	if ([self shouldInheritHorizAlignmentFromContainer]) {
		defaultTextAlignMode = formattingSpec.textAlignMode;
	}
	res.textAlignMode = [self getTextAlignModeWithDefault:defaultTextAlignMode];
	
	res.isInHeader = YES;

	return res;
}

- (BOOL)isAllowed
{
	BOOL res = (! [self isInList]);
	return res;
}

@end
