//
//  XTTableInfo.h
//  XTads
//
//  Created by Rune Berg on 30/10/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextTableBlock.h"


//NS_ASSUME_NONNULL_BEGIN

@interface XTTableInfo : NSObject

- (void)noteMaxContentRectWidth:(CGFloat)width
					  forColumn:(NSInteger)column;

- (void)noteMinContentRectWidth:(CGFloat)width
					  forColumn:(NSInteger)column;

- (void)noteTotalBoundsWidthForTextTableBlock:(XTTextTableBlock *)textTableBlock
									   	width:(CGFloat)width;

- (void)noteBoundsRectWidthForTextTableBlock:(XTTextTableBlock *)textTableBlock
									   width:(CGFloat)width;

- (CGFloat)contectRectWidthForTextTableBlock:(XTTextTableBlock *)textTableBlock
								 usableWidth:(CGFloat)usableWidth;

- (CGFloat)contentRectXForTextTableBlock:(XTTextTableBlock *)textTableBlock
								 originX:(CGFloat)originX
							 usableWidth:(CGFloat)usableWidth;

- (CGFloat)totalTableWidth;

- (CGFloat)visualWidthInclColumnMarginOfTableUpToColumn:(NSInteger)column;

- (void)clear;

@end

//NS_ASSUME_NONNULL_END
