/* use the HTML status line and prompts */
#define USE_HTML_STATUS
#define USE_HTML_PROMPT

/* include the standard WorldClass library */
#include <World.t>
#include <wcInvent.t>
#include <wcLook.t>

/* player character */
Me: Player
  location = busStop
  locationtype = 'in'
  position = 'standing'
  isme = true
  noun = 'me' 'you' 'myself' 'yourself'
;

modify global
  verbose = true
;

replace intro: function
{
  "\bThe Ticket\b";
  "While standing on the bus stop my bus ticket has been blown away, can you help me to find it?\b\b";
}

busStop: Sensor, Room
  sdesc = "The Bus Stop"
  ldesc = "I'm standing by a bus stop, on a road which runs North to South. To the West a park gate set in iron railings stands open. "
  goWest = byBench
  enter(actor) = {
    inherited Room.enter(actor);
    if (self.cansee(ticket, nil, true)) {
      "\bThe bus arrives. I hand the ticket to the driver who smiles and says \"Sorry I'm late, hope you haven't been standing too long?\" ";
      end();
    }
  }
;

onGrass: Room
  sdesc = "On the Grass"
  ldesc = "The grass on which I stand is neatly trimmed. To the North is a path and bench while to the West is an ornamental pond. "
  goNorth = byBench
  goWest = byPond
  goNorthwest = byTree
  ground = grass
;

byBench: Room
  sdesc = "By the Bench"
  ldesc = "I am on a gravel path running East to West, by a park bench. To the South is a grassy area while to the North I can see a bandstand. "
  goNorth = bandstand
  goSouth = onGrass
  goEast = busStop
  goWest = byTree
  goSouthwest = byPond
  ground = path
;

bandstand: Room
  sdesc = "The Bandstand"
  ldesc = "I am standing on the bandstand which appears to be made of ornate cast iron painted white. To the South is a path. "
  goSouth = byBench
  verGoSoutheast(actor) = {
    if (actor = bird)
      return;
    else
      "\^<<actor.subjthedesc>> can't go that way.";
      return;
  }
  goSoutheast = upTree
  roomdrop(actor, obj) = {
    inherited Room.roomdrop(actor, obj);
    if (obj = sandwich and bird.location = self and ticket.isin(bird)) {
      "\nThe bird drops the ticket to peck at the sandwich. ";
      ticket.movein(self);
    }
  }
;

byPond: Room
  sdesc = "The Ornamental Pond"
  ldesc = "The sun glitters on the surface of the ornamental pond, whose waters ripple in the gentle breeze. A path runs North towards a large tree, while to the East is a grassy area. "
  goNorth = byTree
  goEast = onGrass
  goNortheast = byBench
;

byTree: Room
  sdesc = "By the Tree"
  ldesc = "The path curves South and East here beside a large tree. "
  goSouth = byPond
  goEast = byBench
  goSoutheast = onGrass
  goUp = upTree
;

upTree: Room
  sdesc = "Up the Tree"
  ldesc = "I am sitting on a branch in a broad-leaved tree. The park is spread out before me, to the East I can see the bus stop through the gate in the railings. "
  goDown = byTree
  verGoNorthwest(actor) = {
    if (actor = bird)
      return;
    else
      "\^<<actor.subjthedesc>> can't go that way.";
      return;
  }
  goNorthwest = bandstand
  roomdrop(actor, obj) = {
    byTree.ioPutX(actor, obj, 'in');
    " \^<<obj.subjthedesc>> fall<<obj.isplural ? "" : "s">> to the ground at the foot of the tree. ";
  }
;

torch: Lightsource
  sdesc = "torch"
  noun = 'torch'
  location = Me
;

bag: Openable, Item
  sdesc = "bag"
  noun = 'bag'
  location = busStop
  hdesc = "Someone has left a battered old bag at the foot of the \"Bus Stop\" sign. "
;

sandwich: Edible
  sdesc = "sandwich"
  ldesc = "It's a cheese and pickle sandwich. "
  noun = 'sandwich'
  location = Me
  doTake(actor) = {
    if (bird.cansee(self, nil, true))
      bird.pausectr := bird.pauseturns;
    pass doTake;
  }
;

apple: Edible
  sdesc = "apple"
  adesc = "an apple"
  ldesc = "The apple is crisp and green. "
  noun = 'apple'
  location = Me
;

ticket: Item
  sdesc = "ticket"
  ldesc = "The ticket has <b>\"City Bus Company\"</b> printed on it. "
  noun = 'ticket'
  location = bird
;

lead: Attachable
  sdesc = "lead"
  noun = 'lead'
  location = onGrass
  hdesc = "An old discarded lead lies on the grass. "
  maxattachments = 2
  attachesto = [dog bench]
  tieable = true
  plugable = nil
;

anorak: Clothing
  sdesc = "anorak"
  adesc = "an anorak"
  noun = 'anorak'
  location = Me
  isworn = true
;

grass: Ground
  sdesc = "grass"
  noun = 'ground' 'floor' 'grass'
  location = onGrass
;

path: Ground
  sdesc = "gravel path"
  noun = 'ground' 'floor' 'path'
  adjective = 'gravel'
  location = byBench
;

sign: Decoration
  sdesc = "\"Bus Stop\" sign."
  noun = 'sign' 'stop'
  adjective = 'bus' 'stop'
  location = busStop
;

gate: Decoration
  sdesc = "park gate"
  noun = 'gate'
  adjective = 'park'
  location = busStop
;

railings: Decoration
  sdesc = "iron railings"
  noun = 'railings'
  adjective = 'iron'
  location = busStop
  isplural = true
;

bench: Attachpoint, Stool
  sdesc = "park bench"
  ldesc = "The bench is firmly screwed to a concrete base. "
  noun = 'bench'
  adjective = 'park'
  location = byBench
;

bstand: Decoration
  sdesc = "bandstand"
  noun = 'bandstand'
  location = bandstand
;

pond: Decoration
  sdesc = "ornamental pond"
  noun = 'pond' 'water'
  adjective = 'ornamental'
  location = byPond
;

tree: Decoration
  sdesc = "tree"
  noun = 'tree'
  location = byTree
  verDoClimb(actor) = { }
  doClimb(actor) = {
    actor.travelto(upTree);
  }
;

branch: Decoration
  sdesc = "branch"
  noun = 'branch' 'branches'
  location = upTree
;

bird: Trackactor, animalActor
  sdesc = "small bird"
  noun = 'bird'
  adjective = 'small'
  leavemessage(dir) = "\nThe bird flies away. "
  entermessage(dir) = {
    "\nA small bird ";
    if (self.location = upTree)
      "lands on the branch. ";
    else
      "settles on the ground. ";
    if (ticket.isin(self))
      "The bird has a ticket in its beak. ";
  }
  location = upTree
  track = ['northwest' 'southeast']
  arrival(loc, loctype) = {
    if (self.cansee(dog, nil, true)) {
      self.pausectr := self.pauseturns;
      inherited Trackactor.moveDaemon;
    }
    if (loc = sandwich.location and ticket.isin(self)) {
      local seen := parserGetMe().cansee(loc, loctype, true);
      if (seen) "The bird drops the ticket to peck at the sandwich. ";
      ticket.movein(loc);
    }
  }
  departure(loc, loctype) = {
    if (loc = ticket.location) {
      local seen := parserGetMe().cansee(loc, loctype, true);
      if (seen) "\nThe bird snatches the ticket. ";
      ticket.movein(self);
    }
  }
  moveDaemon = {
    if (self.cansee(dog, nil, true))
      self.pausectr := self.pauseturns;
    inherited Trackactor.moveDaemon;
  }
;

dog: Attachpoint, Male, animalActor
  sdesc = "dog"
  noun = 'dog'
  location = busStop
  ldesc = {
    "The dog's bright eyes stare at me with mindless love. ";
    if (find(self.attachedto, lead)) {
      if (find(bench.attachedto, lead))
        "The dog is tied to the bench by a lead. ";
      else
        "A lead trails behind the dog. ";
    }
  }
  isSitting = nil
  actordesc = {
    "\^<<self.subjadesc>> <<self.is>> here. ";
    if (self.isSitting)
      "The dog is sitting quietly. ";
  }
  moveDaemon = {
    if (self.location <> parserGetMe().location and parserGetMe().location <> upTree and not self.isSitting and not (find(self.attachedto, lead) <> nil and find(bench.attachedto, lead) <> nil)) {
      Outhide(true);
      self.travelto(parserGetMe().location);
      Outhide(nil);
      "\bThe dog follows me wagging his tail. ";
      if (find(self.attachedto, lead)) {
        lead.movein(parserGetMe().location);
        "A lead trails behind the dog. ";
      }
      if (bird.cansee(self, nil, true)) {
        bird.moveDaemon;
      }
    }
  }
  actorAction(v, d, p, i) = {
    if ((v <> sitVerb and v <> comeVerb and v <> sitonVerb and v <> stayVerb) or (v = sitonVerb and not isclass(d, Floor))) {
      self.aamessage(v, d, p ,i);
      exit;
    }
  }
;

modify Floor
  doSiton(actor) = {
    if (actor = dog) {
      "The dog is sitting quietly. ";
      dog.isSitting := true;
    }
    else
      pass doSiton;
  }
;

comeVerb: Soloverb
  sdesc = "come here"
  verb = 'come' 'here'
  soloaction(actor) = {
    if (actor = parserGetMe()) {
      "<<actor.subjthedesc>> <<actor.is>> already here! ";
      abort;
    }
    if (actor = dog) {
      if (find(dog.attachedto, lead) <> nil and find(bench.attachedto, lead) <> nil) {
        "The dog looks at me and whines. ";
      }
      else {
        "The dog follows me wagging his tail. ";
        dog.isSitting := nil;
      }
    }
  }
;

stayVerb: Soloverb
  sdesc = "stay"
  verb = 'stay'
  soloaction(actor) = {
    if (actor = parserGetMe()) {
      waitVerb.soloaction(actor);
    }
    else if (actor = dog) {
      local e := execCommand(actor, sitVerb);
    }
  }
;

