#include <World.t>
#include <wcInvent.t>
#include <wcLook.t>
#include <wcGoto.t>

announce: function(val)
{
  if (global.pamessage or not paSwitch.isactive) {
    global.pamessage := nil;
    return;
  }
  switch(rnd(9)) {
    case 1:
    case 2:
    case 3:
    case 4:
      break;
    case 5:
      "\b\"Travellers are reminded that parking in the red zone is strictly prohibited.\"\n";
      global.pamessage := true;
      break;
    case 6:
      "\b\"Would Mr <<rnd(2) = 1 ? "Smith" : "Jones">> please pick up the <<rnd(2) = 1 ? "White" : "Green">> courtesy phone.\"\n";
      global.pamessage := true;
      break;
    case 7:
      "\b\"This is the final call for flight UA1234 to New York. Would all passengers please proceed to gate 3. Please have your tickets ready for inspection.\"\n";
      global.pamessage := true;
      break;
    case 8:
      "\b\"All travellers are reminded to keep their valuables safe.\"\n";
      global.pamessage := true;
      break;
    case 9:
      "\b\"All travellers are reminded not to leave their luggage unattended. Any unattended luggage will immediately be detonated.\"\n";
      global.pamessage := true;
      break;
  }
}

replace initCommon: function
{
  setdaemon(&announce, 0);
}

Me: Player
	location = terminal
;

terminal: Room
	sdesc = "Terminal"
	ldesc = "This is the airport's main terminal. Ticket counters lie to the east; to the north is the main concourse. "
	noun = 'terminal'
	goEast = ticketCounter
	goNorth = securityGate
  goSouth(actor) = {
    if (not global.justTesting)
      "The vast bustle of people prevents you from leaving the airport. ";
    return (nil);
  }
;

ticketCounter: Room
	sdesc = "Ticket Counter"
	ldesc = {
	  "This is the ticket counter area. Ticket counters line the north wall; ";
	  if (tcSwitch.isactive)
	    "so many people are waiting in line that it would be virtually impossible to get to a ticket clerk. ";
    else
      "yet the area is surprisingly devoid of people. ";
	  "The main terminal is back to the west. ";
	}
	goWest = terminal
;

ticketClerks: Female, humanActor
  location = ticketCounter
  sdesc = "ticket clerks"
  ldesc = {
    "The ticket clerks wear the drab uniform common to airport staff everywhere. ";
    if (tcSwitch.isactive)
      "The clerks are frantically checking people in as quickly as they can, but the queue does not appear to be getting any shorter. ";
    else
      "The clerks are sitting around, idly twiddling their thumbs and chatting amongst themselves. ";
  }
  heredesc = "A line of ticket clerks sit behind a row of check-in desks. "
  isplural = true
  noun = 'clerk' 'clerks'
  adjective = 'ticket'
	takesall = nil
	takelist = []
	ioGiveto(actor, dobj) = {
	  if (dobj = ticket) {
	    if (tcSwitch.isactive)
  	    "So many people are waiting in line that it would be virtually impossible to get to a ticket clerk. ";
	    else
  	    "\^<<actor.subjthedesc>> hand<<actor.isplural ? "" : "s">> <<ticket.objthedesc(actor)>> to one of <<self.objthedesc(actor)>>. \"I'm sorry,\" she says, \"but I can't check you in at the moment because the computer isn't working.\" ";
	  }
	  else
  	  pass ioGiveTo;
	}
;

securityGate: Room
	sdesc = "Security Gate"
	ldesc = "This is the security gate leading into the main concourse and boarding gate areas. The concourse lies to the north. The terminal is back to the south. "
	goNorth(actor) = {
		if (IDcard.isin(actor) and mdSwitch.isactive and not global.justTesting) {
      "As you pass through the metal detector, there is a loud \"Bing!\" The security guard steps forward and frisks you. Finding the ID card, he confiscates it before allowing you to pass.\b";
      IDcard.movein(counter);
    }
    return (concourse);
	}
	goSouth = terminal
;

metalDetector: Sensor, Fixture
	location = securityGate
	noun = 'detector'
	adjective = 'metal'
	sdesc = "metal detector"
	heredesc = "A metal detector sits across the passageway leading north to the councourse. "
;

securityGuard: Male, humanActor
	location = securityGate
	noun = 'guard'
	adjective = 'security'
	sdesc = "security guard"
  ldesc = "The security guard wears the uniform of <b>Acme Security Inc</b>. He has the sort of face that makes him look perpetually miserable, which he is. "
	takesall = nil
	takelist = []
;

concourse: Room
	sdesc = "Concourse"
	ldesc = "This long hallway connects the terminal building (which lies to the south) to the boarding gates (which are to the north). To the east is a snack bar, and a door leads west. "
	goNorth = gateArea
	goSouth = securityGate
	goEast = snackBar
	goWest = securityDoorOut
;

securityArea: Room
	sdesc = "Security Area"
	ldesc = "This area is normally off-limits to passengers. To the south is the pilot's lounge, where the pilots and crew relax between flights; to the west is the security control centre. The rest of the airport lies to the east, through the security door. "
	goSouth = pilotLounge
	goWest = securityCentre
	goEast = securityDoorIn
;

pilotLounge: Room
	sdesc = "Pilot's Lounge"
	ldesc = "This comfortably-furnished area is where the pilots and crew relax between flights, away from the hustle and bustle of the airport at large. Other parts of the security area lie to the north. "
	goNorth = securityArea
;

securityCentre: Room
	sdesc = "Security Control Centre"
	ldesc = "This small area is almost filled by a large desk arrangement with numerous television screens, from which security personnel can monitor the goings-on in the airport. Unsurprisingly, the area is devoid of security guards. Other parts of the security area lie to the east. "
	goEast = securityArea
;

snackBar: Room
	sdesc = "Snack Bar"
	ldesc = "This area is where the hungry or thirsty traveller can come to purchase any of the edible goods that are on display. Seating is provided for about twenty people, of which approximately zero are occupied, so the overall impression is more <i>Marie Celeste</i> than O'Hare International. The concourse lies to the west. "
	goWest = concourse
;

coffeeDispenser: Fixture
  location = snackBar
  sdesc = "coffee dispenser"
  noun = 'dispenser'
  adjective = 'coffee'
  ldesc = {
    "The coffee dispenser is one of those high-tech devices which, at the touch of a button, effortlessly dispenses enough scalding hot coffee to fill a standard-size coffee cup to the brim. <<note(self)>> ";
    if (not sbSwitch.isactive)
      "\bThe dispenser does not currently appear to be working. ";
  }
  footnote = "So why do they use smaller cups? "
  heredesc = "A coffee dispenser sits on the bar. "
;

barSteward: Male, humanActor
	location = snackBar
	noun = 'steward'
	adjective = 'bar'
	sdesc = "bar steward"
  ldesc = {
    "The bar steward<<note(self)>> wears the dreary uniform common to airport staff everywhere. ";
    if (sbSwitch.isactive)
      "He is whistling a merry tune as he <<rnd(2) = 1 ? "refills the coffee dispenser" : "cleans the tea cups">>. ";
    else
      "He is inspecting the coffee dispenser carefully, a worried frown on his face. ";
  }
	takesall = nil
	takelist = []
	footnote = "Stop that sniggering!"
;

gateArea: Room
	sdesc = "Gate Area"
	ldesc = "This open area is where passengers wait to board their flightsthrough one of the gates that stand to the north, northwest, and northeast. A small maintenance room sits to the east, and the main concourse is to the south. "
	goNorthwest = gate1
	goNorth = gate2
	goNortheast = gate3
	goSouth = concourse
	goEast = doorOut
;

maintenanceRoom: Room
	sdesc = "Maintenance Room"
	ldesc = "This small room contains the main generator for the airport. The gate area lies to the west. "
	noun = 'mroom'
	goWest = doorIn
;

gate1: Room
	sdesc = "Gate 1"
	ldesc = "This is boarding gate number 1. The jetway leads westwards to the plane. The main gate area is to the southeast. "
	goSoutheast = gateArea
  verGoWest(actor) = {
    "The door is closed. ";
  }
;

gate2: Room
	sdesc = "Gate 2"
	ldesc = "This is boarding gate number 2. The jetway leads northwards to the plane. The main gate area is to the south. "
	goSouth = gateArea
  verGoNorth(actor) = {
    "The door is closed. ";
  }
;

gate3: Room
	sdesc = "Gate 3"
	ldesc = "This is boarding gate number 3. The jetway leads eastwards to the plane. The main gate area is to the southwest. "
	verGoEast(actor) = {
		if (not stewardess.cansee(ticket, nil, true))
			"\^<<stewardess.subjthedesc>> stops <<actor.objthedesc(stewardess)>>. \"I'm sorry,\" she says, \"but you cannot board the flight without a valid ticket.\" ";
	}
	goEast(actor) = {
    if (not global.justTesting)
      "\^<<stewardess.subjthedesc>> smiles at <<actor.objthedesc(stewardess)>> as <<actor.objprodesc(stewardess)>> pass<<actor.isplural? "" : "es">>.\b";
	  return (jetway3);
	}
	goSouthwest = gateArea
;

stewardess: Female, humanActor
	location = gate3
	noun = 'stewardess'
	sdesc = "stewardess"
	takesall = nil
	takelist = [ticket]
  ldesc = "The stewardess wears the colourful uniform of <b>Untied Airlines</b>. Her face is permanently fixed in an insincere smile. "
;

jetway3: Room
	sdesc = "Jetway"
	ldesc = "The jetway leads eastwards to the front of the plane, and westwards to the boarding gate. "
	noun = 'jetway'
	goEast = planeFront
	goWest = gate3
;

planeFront: Room
	sdesc = "Front of Plane"
	ldesc = "The front section of the plane is filled with comfortable seats. Cheaper seats lie to the south, and the cockpit is to the north. The jetway leads westwards into the airport. "
	verGoNorth(actor) = {
		if (not (uniform.isin(actor) and uniform.isworn)) {
      "The flight attendant stops you. \"I'm sorry,\" he says, \"but only crew members are allowed to enter the cockpit.\" ";
    }
	}
	goNorth(actor) = {
    if (not global.justTesting)
      "The flight attendant salutes you limply as you pass.\b";
    return (cockpit);
  }
  goSouth = planeRear
	goWest = jetway3
;

flightAttendant: Male, humanActor
	location = planeFront
	noun = 'attendant'
	adjective = 'flight'
	sdesc = "flight attendant"
  ldesc = "The flight attendant wears the smart uniform of <b>Untied Airlines</b>, although it looks to be a couple of sizes too small for him. "
	takesall = nil
	takelist = [suitcase]
;

planeRear: Room
	sdesc = "Rear of Plane"
	ldesc = "The rear section of the plane is filled with cheap and tatty seats, stained with tobacco and spilt coffee. More comfortable seats lie to the north, and the bathroom is to the south. "
	goNorth = planeFront
	goSouth = bathroom
;

bathroom: Room
	sdesc = "Bathroom"
	ldesc = "This is the bathroom of the plane. Seats lie to the north. "
	goNorth = planeRear
;

cockpit: Room
	sdesc = "Cockpit"
	ldesc = "This is the cockpit. A confusing array of knobs, buttons, and dials cover the dashboard. The main body of the plane lies to the south. "
	noun = 'cockpit'
	goSouth = planeFront
;

counter: Surface
	location = ticketCounter
	noun = 'counter'
	adjective = 'ticket'
	sdesc = "ticket counter"
;

IDcard: Item
	location = counter
	locationtype = 'on'
	noun = 'card'
	adjective = 'id' 'identification'
	sdesc = "ID card"
	adesc = "an ID card"
;

newspaper: Readable, Item
	location = snackBar
	noun = 'newspaper' 'paper'
	adjective = 'news'
	sdesc = "newspaper"
	ldesc = "It's today's copy of \"USA YESTERDAY\". "
	hdesc = "A discarded newspaper lies on one of the tables."
	readdesc = "The federal deficit just went up by another twenty billion dollars, but it's all \"off budget,\" so it doesn't really count. There's another White House scandal involving illegal arms sales, money laundering through Italian banks, Congressional Pages; several high-ranking federal arts critics have laready resigned in disgrace. The economy had yet another downturn, but the President says he's confident that the recovery is \"just around the corner and picking up steam.\"<<note(self)>> "
	footnote = "Same old, same old. "
	doTake(actor) = {
		if (not self.foundTicket) {
			"As <<actor.subjthedesc>> <<actor.isplural ? "pick" : "picks">> up the paper, an airline ticket that was inside falls to the floor.\n";
			ticket.movein(actor.location);
			ticket.makeknownto(actor);
			self.foundTicket := true;
		}
		pass doTake;
	}
;

ticket: Item
	noun = 'ticket'
	adjective = 'airline'
	sdesc = "airline ticket"
	ldesc = "It's a one-way ticket to New York, in class C<<note(self)>>. "
	footnote = "The \"C\" probably stands for \"Cattle\". "
;

cardslot: Fixture
	location = concourse
	heredesc = "Next to the door to the west is a small slot that looks like it accepts magnetic ID cards to operate the door lock. "
	noun = 'slot'
	adjective = 'card'
	sdesc = "card slot"
	ldesc = "The slot appears to accept special ID cards with magnetic encoding. If you had an appropriate ID card, you could put it in the slot to open the door.<<note(self)>> "
	footnote = "No more clues. "
	acceptsput = true
	verIoPutin(actor) = { }
	ioPutin(actor, dobj) = {
		if (dobj = IDcard) {
			"\^<<actor.subjthedesc>> <<putVerb.desc(actor)>> <<IDcard.objthedesc(actor)>> in <<self.objthedesc(actor)>>. ";
			if (securityDoorOut.isopen)
				"Nothing happens. ";
			else {
				"There is a &ltclick&gt, and the security door swings open. ";
				securityDoorOut.setIsopen(true);
			}
		}
		else {
			"That doesn't seem to fit in the slot. ";
		}
	}
;

suitcase: Openable, Item
	isopen = nil
	location = pilotLounge
	noun = 'suitcase' 'case'
	sdesc = "suitcase"
;

uniform: Clothing
	location = suitcase
	noun = 'uniform'
	adjective = 'pilot' 'pilot\'s'
	sdesc = "pilot's uniform"
	ldesc = "It's a uniform for an 'Untied Airlines' pilot. It's a little large for you, but you could probably wear it.<<note(self)>> "
	footnote = "How come virtually all clothing found in an adventure game will fit the hero? "
;

mrKey: Key, Item
	location = bathroom
	noun = 'key'
	sdesc = "key"
;

pail: Item
	location = bathroom
	noun = 'pail' 'bucket'
	sdesc = "pail"
;

sponge: Item
	location = bathroom
	noun = 'sponge'
	sdesc = "sponge"
;

garbageBag: Container, Item
	location = bathroom
	noun = 'bag' 'sack'
	adjective = 'garbage' 'rubbish'
	sdesc = "garbage bag"
;

doorOut: Door
	location = gateArea
	isopen = nil
	islocked = true
	noun = 'door'
	sdesc = "door"
  ldesc = "The door has a label reading <b>MAINTENANCE ROOM</b>. "
	doordest = maintenanceRoom
	otherside = doorIn
	key = mrKey
;

doorIn: Door
	location = maintenanceRoom
	isopen = nil
	islocked = true
	noun = 'door'
	sdesc = "door"
	doordest = gateArea
	otherside = doorOut
	key = mrKey
;

powerPanel: Fixture
	location = maintenanceRoom
	noun = 'panel'
	adjective = 'power'
  heredesc = "There is a power panel here, with a number of switches. "
	sdesc = "power panel"
	ldesc = "The power panel has a number of switches. They are marked \"<b>MAIN LIGHTS</b>\", \"<b>METAL DETECTOR</b>\", \"<b>SNACK BAR</b>\", \"<b>TICKET COUNTER</b>\", and \"<b>PUBLIC ADDRESS</b>\". "
;

mdSwitch: Switch, Part
  location = maintenanceRoom
  partof = powerPanel
  sdesc = "metal detector switch"
  noun = 'detector' 'switch'
  adjective = 'metal'
  ldesc = "The switch marked \"<b>METAL DETECTOR</b>\" is currently <<self.isactive ? "ON" : "OFF">>. "
  isactive = true
;

sbSwitch: Switch, Part
  location = maintenanceRoom
  partof = powerPanel
  sdesc = "snack bar switch"
  noun = 'bar' 'switch'
  adjective = 'snack'
  ldesc = "The switch marked \"<b>SNACK BAR</b>\" is currently <<self.isactive ? "ON" : "OFF">>. "
  isactive = true
;

tcSwitch: Switch, Part
  location = maintenanceRoom
  partof = powerPanel
  sdesc = "ticket counter switch"
  noun = 'counter' 'switch'
  adjective = 'ticket'
  ldesc = "The switch marked \"<b>TICKET COUNTER</b>\" is currently <<self.isactive ? "ON" : "OFF">>. "
  isactive = true
;

paSwitch: Switch, Part
  location = maintenanceRoom
  partof = powerPanel
  sdesc = "public address system switch"
  noun = 'address' 'pa' 'switch'
  adjective = 'public'
  ldesc = "The switch marked \"<b>PUBLIC ADDRESS</b>\" is currently <<self.isactive ? "ON" : "OFF">>. "
  isactive = true
;

mlSwitch: Switch, Part
  location = maintenanceRoom
  partof = powerPanel
  sdesc = "main lights switch"
  noun = 'light' 'lights' 'switch'
  adjective = 'main' 'master'
  ldesc = "The switch marked \"<b>MAIN LIGHTS</b>\" is currently <<self.isactive ? "ON" : "OFF">>. "
  isactive = true
  doTurnoff(actor) = {
    local o;
    inherited Switch.doTurnoff(actor);
    for (o := firstobj(Room); o; o := nextobj(o, Room)) {
      if (o <> maintenanceRoom and not isclass(o, Nestedroom)) o.darken;
    }
  }
  doTurnon(actor) = {
    local o;
    inherited Switch.doTurnon(actor);
    for (o := firstobj(Room); o; o := nextobj(o, Room)) {
      if (o <> maintenanceRoom and not isclass(o, Nestedroom)) o.lighten;
    }
  }
;

securityDoorOut: Door
	location = concourse
	isopen = nil
	islocked = true
	noun = 'door'
	adjective = 'security'
	sdesc = "security door"
  ldesc = {
    "The door has a label reading <b>SECURITY AREA - AUTHORIZED PERSONNEL ONLY</b>. ";
    if (self.isopen)
      "The door is open, which isn't very secure. ";
    else
      "The door is securely closed. ";
  }
	doordest = securityArea
	otherside = securityDoorIn
	key = noKey
;

securityDoorIn: Door
	location = securityArea
	isopen = nil
	islocked = true
	noun = 'door'
	adjective = 'security'
	sdesc = "security door"
	doordest = concourse
	otherside = securityDoorOut
	key = noKey
;

noKey: Key
;

modify global
  verbose = true
;
