//  tscodes.t
//    Predefined compiler symbols
//    Compatible with adv.t

//  All of these are included in ADV.T except the posture codes.
//  The datatype/proptype codes used in Pianosa differ from the ADV.T standard.
//   Since mine pre-existed and (in my opinion) are much clearer, I'll still use
//   them. Of course, I've gone ahead and included the ADV.T set as well.  Mine
//   begin with TYPE;  those from ADV.T begin with DTY.  You'll see what I mean.

//  posture codes
#define Stand 0
#define Sit 1
#define Lie 2

//  askfile() prompt type codes
#define ASKFILE_PROMPT_OPEN    1
#define ASKFILE_PROMPT_SAVE    2

//  askfile() file type codes 
#define FILE_TYPE_GAME    0
#define FILE_TYPE_SAVE    1
#define FILE_TYPE_LOG     2
#define FILE_TYPE_DATA    4
#define FILE_TYPE_CMD     5
#define FILE_TYPE_TEXT    7
#define FILE_TYPE_BIN     8
#define FILE_TYPE_UNKNOWN 11

//  askfile() request for extended return codes (arg. 4)
#define ASKFILE_EXT_RESULT     1

//  askfile() extended return codes
#define ASKFILE_SUCCESS        0
#define ASKFILE_FAILURE        1
#define ASKFILE_CANCEL         2

//  defined() flag
#define DEFINED_ANY         1
#define DEFINED_DIRECTLY    2
#define DEFINED_INHERITS    3
#define DEFINED_GET_CLASS   4

//  disambigDobj, disambigIobj status codes 
#define DISAMBIG_CONTINUE    1
#define DISAMBIG_DONE        2
#define DISAMBIG_ERROR       3
#define DISAMBIG_PARSE_RESP  4
#define DISAMBIG_PROMPTED    5

//  datatype(), proptype() codes from ADV.T
#define DTY_NUMBER  1
#define DTY_OBJECT  2
#define DTY_SSTRING 3
#define DTY_NIL     5
#define DTY_CODE    6
#define DTY_LIST    7
#define DTY_TRUE    8
#define DTY_DSTRING 9
#define DTY_FUNCPTR 10
#define DTY_PROP    13

//  execCommand() flags
#define EC_HIDE_SUCCESS   1
#define EC_HIDE_ERROR     2
#define EC_SKIP_VALIDDO   4
#define EC_SKIP_VALIDIO   8

//  execCommand() return codes
#define EC_SUCCESS        0
#define EC_EXIT           1013
#define EC_ABORT          1014
#define EC_INVAL_SYNTAX   1200
#define EC_VERDO_FAILED   1201
#define EC_VERIO_FAILED   1202
#define EC_NO_VERDO       1203
#define EC_NO_VERIO       1204
#define EC_INVAL_DOBJ     1205
#define EC_INVAL_IOBJ     1206

//  gettime() type codes
#define GETTIME_DATE_AND_TIME  1
#define GETTIME_TICKS          2

// inputdialog() button types
#define INDLG_ICON_NONE        0
#define INDLG_ICON_WARNING     1
#define INDLG_ICON_INFO        2
#define INDLG_ICON_QUESTION    3
#define INDLG_ICON_ERROR       4

//  inputdialog() predefined button sets
#define INDLG_OK               1
#define INDLG_OKCANCEL         2
#define INDLG_YESNO            3
#define INDLG_YESNOCANCEL      4

//  inputdialog() predefined buttons
#define INDLG_LBL_OK           1
#define INDLG_LBL_CANCEL       2
#define INDLG_LBL_YES          3
#define INDLG_LBL_NO           4

//  inputevent() event (return) codes
#define INPUT_EVENT_KEY        1
#define INPUT_EVENT_TIMEOUT    2
#define INPUT_EVENT_HREF       3
#define INPUT_EVENT_NOTIMEOUT  4
#define INPUT_EVENT_EOF        5

//  constants for parseNounPhrase return codes 
#define PNP_ERROR        1
#define PNP_USE_DEFAULT  2

//  constants for parserGetObj object codes 
#define PO_ACTOR    1
#define PO_VERB     2
#define PO_DOBJ     3
#define PO_PREP     4
#define PO_IOBJ     5
#define PO_IT       6
#define PO_HIM      7
#define PO_HER      8
#define PO_THEM     9

//  parserResolveObjects
#define PRO_RESOLVE_DOBJ  1
#define PRO_RESOLVE_IOBJ  2
#define PRO_RESOLVE_ACTOR 3

//  parser error codes
#define PRS_SUCCESS           0
#define PRSERR_BAD_PUNCT      1
#define PRSERR_UNK_WORD       2
#define PRSERR_TOO_MANY_OBJS  3
#define PRSERR_ALL_OF         4
#define PRSERR_BOTH_OF        5
#define PRSERR_OF_NOUN        6
#define PRSERR_ART_NOUN       7
#define PRSERR_DONT_SEE_ANY   9
#define PRSERR_TOO_MANY_OBJS2 10
#define PRSERR_TOO_MANY_OBJS3 11
#define PRSERR_ONE_ACTOR      12
#define PRSERR_DONT_KNOW_REF  13
#define PRSERR_DONT_KNOW_REF2 14
#define PRSERR_DONT_SEE_REF   15
#define PRSERR_DONT_SEE_ANY2  16
#define PRSERR_NO_MULTI_IO    25
#define PRSERR_NO_AGAIN       26
#define PRSERR_BAD_AGAIN      27
#define PRSERR_NO_MULTI       28
#define PRSERR_ANY_OF         29
#define PRSERR_ONLY_SEE       30
#define PRSERR_CANT_TALK      31
#define PRSERR_INT_PPC_INV    32
#define PRSERR_INT_PPC_LONG   33
#define PRSERR_INT_PPC_LOOP   34
#define PRSERR_DONT_SEE_ANY_MORE 38
#define PRSERR_DONT_SEE_THAT  39
#define PRSERR_NO_NEW_NUM     40
#define PRSERR_BAD_DIS_STAT   41
#define PRSERR_EMPTY_DISAMBIG 42
#define PRSERR_DISAMBIG_RETRY 43
#define PRSERR_AMBIGUOUS      44
#define PRSERR_TRY_AGAIN      100
#define PRSERR_WHICH_PFX      101
#define PRSERR_WHICH_COMMA    102
#define PRSERR_WHICH_OR       103
#define PRSERR_WHICH_QUESTION 104
#define PRSERR_DONTKNOW_PFX   110
#define PRSERR_DONTKNOW_SPC   111
#define PRSERR_DONTKNOW_ANY   112
#define PRSERR_DONTKNOW_TO    113
#define PRSERR_DONTKNOW_SPC2  114
#define PRSERR_DONTKNOW_END   115
#define PRSERR_MULTI          120
#define PRSERR_ASSUME_OPEN    130
#define PRSERR_ASSUME_CLOSE   131
#define PRSERR_ASSUME_SPC     132
#define PRSERR_WHAT_PFX       140
#define PRSERR_WHAT_IT        141
#define PRSERR_WHAT_TO        142
#define PRSERR_WHAT_END       143
#define PRSERR_WHAT_THEM      144
#define PRSERR_WHAT_HIM       145
#define PRSERR_WHAT_HER       146
#define PRSERR_WHAT_THEM2     147
#define PRSERR_WHAT_PFX2      148
#define PRSERR_WHAT_TOSPC     149
#define PRSERR_MORE_SPECIFIC  160
#define PRSERR_NOREACH_MULTI  200

//  "Parser noun-phrase flags."
#define PRSFLG_ALL      1
#define PRSFLG_EXCEPT   2
#define PRSFLG_IT       4
#define PRSFLG_THEM     8
#define PRSFLG_NUM      16
#define PRSFLG_COUNT    32
#define PRSFLG_PLURAL   64
#define PRSFLG_ANY      128
#define PRSFLG_HIM      256
#define PRSFLG_HER      512
#define PRSFLG_STR      1024
#define PRSFLG_UNKNOWN  2048
#define PRSFLG_ENDADJ   4096
#define PRSFLG_TRUNC    8192

//  "Parser word types."
#define PRSTYP_ARTICLE  1
#define PRSTYP_ADJ      2
#define PRSTYP_NOUN     4
#define PRSTYP_PREP     8
#define PRSTYP_VERB     16
#define PRSTYP_SPEC     32
#define PRSTYP_PLURAL   64
#define PRSTYP_UNKNOWN  128

//  restore() return codes
#define RESTORE_SUCCESS          0
#define RESTORE_FILE_NOT_FOUND   1
#define RESTORE_NOT_SAVE_FILE    2
#define RESTORE_BAD_FMT_VSN      3
#define RESTORE_BAD_GAME_VSN     4
#define RESTORE_READ_ERROR       5
#define RESTORE_NO_PARAM_FILE    6

//  datatype(), proptype() codes
#define TYPE_NUMBER            1
#define TYPE_OBJECT            2
#define TYPE_SINGLE            3
#define TYPE_NIL               5
#define TYPE_CODE              6
#define TYPE_LIST              7
#define TYPE_TRUE              8
#define TYPE_DOUBLE            9
#define TYPE_FUNCTION          10
#define TYPE_PROPERTY          13
