//  "in front of" (Front) position for the TADS Pianosa libraries.

//  This file is public domain, as if anyone cares.
//    -- TenthStone, 1999.11.14

/*
 * The position we're creating here is "in front of".  The first thing we
 * find is that we'll have to create all of our prepositions from scratch.
 */
compoundWord 'in' 'front' 'infront';
compoundWord 'infront' 'of' 'infrontof';
compoundWord 'from' 'infront' 'frominfront';
compoundWord 'frominfront' 'of' 'frominfrontof';

infrontofPrep: Prep preposition = 'infront' 'infrontof' sdesc = "in front of";
frominfrontofPrep: Prep preposition = 'frominfront' 'frominfrontof' sdesc = "from in front of";

/*
 * The Position object itself is not very difficult.  We have two things to
 * come up with:
 *     1.  a good position name
 *     2.  a good class name
 * Here, 'front' and 'fronter' will fit.  For the verb routines, we'll
 * stick to the lengthier but more intelligible 'infrontof'.
 */
Front: Position
    position = 5    // 1-4 are used in Pianosa.  This value is irrelevant
                    //  EXCEPT that we have to take care it isn't repeated.
    bulkProp = &bulkfront
    contProp = &frontcont
    contdescProp = &frontcontdesc
    contdescafterProp = &frontcontdescafter
    descProp = &frontdesc
    emptyProp = &emptyfront
    gacProp = &gacfront
    listcontProp = &listfrontcont
    locProp = &front
    maxbulkProp = &maxbulkfront
    maxweightProp = &maxweightfront
    outofPrepobject = frominfrontofPrep
    posPrepobject = infrontofPrep
    qProp = &isqfronter
    reachProp = &frontcontreachable
    removePrep = "from in front of"
    routeProp = &routefront
    showactiveposition = "in front of"
    showposition = "in front of"
    visProp = &frontcontvisible
    weightProp = &weightfront
;

/*
 *  Most of the thing modifications are straightforward and obvious,
 *  capable of being made by a computer program (HINT HINT).
 *  The "tricky" ones are emptyfront and frontcontdesc.
 */
modify thing
    bulkfront = 0
    emptyfront = "There is nothing in front of << self.thedesc >>"
    frontcont = []
    frontcontdesc( c ) = ("In front of << self.thedesc >> ", true)
    frontcontdescafter( c ) = ". "
    frontcontvisible = true
    frontcontreachable = true
    isqfronter = nil
    gacfront( cls, ... ) = {
        local prop, val := true, parm;
        switch (argcount) {
          case 4: parm := getarg( 4 );
          case 3: val := getarg( 3 );
          case 2: prop := getarg( 2 );
        }
        if (argcount >= 4) return gacal( cls, self.frontcont, prop, val, parm );
        else return gacal( cls, self.frontcont, prop, val );
    }
    listfrontcont( ... ) = {
        local lev := 1, j, v := true, c;
        if (argcount > 1) v := getarg( 2 );
        if (argcount > 0) lev := getarg( 1 );
        self.listXcont( Front, lev, v );
    }
    maxweightfront = nil
    maxbulkfront = nil
    routefront( o, j ) = nil
    weightfront = 0

    verDoLookinfrontof( actor ) = {
        self.Emptyfront;
    }
    doLookinfrontof( actor ) = {
        self.frontdesc;
	self.listfrontcont( 1, true );
    }
    verDoPutInfrontof( actor, io ) = {
	if (io = nil) return;
	if (self.locate = io and self.position = Front)
            "\^<< thedesc >> << fmtAre >> already in front of << io.thedesc >>. ";
	else if (io = self)
	    "\^<< self.thedesc >> cannot be put in front of itself. ";
	else if (io.isvisiblyin( self )) self.circularmessage( io );
	else self.verifyremove( actor );
    }
    doPutInfrontof( actor, io ) = {
	if (self.cdesc = true) return;
        self.checkdrop;
        if (self.putInto( actor, actor.iPos )) {
            if (self.putInto( io, Front )) self.Put( actor, Front, io );
        }
    }
    verIoPutInfrontof( actor ) = {
	"There is no reason to try to put anything in front of << self.thedesc >>. ";
    }
    ioPutInfrontof( actor, dobj ) = {
         dobj.doPutInfrontof( actor, self );
    }
    verDoTakeOutfrominfrontof( actor, iobj ) = {
        if (iobj <> nil and not self.isvisiblyin( iobj, Front )) {
            "\^<< self.thedesc >> << fmtAre >> not in front of << iobj.thedesc >>. ";
        }
        self.verDoTake( actor );
    }
    doTakeOutfrominfrontof( actor, iobj ) = {
        self.doTake( actor );
    }    
    verIoTakeOutfrominfrontof( actor ) = {}
    ioTakeOutfrominfrontof( actor, dobj ) = {
        dobj.doTakeOutfrominfrontof( actor, self );
    }
    verIoThrowInfrontof( actor ) = {
        "Throwing that in front of << thedesc >> makes little sense. ";
    }
    ioThrowInfrontof( actor, dobj ) = {
        dobj.doThrowInfrontof( actor, self );
    }
    verDoThrowInfrontof( actor, iobj ) = {
	self.verDoDrop( actor );
    }
    doThrowInfrontof( actor, iobj ) = {
        self.putInto( iobj, Front, global.jostleThrow );
    }
;

/*
 *  The verb modifications are easy enough.  Note that we're defining
 *  a throwVerb grammar as well, because it might well make sense.
 */
modify putVerb
    ioAction( infrontofPrep ) = 'PutInfrontof'
;

modify takeVerb
    ioAction( infrontofPrep ) = 'TakeOutfrominfrontof'
    ioAction( frominfrontofPrep ) = 'TakeOutfrominfrontof'
;

modify throwVerb
    ioAction( infrontofPrep ) = 'ThrowInfrontof'
;

lookinfrontofVerb: Verb
    verb = 'look infrontof' 'l infrontof' 'x infrontof'
    sdesc = "look in front of"
    doAction = 'Lookinfrontof'
    doIsSeen( p ) = true
    doIsTouched( p ) = nil
;

/*
 *  The classes are simple to implement.
 */
class fronter: thing
    maxbulkfront = 10
    isfronter = true
    isqfronter = nil
    verIoPutInfrontof( actor ) = {}
;

class qfronter: fronter
    isqfronter = true
;
