////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: initSearch() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _INIT_SEARCH_T_
#define _INIT_SEARCH_T_

#include <composite.h>
#include <hidden.h>
#include <floating.h>
#include <global.t>

#pragma C+

/*
 *  initSearch: function
 *
 *  Initializes the containers of objects with a searchLoc, underLoc,
 *  and behindLoc by setting up searchCont, underCont, and
 *  behindCont lists, respectively.  You should call this function once in
 *  your preinit (or init, if you prefer) function to ensure that
 *  the underable, behindable, and searchable objects are set up correctly.
 *  
 *  Next we make the components for all Composite class objects. 
 *
 *  As a bonus, we take this opportunity to initialize global.floatingList
 *  with a list of all objects of class Floating.  It is necessary to
 *  initialize this list, so that validDoList and validIoList include objects
 *  with variable location properties.  Note that, for this to work,
 *  all objects with variable location properties must be declared
 *  to be of class Floating.
 */
initSearch: function {
    local o;
    
    o = firstobj(Hidden);
    while (o != nil) {
        if (o.searchLoc)
            o.searchLoc.searchCont = o.searchLoc.searchCont + o;
        else if (o.underLoc)
            o.underLoc.underCont = o.underLoc.underCont + o;
        else if (o.behindLoc)
            o.behindLoc.behindCont = o.behindLoc.behindCont + o;
        o = nextobj(o, Hidden);
    }

    o = firstobj(Composite);
    while ( o != nil ) {
    	o.makeComponents;
    	o = nextobj( o, Composite );
    }
    
    global.floatingList = [];
    for (o = firstobj(Floating) ; o ; o = nextobj(o, Floating))
        global.floatingList += o;
}

#pragma C-

#endif /* _INIT_SEARCH_T_ */
