////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: KeyedDoorway 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _KEYED_DOORWAY_H_
#define _KEYED_DOORWAY_H_

#include <keyedlockable.h>
#include <doorway.h>

#pragma C+

/*
 *  KeyedDoorway: KeyedLockable, Doorway
 *
 *  This is just a normal Doorway that inherits the KeyedLockable
 *  mix-in.
 *
 *  Fill in the other properties (otherSide and leadsTo) as usual. If
 *  the Doorway has a key, set property myKey to the key 
 *  object.
 */
class KeyedDoorway: KeyedLockable, Doorway
    isLocked = true
;

#pragma C-

#endif /* _KEYED_DOORWAY_H_ */
