////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Gate 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _GATE_H_
#define _GATE_H_

#include <floatingdestination.h>
#include <gateway.h>

#pragma C+

/*
 *  Gate: FloatingDestination, Gateway
 *
 *  A Gate is a Destination that impedes progress when it is either raised
 *  or lowered, depending upon accessState.
 *  Unlike the Gateway, a Gate is Floating and should not have its
 *  location attribute coded. Instead, use the foundIn list to indicate
 *  the rooms in which the Gate is to be found. 
 *
 *  To make a simple two-sided Gate you need only code both room
 *  objects in the foundIn list of the Gate: 
 *
 *      foundIn = [ hallway, kitchen ]
 *  
 *  To make a one-sided Gate, code the foundIn list with the room
 *  object in which the Gate is to be found, and the foundIn list
 *  with the room object to which the Gate leads:
 *
 *      foundIn = hallway 
 *      leadsTo  = kitchen 
 *
 *  If you want a Gate that returns rooms different from those it is
 *  found in, simply code both the foundIn list and foundIn list 
 *  accordingly, each element of the foundIn list must have a 
 *  corresponding foundIn element:
 *
 *      foundIn = [ hallway, kitchen ]
 *      leadTo  = [ foyer, hallway ]
 *
 *  From the hallway the Gate leads to the foyer, but from the kitchen
 *  it leads to the hallway.
 */
class Gate: FloatingDestination, Gateway
; 

#pragma C-

#endif  /* _GATE_H_ */
