#pragma C+


/*
 *  TADSMap
 *
 *  An HTML-based mapping libary 
 *  Copyright (c) 2001-2002 Andrew Pontious
 *  All rights reserved. 
 *  Anyone may use and modify this code for their own TADS games.
 *
 *  http://www.umbar.com/TADS/tadsmap/
 *
 *  Version 1.0
 *
 *  July 2002
 *
 */
 
 
 /*
  *  tadsmap_entry.t
  */




/*
 *  Actual entry in TADSMap map, which is different than
 *  the rooms that provide these entries with their data.
 */
class tadsmap_entry: object

	// If we're associated with a room, we'll have a reference to it here.
	map_room = nil
	
	// If we're associated with a hallway
	hallway_type = tadsmap.HALLWAY_TYPE_NONE
	
	map_x = 0
	map_y = 0

	has_been_set =
	{
		if(self.map_room != nil || self.hallway_type != tadsmap.HALLWAY_TYPE_NONE)
			return true;
		else
			return nil;
	}
	
	draw =
	{
		local 
			center_string = self.cen_filename_string + '_', 
			center_verb_string_property = nil,
			center_flag = nil,
			done_drawing = nil,
			draw_result = true,
			// Get these values ahead of time, used in two places below.
			nw_has_intersect = self.has_intersect(
				tadsmap.HALLWAY_TYPE_NE_TO_SW, -1, &has_sw_exit, -1, &has_ne_exit),
			ne_has_intersect = self.has_intersect(
				tadsmap.HALLWAY_TYPE_NW_TO_SE, -1, &has_se_exit, 1, &has_nw_exit),
			sw_has_intersect = self.has_intersect(
				tadsmap.HALLWAY_TYPE_NW_TO_SE, 1, &has_nw_exit, -1, &has_se_exit),
			se_has_intersect = self.has_intersect(
				tadsmap.HALLWAY_TYPE_NE_TO_SW, 1, &has_ne_exit, 1, &has_sw_exit),
			// Hallways split up into subtiles will set the edges differently depending on their
			// identity -- either a small hallway image or an intersect image.
			n_match_hallway_type = tadsmap.HALLWAY_TYPE_N_TO_S, 
			n_hallway_filename = self.n_to_s_filename_string + self.passage_filename_string,
			s_match_hallway_type = tadsmap.HALLWAY_TYPE_N_TO_S, 
			s_hallway_filename = self.n_to_s_filename_string + self.passage_filename_string,
			e_match_hallway_type = tadsmap.HALLWAY_TYPE_E_TO_W, 
			e_hallway_filename = self.e_to_w_filename_string + self.passage_filename_string,
			w_match_hallway_type = tadsmap.HALLWAY_TYPE_E_TO_W, 
			w_hallway_filename = self.e_to_w_filename_string + self.passage_filename_string,
			
			show_link = (self.map_room != nil && 
						 (self.map_x != tadsmap.current_entry_x ||
						  self.map_y != tadsmap.current_entry_y));

		// If we're not a room and we don't need any intersects
		if(self.map_room == nil)
		{
			// Check for two things
			// - If we don't need intersects, then draw a large image.
			// - Otherwise, set edge values (default values only need to be changed for diagonals)
		
			// Empty space, n->s, and e->w must have no intersects in any direction.
			if(self.hallway_type == tadsmap.HALLWAY_TYPE_NONE)
			{
				if(!nw_has_intersect && !ne_has_intersect &&
			   	   !sw_has_intersect && !se_has_intersect)
		   		{
					draw_result = self.draw_image(self.empty_filename_string + self.large_filename_string);
					done_drawing = true;
		   		}
	   		}
			else if(self.hallway_type == tadsmap.HALLWAY_TYPE_N_TO_S)
			{
				if(!nw_has_intersect && !ne_has_intersect &&
				   !sw_has_intersect && !se_has_intersect)
		   		{
					draw_result = self.draw_image(self.n_to_s_filename_string + 
										self.passage_filename_string + self.large_filename_string);
					done_drawing = true;
		   		}
		   	}
			else if(self.hallway_type == tadsmap.HALLWAY_TYPE_E_TO_W)
			{
				if(!nw_has_intersect && !ne_has_intersect &&
		   		   !sw_has_intersect && !se_has_intersect)
				{
					draw_result = self.draw_image(self.e_to_w_filename_string + 
										self.passage_filename_string + self.large_filename_string);
					done_drawing = true;
				}
			}

			// ne->sw, and nw->se must only check intersects in opposing corners, since their
			// own lines cover over intersects in their own path.

			else if(self.hallway_type == tadsmap.HALLWAY_TYPE_NE_TO_SW)
			{
				if(!nw_has_intersect && !se_has_intersect)
				{
					draw_result = self.draw_image(self.ne_to_sw_filename_string + 
										self.passage_filename_string + self.large_filename_string);
					done_drawing = true;
		   		}
		   		else
		   		{
					n_match_hallway_type = s_match_hallway_type = 
						e_match_hallway_type = w_match_hallway_type = tadsmap.HALLWAY_TYPE_NE_TO_SW;

					n_hallway_filename = w_hallway_filename =
						self.se_filename_string + self.intersect_filename_string;

					s_hallway_filename = e_hallway_filename = 
						self.nw_filename_string + self.intersect_filename_string;
		   		}
		   	}
			else if(self.hallway_type == tadsmap.HALLWAY_TYPE_NW_TO_SE)
			{
				if(!ne_has_intersect && !sw_has_intersect)
				{
					draw_result = self.draw_image(self.nw_to_se_filename_string + 
										self.passage_filename_string + self.large_filename_string);
					done_drawing = true;
				}
				else
				{
					n_match_hallway_type = s_match_hallway_type = 
						e_match_hallway_type = w_match_hallway_type = tadsmap.HALLWAY_TYPE_NW_TO_SE;

					n_hallway_filename = e_hallway_filename =
						self.sw_filename_string + self.intersect_filename_string;

					s_hallway_filename = w_hallway_filename = 
						self.ne_filename_string + self.intersect_filename_string;
				}
			}
		}

		if(show_link)
		{
			"<A HREF='mgoto "; say(self.map_x-1); ", "; say(self.map_y-1); "'>";
		}


		if(!done_drawing)
		{
			//"\n";
			"<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 ";
			
			"HEIGHT=";
			say(tadsmap.map_subentry_pixel_height * tadsmap.map_subentries_down_per_entry);
			" WIDTH=";
			say(tadsmap.map_subentry_pixel_width * tadsmap.map_subentries_across_per_entry);
			
			">";
			
			tadsmap.open_row;

			// NW corner of room
			draw_result = self.draw_corner(
					self.nw_filename_string, 
					tadsmap.HALLWAY_TYPE_NW_TO_SE, self.nw_to_se_filename_string,
					&has_nw_exit, nw_has_intersect, &nw_verb_string);
			if(!draw_result) goto bail;
			// N portion of room
			draw_result = self.draw_edge(
					self.n_filename_string, 
					n_match_hallway_type, 
					n_hallway_filename,
					&has_north_exit, &north_verb_string);
			if(!draw_result) goto bail;
			// NE corner of room
			draw_result = self.draw_corner(
					self.ne_filename_string, 
					tadsmap.HALLWAY_TYPE_NE_TO_SW, self.ne_to_sw_filename_string,
					&has_ne_exit, ne_has_intersect, &ne_verb_string);
			if(!draw_result) goto bail;

			tadsmap.close_row;

			tadsmap.open_row;

			// W portion of room
			draw_result = self.draw_edge(
					self.w_filename_string, 
					w_match_hallway_type, 
					w_hallway_filename,
					&has_west_exit, &west_verb_string);
			if(!draw_result) goto bail;


			// Center portion of room
			self.open_element;
			if(self.hallway_type != tadsmap.HALLWAY_TYPE_NONE)
			{
				if(self.hallway_type == tadsmap.HALLWAY_TYPE_N_TO_S)
				{
					draw_result = self.draw_image(self.n_to_s_filename_string + self.passage_filename_string);
				}
				else if(self.hallway_type == tadsmap.HALLWAY_TYPE_NE_TO_SW)
				{
					draw_result = self.draw_image(self.ne_to_sw_filename_string + self.passage_filename_string);
				}
				else if(self.hallway_type == tadsmap.HALLWAY_TYPE_E_TO_W)
				{
					draw_result = self.draw_image(self.e_to_w_filename_string + self.passage_filename_string);
				}
				else if(self.hallway_type == tadsmap.HALLWAY_TYPE_NW_TO_SE)
				{
					draw_result = self.draw_image(self.nw_to_se_filename_string + self.passage_filename_string);
				}
				if(!draw_result) goto bail;
			}
			else if(self.map_room == nil)
			{
				draw_result = self.draw_image(self.empty_filename_string);
				if(!draw_result) goto bail;
			}
			else
			{
				if(self.has_up_exit)
				{
					center_verb_string_property = &up_verb_string;
					center_string += 'up';
					center_flag = true;
				}
				if(self.has_down_exit)
				{
					// Overrides up string
					center_verb_string_property = &down_verb_string;
					if(center_flag == true)
						center_string += '_';
					center_string += 'down';
					center_flag = true;
				}
				if(self.has_special)
				{
					if(center_flag == true)
						center_string += '_';
					center_string += 'special';
					center_flag = true;
				}
				if(center_flag == nil)
					center_string += self.empty_filename_string;
				if(self.is_center && center_verb_string_property)
				{
					"<A HREF='"; say(self.(center_verb_string_property)); "'>";
				}
				draw_result = self.draw_image(center_string);
				if(self.is_center && center_verb_string_property)
				{
					"</A>";
				}
				if(!draw_result) goto bail;
			}
			tadsmap.close_element;


			// E portion of room
			draw_result = self.draw_edge(
					self.e_filename_string, 
					e_match_hallway_type, 
					e_hallway_filename,
					&has_east_exit, &east_verb_string);
			if(!draw_result) goto bail;

			tadsmap.close_row;

			tadsmap.open_row;

			// SW corner of room
			draw_result = self.draw_corner(
					self.sw_filename_string, 
					tadsmap.HALLWAY_TYPE_NE_TO_SW, self.ne_to_sw_filename_string,
					&has_sw_exit, sw_has_intersect, &sw_verb_string);
			if(!draw_result) goto bail;
			// S portion of room
			draw_result = self.draw_edge(
					self.s_filename_string, 
					s_match_hallway_type, 
					s_hallway_filename,
					&has_south_exit, &south_verb_string);
			if(!draw_result) goto bail;
			// SE corner of room
			draw_result = self.draw_corner(
					self.se_filename_string, 
					tadsmap.HALLWAY_TYPE_NW_TO_SE, self.nw_to_se_filename_string,
					&has_se_exit, se_has_intersect, &se_verb_string);
			
			
			tadsmap.close_row;
			"</TABLE>";
		}

		if(show_link)
		{
			"</A>";
		}
		
		bail:

		return draw_result;
	}

	passage_filename_string = '_passage'
	wall_filename_string = '_wall'
	intersect_filename_string = '_intersect'
	empty_filename_string = 'empty'
	large_filename_string = '_large'
	
	nw_filename_string = 'nw'
	n_filename_string = 'n'
	ne_filename_string = 'ne'
	e_filename_string = 'e'
	se_filename_string = 'se'
	s_filename_string = 's'
	sw_filename_string = 'sw'
	w_filename_string = 'w'

	nw_to_se_filename_string = 'nw_to_se'
	n_to_s_filename_string = 'n_to_s'
	ne_to_sw_filename_string = 'ne_to_sw'
	e_to_w_filename_string = 'e_to_w'

	cen_filename_string = 'cen'
	
	suffix_filename_string = '.png'
	
	
	open_element =
	{
		self.open_element_with_height_width(
			tadsmap.map_subentry_pixel_height,
			tadsmap.map_subentry_pixel_width);
	}
	open_element_with_height_width(height, width) =
	{
		"<TD VALIGN=TOP";/*" BGCOLOR=7F007F";*/
		
		" HEIGHT=";
		say(height);
		" WIDTH=";
		say(width);
		
		">";
	}



	// Returns true on no error.
	draw_image(source) =
	{
		local string = '';
		
		if(self.map_room != nil)
			string = self.map_room.maptype + '/';

		string += source;
		
		if(self.map_room != nil && self.is_center == true && self.map_room.supports_center == true)
			string += '_center';

		string += self.suffix_filename_string;
		
		return tadsmap.draw_image(string);
	}

	draw_corner(
		// General inputs
		direction_prefix,		// e.g. 'nw', 'se'
		// Hallway inputs
		match_hallway_type,		// e.g. tadsmap.HALLWAY_TYPE_N_TO_S
		hallway_filename,		// fragment of hallway filename to use, e.g. 'n_to_s'
		// Room inputs
		room_passage,			// Passage property to check for, e.g. has_ne_exit
		// Intersect inputs
		intersect,

		verb_string_property
		) =
	{
		local 
			isHallwayOrEmpty = (self.hallway_type != tadsmap.HALLWAY_TYPE_NONE || self.map_room == nil),
			string = '',
			result = true,
			is_room_passage = nil;

		// Parameter checks.
		if(datatype(direction_prefix) != 3)
			return self.corner_error('direction_prefix is not a string: ' + cvtstr(datatype(direction_prefix)));;
		if(datatype(match_hallway_type) != 1)
			return self.corner_error('match_hallway_type is not a number: ' + cvtstr(datatype(match_hallway_type)));;
		if(datatype(hallway_filename) != 3)
			return self.corner_error('hallway_filename is not a string: ' + cvtstr(datatype(hallway_filename)));;
		if(datatype(room_passage) != 13)
			return self.corner_error('room_passage is not a property pointer ' + cvtstr(datatype(room_passage)));;
		if(datatype(intersect) != 5 && datatype(intersect) != 8)
			return self.corner_error('intersect is not true or nil ' + cvtstr(datatype(room_passage)));;

		// If it's a hallway passage or empty
		if(isHallwayOrEmpty)
		{
			// If it's indicated hallway type, use indicated graphic.
			// For example: tadsmap.HALLWAY_TYPE_NW_TO_SE and 'nw_to_se'
			if(self.hallway_type == match_hallway_type)
				string = hallway_filename + self.passage_filename_string;
			else if(intersect)
				string = direction_prefix + self.intersect_filename_string;
			else
				string = self.empty_filename_string;
		}
		// If it's a room passage
		// If indicated exit exists, use indicated prefix.
		else if(self.(room_passage))
		{
			is_room_passage = true;
			string = direction_prefix + self.passage_filename_string;
		}
		else if(intersect)
			string = direction_prefix + self.intersect_filename_string;
		// For room, wall square
		else
			string = direction_prefix + self.wall_filename_string;

		
		self.open_element;
		if(self.is_center && is_room_passage)
		{
			"<A HREF='"; say(self.(verb_string_property)); "'>";
		}
		result = self.draw_image(string);
		if(self.is_center && is_room_passage)
		{
			"</A>";
		}
		tadsmap.close_element;
		
		return result;
	}

	corner_error(errorstring) =
	{
		return tadsmap.map_error('tadsmap_entry.corner', errorstring);
	}


	has_intersect(
		intersect_hallway_type,	// Adjoining hallway type to check for to find if there's an intersection
		vertical_delta,			// -1 or 1, which way to search for vertical intersection
		vertical_room_passage,	// e.g. has_ne_exit, adjoining vertical room exit to check for if there's an intersection
		horizontal_delta,		// -1 or 1, which way to search for horizontal intersection
		horizontal_room_passage	// Adjoining horizontal room exit to check for if there's an intersection
		) =
	{
		local
			vertical = self.map_y + vertical_delta,
			horizontal = self.map_x + horizontal_delta,
			adjoining_entry = nil,
			intersect = nil;
		
		if(datatype(intersect_hallway_type) != 1)
		{
			self.has_intersect_error('intersect_hallway_type is not a number: ' + cvtstr(datatype(intersect_hallway_type))); return '';
		}
		if(datatype(vertical_delta) != 1)
		{
			self.has_intersect_error('vertical_delta is not a number: ' + cvtstr(datatype(vertical_delta))); return '';
		}
		if(datatype(vertical_room_passage) != 13)
		{
			self.has_intersect_error('vertical_room_passage is not a property pointer: ' + cvtstr(datatype(vertical_room_passage))); return '';
		}
		if(datatype(horizontal_delta) != 1)
		{
			self.has_intersect_error('horizontal_delta is not a number: ' + cvtstr(datatype(horizontal_delta))); return '';
		}
		if(datatype(horizontal_room_passage) != 13)
		{
			self.has_intersect_error('horizontal_room_passage is not a property pointer: ' + cvtstr(datatype(horizontal_room_passage))); return '';
		}

		// Vertical
		if(vertical >= 0 && vertical < tadsmap.entries_down)
		{
			adjoining_entry = tadsmap.entry_for_xandy(self.map_x, vertical);
			if(adjoining_entry != nil)
			{
				// Adjoining hallway
				if(adjoining_entry.hallway_type != tadsmap.HALLWAY_TYPE_NONE)
				{
					if(adjoining_entry.hallway_type == intersect_hallway_type)
						intersect = true;
				}
				// Adjoining room passage
				else if(adjoining_entry.(vertical_room_passage) == true)
					intersect = true;
			}
		}
		// Horizontal
		else if(horizontal >= 0 && horizontal <= tadsmap.entries_across)
		{
			adjoining_entry = tadsmap.entry_for_xandy(horizontal, self.map_y);
			if(adjoining_entry != nil)
			{
				// Adjoining hallway
				if(adjoining_entry.hallway_type != tadsmap.HALLWAY_TYPE_NONE)
				{
					if(adjoining_entry.hallway_type == intersect_hallway_type)
						intersect = true;
				}
				// Adjoining room passage
				else if(adjoining_entry.(horizontal_room_passage) == true)
					intersect = true;
			}
		}
		
		return intersect;
	}

	has_intersect_error(errorstring) =
	{
		return tadsmap.map_error('tadsmap_entry.has_intersect', errorstring);
	}


	draw_edge(
		// General inputs
		direction_prefix,		// e.g. 'nw', 'se'
		// Hallway inputs
		match_hallway_type,		// e.g. tadsmap.HALLWAY_TYPE_N_TO_S
		hallway_filename,		// fragment of hallway filename to use, e.g. 'n_to_s'
		// Room inputs
		room_passage,			// Passage property to check for, e.g. has_ne_exit
		
		verb_string_property,
		
		

		) =
	{
		local 
			isHallwayOrEmpty = (self.hallway_type != tadsmap.HALLWAY_TYPE_NONE || self.map_room == nil),
			string = '',
			result = true,
			is_room_passage = nil;

		// Parameter checks.
		if(datatype(direction_prefix) != 3)
			return self.edge_error('direction_prefix is not a string: ' + cvtstr(datatype(direction_prefix)));
		if(datatype(match_hallway_type) != 1)
			return self.edge_error('match_hallway_type is not a number: ' + cvtstr(datatype(match_hallway_type)));
		if(datatype(hallway_filename) != 3)
			return self.edge_error('hallway_filename is not a string: ' + cvtstr(datatype(hallway_filename)));
		if(datatype(room_passage) != 13)
			return self.edge_error('room_passage is not a property pointer: ' + cvtstr(datatype(room_passage)));

		// (1) Check for regular passages first.

		// If it's a hallway passage or empty
		if(isHallwayOrEmpty)
		{
			// If it's indicated hallway type, use indicated graphic.
			// For example: tadsmap.HALLWAY_TYPE_N_TO_S and 'n_to_s_passage'
			if(self.hallway_type == match_hallway_type)
				string = hallway_filename;
			else
				string = self.empty_filename_string;
		}
		// If it's a room passage
		// If indicated exit exists, use indicated prefix.
		else if(self.(room_passage))
		{
			string = direction_prefix + self.passage_filename_string;
			is_room_passage = true;
		}
		// For room, wall square
		else
			string = direction_prefix + self.wall_filename_string;

		
		self.open_element;
		if(self.is_center && is_room_passage)
		{
			"<A HREF='"; say(self.(verb_string_property)); "'>";
		}
		result = self.draw_image(string);
		if(self.is_center && is_room_passage)
		{
			"</A>";
		}
		tadsmap.close_element;
		
		return result;
	}

	edge_error(errorstring) =
	{
		return tadsmap.map_error('tadsmap_entry.edge', errorstring);
	}

	reset = 
	{
		self.map_room = nil;
		
		self.hallway_type = tadsmap.HALLWAY_TYPE_NONE;

		self.has_north_exit = nil;
		self.has_ne_exit = nil;
		self.has_east_exit = nil;
		self.has_se_exit = nil;
		self.has_south_exit = nil;
		self.has_sw_exit = nil;
		self.has_west_exit = nil;
		self.has_nw_exit = nil;
		self.has_up_exit = nil;
		self.has_down_exit = nil;
		self.has_special = nil;
		
		self.is_center = nil;
		
		return true;
	}

	setxandy(newx, newy) =
	{
		self.map_x = newx;
		self.map_y = newy;
	}

	has_north_exit = nil
	has_ne_exit = nil
	has_east_exit = nil
	has_se_exit = nil
	has_south_exit = nil
	has_sw_exit = nil
	has_west_exit = nil
	has_nw_exit = nil
	has_up_exit = nil
	has_down_exit = nil
	has_special = nil

	is_center = nil

	nw_verb_string = 'nw'
	north_verb_string = 'north'
	ne_verb_string = 'ne'
	east_verb_string = 'east'
	se_verb_string = 'se'
	south_verb_string = 'south'
	sw_verb_string = 'sw'
	west_verb_string = 'west'
	up_verb_string = 'up'
	down_verb_string = 'down'
;


#pragma C-
