/* This program is Copyright (c) 1994 David Allen.  It may be freely
   distributed as long as you leave my name and copyright notice on it.
   I'd really like your comments and feedback; send e-mail to
   allen@viewlogic.com, or send us-mail to David Allen, 10 O'Moore Ave,
   Maynard, MA 01754. */
/* Changes/additions to this file have been made by Stephen Granade, and all
   such changes are documented with comments ending in my initials.  The
   copyright still belongs to David Allen; I release any rights I might have
   to him.  I, too, would appreciate comments at sgranade@phy.duke.edu. */


/* This is an "adaptive hint" implementation for Ditch Day Drifter.
   See the file "adhint.doc" for more detailed information. */


/* Puzzle definitions and dependencies */

/* We know all of the first four puzzles come in a straight line; when one
   is active, no other puzzle can be active. */
/* I added titles to the first three puzzles and iTotalNumHints to all of
   them.  SG */
guardAh:   ahPuzzle ahDesc = "guard"
   title = "How to get past the guard"
;
keyAh:     ahPuzzle ahDesc = "key"
   title = "How to get into the GUE"
;
darkAh:    ahPuzzle ahDesc = "dark"
   title = "How to get past the dark tunnel"
;
climbAh:   ahPuzzle ahDesc = "climb"
   title = "How do I get into the pit"
;
cloneAh:   ahPuzzle ahDesc = "clone"
   title = "How to pass by the monster in the Bio hallway"
//   iTotalNumHints = 5
;
policyAh:  ahPuzzle ahDesc = "policy"
   title = "How to purchase the insurance policy"
//   iTotalNumHints = 3
;
batteryAh: ahPuzzle ahDesc = "battery" prereqs = [policyAh]
   title = "How to buy the battery in the store"
//   iTotalNumHints = 4
;
gearAh:    ahPuzzle ahDesc = "gear"    prereqs = [batteryAh]
   title = "How to light the exit from the machine room"
//   iTotalNumHints = 4
;
cardAh:    ahPuzzle ahDesc = "card"
   title = "How to open the safe in the bank"
//   iTotalNumHints = 8
;
subwayAh:  ahPuzzle ahDesc = "subway"
   title = "How to use the railcar"
//   iTotalNumHints = 5
;
mazeAh:    ahPuzzle ahDesc = "maze"
   title = "How to get objects out of the Great Underground Excavations"
//   iTotalNumHints = 3
;
warpAh:    ahPuzzle ahDesc = "warp"
   title = "How to use the spaceship"
//   iTotalNumHints = 2
;


/* Hints for guard puzzle: start when guard seen, end when toxicola drunk */
/* Guard hints changed to demonstrate the ahHintList object.  Note that you
   don't have to set iBaseHintNum for the first hint or hintlist.  SG */

guardH: ahHintList
   owner = guardAh
   ahTell = [
'There is a memo in one of the campus buildings which may give you an idea
 about how to get past the guard.',
'Perhaps the guard would let you by if you gave him something to drink.',
'The guard will let you by if you give him the Toxicola from the kitchen.'
            ]
;


/* Hints for master key: start when guard's door touched, end when unlocked */
/* keyH1 and keyH2 consolidated into a hint list.  Originals left for
   demonstration purposes.  SG */

masterkeyAh: ahClue ahDesc = "see-key"; /* key has been seen in jeans */

keyH1: ahHintList
   owner = keyAh
   ahTell = [
'Maybe somebody left a key to unlock the guard\'s door in their laundry.',
'To find the key to the guard\'s door, look in the washing machine in the
 laundry room in the basement.'
            ]
   ahAvail = { return (not masterkeyAh.seen); }
;

/*   --== Replaced hints ==--
keyH1: ahHint owner = keyAh
   ahAvail = { return (not masterkeyAh.seen); }
   ahTell = "Maybe somebody left a key to unlock the guard's door in 
      their laundry. ";
keyH2: ahHint owner = keyAh 
   ahAvail = { return (keyH1.seen); }
   ahTell = "To find the key to the guard's door, look in the washing
      machine in the laundry room in the basement. ";
*/

keyH3: ahHint owner = keyAh
//   iBaseHintNum = 3
   ahAvail = { return (masterkeyAh.seen); }
   ahTell = "Perhaps that key you found will unlock the guard's door. ";


/* Hints for control pad: start when dark tunnel hit, end when lit */


controlAh: ahClue ahDesc = "see-control"; /* control panel has been examined */

darkH1: ahHint owner = darkAh
   ahTell = "There may be controls for these lights in the tunnels. ";
darkH2: ahHint owner = darkAh
//   iBaseHintNum = 2
   ahTell = "There is a memo in one of the campus buildings which has some
      information about the lights in the tunnels. ";
darkH3: ahHint owner = darkAh 
//   iBaseHintNum = 3
   ahAvail = { return (darkH2.seen); }
   ahTell = "The memo in the Buildings and Grounds office has the codes you
      need to turn the lights on. ";
darkpanel: ahHint owner = darkAh
//   iBaseHintNum = 4
   ahAvail = { return (darkH2.seen and not controlAh.seen); }
   ahTell = "The panel which controls the lights is in the middle of the
      south branch of the steam tunnels. ";
darkH4: ahHint owner = darkAh 
   //iBaseHintNum = 5
   ahAvail = { return (darkH3.seen and controlAh.seen); }
   ahTell = "Type 293 on the pad of the control unit, then push the green 
      button to turn on the lights in the tunnel. ";


/* Hints for rope in pit: start when pit seen, end when climb down */


ropeAh: ahClue ahDesc = "see-rope"; /* rope has been seen */

climbH1: ahHint owner = climbAh
   ahTell = "You need to find a way to climb down into the pit. ";
climbH2: ahHint owner = climbAh 
   //iBaseHintNum = 2
   ahAvail = { return (climbH1.seen and not ropeAh.seen); }
   ahTell = "There is some rope near the pit which you can tie to the railing 
      in order to climb down. ";
climbH3: ahHint owner = climbAh 
   //iBaseHintNum = 3
   ahAvail = { return (climbH1.seen and ropeAh.seen); }
   ahTell = "That rope you found near the pit will do nicely to climb down 
      into the pit. ";


/* Hints for clonemaster monster: start when monster seen, end with elopement */

/* Hints cloneH1 through cloneH3 incorporated into a list.  SG */


slimeAh: ahClue ahDesc = "have-slime"; /* player has been slimed */
bionotesAh: ahClue ahDesc = "read-notes"; /* bio notes have been read */

cloneH1: ahHintList
   owner = cloneAh
   ahTell = [
'The monster is lonely, and would be happy with one of his own kind for
 company.  A clone, even.',
'You might be able to make a clone with equipment and supplies from the bio
 lab.',
' The formula for making a clone can be found in one of the campus buildings.'
            ]
;

cloneH4: ahHint owner = cloneAh
   //iBaseHintNum = 4
   ahAvail = { return ((slimeAh.seen) and (cloneH1.seen)); }
   ahTell = "Put the GF-XQ3, poly blue and T99 from the cabinet into the
      CloneMaster along with the slime.  Then take the CloneMaster out into
      the hall with the monster and push the button. ";

cloneH5: ahHint owner = cloneAh
   //iBaseHintNum = 5
   ahAvail = { 
      return ((not slimeAh.seen) and (cloneH4.seen or bionotesAh.seen)); }
   ahTell = "You can only get a skin sample from the monster by trying to
      go past it.  Use the slime that rubs off on you. ";


/* Hints for buying the policy: start when see Lloyd, end when buy */


underbedAh: ahClue ahDesc = "looked-under-bed"; /* player has dollar bill */

policyH1: ahHint owner = policyAh
   ahAvail = { return (not underbedAh.seen); }
   ahTell = "Maybe you can scrape up the money you need for the insurance
      policy if you search your room. ";

policyH2: ahHint owner = policyAh 
   //iBaseHintNum = 2
   ahAvail = { return ((policyH1.seen) and (not underbedAh.seen)); }
   ahTell = "The money you need for the policy is under your bed. ";

policyH3: ahHint owner = policyAh
   //iBaseHintNum = 3
   ahAvail = { return (underbedAh.seen); }
   ahTell = "You have the money to pay for the policy, and it will help. ";


/* Hints for railway car: start when see it, end when get book */


flaskAh: ahClue ahDesc = "see-flask"; /* flask has been seen */
chuteAh: ahClue ahDesc = "use-chute"; /* chute has been used correctly */
coolantAh: ahClue ahDesc = "see-coolant-hole"; /* coolant hole has been seen */
coolNoFunAh: ahClue ahDesc = "pouring-coolant-without-funnel";
   /* common mistake of pouring nitrogen without funnel has been made */
funnelAh: ahClue ahDesc = "see-funnel"; /* funnel has been seen */
coolantOkAh: ahClue ahDesc = "coolant-ok"; /* nitrogen poured correctly */

subwayH1: ahHint owner = subwayAh
   ahAvail = { return (not coolantAh.seen); }
   ahTell = "You can learn a lot about the railcar by examining it. ";

subwayH2: ahHint owner = subwayAh
   //iBaseHintNum = 2
   ahAvail = { return (coolantAh.seen); }
   ahTell = { 
      "You need to pour something cold into the railcar's coolant hole. ";
      if (flaskAh.seen) "The liquid nitrogen you saw would do nicely. ";
      else "You can find the right liquid above ground. "; };

subwayH3: ahHint owner = subwayAh
   //iBaseHintNum = 3
   ahAvail = { 
      return ((flaskAh.seen) and (chuteAh.seen) and (subwayH2.seen)); }
   ahTell = "To get the flask through the tight squeeze in the steam
      tunnel, you can drop it down the chute and pick it up below. ";

subwayH4: ahHint owner = subwayAh
   //iBaseHintNum = 4
   ahAvail = { return ((coolNoFunAh.seen) and (not funnelAh.seen)); }
   ahTell = "You might find a funnel very useful in pouring the nitrogen
      into the small hole in the railcar.  There is one not far from the 
      railcar.";

subwayH5: ahHint owner = subwayAh
   //iBaseHintNum = 5
   ahAvail = { return (coolantOkAh.seen); }
   ahTell = "Now that the railcar is properly cooled, board it and push the
      green button!";


/* Hints for safe and darbcard: start when see safe, end when exploded */


depslotAh: ahClue ahDesc = "see-depslot"; /* night deposit slot seen */
bottleAh: ahClue ahDesc = "see-bottle"; /* bottle has been seen */
thesisAh: ahClue ahDesc = "see-thesis"; /* explosive thesis has been seen */
nitroNoFunAh: ahClue ahDesc = "bottle-without-funnel";

   /* common mistake of pouring nitrogen without funnel has been made */

/* Basic hints */

/* cardH2 & cardH3 made a list.  SG */
cardH1: ahHint owner = cardAh
   ahAvail = { return (not depslotAh.seen); }
   ahTell = "Examining the safe in the bank vault will show one possible 
      way to get in.";

cardH2: ahHintList owner = cardAh
   //iBaseHintNum = 2
   ahTell = [
'There is some information in one of the campus buildings that suggests how
 to get at the safe\'s contents.  Provided the contents aren\'t fragile, of
 course.',
'The thesis in the Explosives Lab tells how you can make a bomb to put inside
 the safe; that will open it.'
            ]
;

/*
cardH2: ahHint owner = cardAh
   ahTell = "There is some information in one of the campus buildings that
      suggests how get at the safe's contents.  Provided the contents aren't
      fragile, of course. ";

cardH3: ahHint owner = cardAh 
   ahAvail = { return (cardH2.seen); }
   ahTell = "The thesis in the Explosives Lab tells how you can make a bomb
      to put inside the safe; that will open it. ";
*/

/* Clues to needed objects: flask, bottle, funnel */

cardbottle: ahHint owner = cardAh
   //iBaseHintNum = 4
   ahAvail = { return ((not bottleAh.seen) and (thesisAh.seen)); }
   ahTell = "You can find a container for the explosion in your dorm room. ";

cardbot2: ahHint owner = cardAh
   //iBaseHintNum = 5
   ahAvail = { return ((not bottleAh.seen) and (cardbottle.seen)); }
   ahTell = "The bottle you need for the explosion is in your wastebasket. ";

cardflask: ahHint owner = cardAh
   //iBaseHintNum = 6
   ahAvail = { return (thesisAh.seen); }
   ahTell = { 
      "You need some liquid nitrogen to make the explosion. ";
      if (flaskAh.seen) "The flask you saw holds enough. ";
      else "You can find some above ground. "; };

cardfunnel: ahHint owner = cardAh
   //iBaseHintNum = 7
   ahAvail = { return ((nitroNoFunAh.seen) and (not funnelAh.seen)); }
   ahTell = "You might find a funnel very useful in pouring the nitrogen
      into the bottle.  There is one not far from the vault.";

cardchute: ahHint owner = cardAh
   //iBaseHintNum = 8
   ahAvail = { 
      if (chuteAh.seen) {
         if (bottleAh.seen and cardbottle.seen) return (true);
         if (flaskAh.seen and cardflask.seen) return (true); }
      return (nil); }
   ahTell = "To get items through the tight squeeze in the steam
      tunnel, you can drop them down the chute and pick them up below. ";


/* Hints for solving the maze: start when treasure taken, end when put in */


mazeDoorAh: ahClue ahDesc = "see-maze-entry"; /* entry to maze has been seen */
equipmentAh: ahClue ahDesc = "equipment-off"; /* spinner has been turned off */

mazeH1: ahHint owner = mazeAh
   ahTell = {
      if (mazeDoorAh.seen) "You need to thread the maze ";
      else "There is a maze you will need to find and thread ";
      "before you can deliver the objects for the stack. "; };

mazeH2: ahHint owner = mazeAh
   //iBaseHintNum = 2
   ahAvail = { 
      return (mazeDoorAh.seen and mazeH1.seen and not equipmentAh.seen); }
   ahTell =  "You can turn off the equipment in the maze by using the same
      control panel you used to turn on the lights.  Without turning off
      the equipment, you really should not attempt the maze! ";

mazeH4: ahHint owner = mazeAh
   //iBaseHintNum = 3
   ahAvail = { return (mazeH1.seen and equipmentAh.seen); }
   ahTell = "This is the exact sequence of steps to go from the entrance by
      the steam tunnels, to the lab door aboveground:  N.E.N.W. W.S.W.S.
      W.N.N.N. E.N.W.W. ";


/* Hints for the battery puzzle: start when battery seen and policy bought;
   end when battery purchased */


batteryPriceAh: ahClue ahDesc = "batt-price"; /* player knows battery price */
machineAh: ahClue ahDesc = "see-machine"; /* hurting machine has been seen */

batteryH1: ahHint owner = batteryAh
   ahAvail = { return (not batteryPriceAh.seen); }
   ahTell = { 
      "You will need to come up with five dollars to purchase the battery 
         in the store. ";
      batteryPriceAh.see; };

batteryH2: ahHint owner = batteryAh
   //iBaseHintNum = 2
   ahAvail = { return (batteryPriceAh.seen); }
   ahTell = "Perhaps if you can get a payoff from your insurance policy,
      you can raise the money for the battery.  You would probably have to
      find a way to injure yourself without being killed. "; 

batteryH3: ahHint owner = batteryAh
   //iBaseHintNum = 3
   ahAvail = { return (batteryH2.seen and not machineAh.seen); }
   ahTell = "There is a machine in the Excavations which looks dangerous;
      maybe you can injure yourself badly enough with it to have Lloyd pay 
      you.  Trust me!  Why would I lie to you? ";

batteryH4: ahHint owner = batteryAh
   //iBaseHintNum = 4
   ahAvail = { return (batteryH2.seen and machineAh.seen); }
   ahTell = "Push the red button on the machine in the machine room.  Lloyd
      will pay you five dollars for the injury. ";


/* Hints for gear; start when battery purchased and machine storage entered,
   end when room lit */


flashAh: ahClue ahDesc = "see-flash"; /* flashlight has been spotted */

gearH1: ahHint owner = gearAh
   ahTell = "The lights for the dark room off the machine shop are not 
      controlled like the other lights.  You will need to carry some kind
      of light, perhaps a flashlight. ";

gearH2: ahHint owner = gearAh
   //iBaseHintNum = 2
   ahAvail = { return (gearH1.seen and not flashAh.seen); }
   ahTell = "There is a flashlight in one of the offices above ground. ";

gearH3: ahHint owner = gearAh
   //iBaseHintNum = 3
   ahAvail = { return (gearH1.seen and flashAh.seen); }
   ahTell = "With the flashlight and the battery, you are equipped to explore
      the dark room off the machine room in the Excavations. ";

gearH4: ahHint owner = gearAh
   //iBaseHintNum = 4
   ahAvail = { 
      return ((flashAh.seen) and (chuteAh.seen) and (gearH2.seen)); }
   ahTell = "To get the flashlight through the tight squeeze in the steam
      tunnel, you can drop it down the chute and pick it up below. ";


/* Hints for the warp drive: start when all four items inserted, ends when
   warp activator inserted */


warpholeAh: ahClue ahDesc = "see-warp-hole"; /* socket for warp unit seen */
shipAh: ahClue ahDesc = "see-ship"; /* spaceship has been seen */

warpH1: ahHint owner = warpAh
   ahAvail = { return (not shipAh.seen); }
   ahTell = "You haven't completely explored the Excavations yet, have you?";

warpH2: ahHint owner = warpAh
   //iBaseHintNum = 2
   ahAvail = { return (shipAh.seen and not warpholeAh.seen); }
   ahTell = "You haven't completely explored the space ship, have you?";
