VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmConex 
   Caption         =   "Conexiones"
   ClientHeight    =   5415
   ClientLeft      =   810
   ClientTop       =   720
   ClientWidth     =   7470
   Icon            =   "Conex.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   5415
   ScaleWidth      =   7470
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   6000
      Top             =   1440
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   5880
      Top             =   720
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   10
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":0E42
            Key             =   "BORRAR"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":0F9C
            Key             =   "LOCALIDADES"
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":1536
            Key             =   "CUADRICULA"
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":1690
            Key             =   "DESC"
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":1C2A
            Key             =   "OBJETOS"
         EndProperty
         BeginProperty ListImage6 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":21C4
            Key             =   "PSIs"
         EndProperty
         BeginProperty ListImage7 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":275E
            Key             =   "CONEX"
         EndProperty
         BeginProperty ListImage8 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":2CF8
            Key             =   "AUTOCONEX"
         EndProperty
         BeginProperty ListImage9 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":3292
            Key             =   "ORDENARCONEX"
         EndProperty
         BeginProperty ListImage10 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Conex.frx":382C
            Key             =   "IMPEXP"
         EndProperty
      EndProperty
   End
   Begin VB.PictureBox picConex3 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   1455
      Left            =   240
      ScaleHeight     =   1425
      ScaleWidth      =   1785
      TabIndex        =   5
      Top             =   720
      Visible         =   0   'False
      Width           =   1815
   End
   Begin MSComCtl2.FlatScrollBar hScr 
      Height          =   255
      Left            =   0
      TabIndex        =   4
      Top             =   5160
      Width           =   7215
      _ExtentX        =   12726
      _ExtentY        =   450
      _Version        =   393216
      Arrows          =   65536
      LargeChange     =   500
      Orientation     =   1179649
      SmallChange     =   100
   End
   Begin MSComCtl2.FlatScrollBar vScr 
      Height          =   4695
      Left            =   7200
      TabIndex        =   3
      Top             =   480
      Width           =   255
      _ExtentX        =   450
      _ExtentY        =   8281
      _Version        =   393216
      LargeChange     =   500
      Orientation     =   1179648
      SmallChange     =   100
   End
   Begin MSComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   360
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   7470
      _ExtentX        =   13176
      _ExtentY        =   635
      ButtonWidth     =   609
      ButtonHeight    =   582
      AllowCustomize  =   0   'False
      Appearance      =   1
      Style           =   1
      ImageList       =   "ImageList1"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   12
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "LISTA"
            Object.ToolTipText     =   "Muestra la lista de localidades"
            ImageKey        =   "LOCALIDADES"
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "OBJETOS"
            Object.ToolTipText     =   "Muestra la lista de objetos"
            ImageKey        =   "OBJETOS"
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "PSIs"
            Object.ToolTipText     =   "Muestra la lista de PSIs"
            ImageKey        =   "PSIs"
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "BORRAR"
            Object.ToolTipText     =   "Borrar localidades seleccionadas"
            ImageKey        =   "BORRAR"
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "CUADRICULA"
            Object.ToolTipText     =   "Ajustar a la cuadrcula"
            ImageKey        =   "CUADRICULA"
            Style           =   1
            Value           =   1
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "DESC"
            Object.ToolTipText     =   "Nombre localidades/descripcin"
            ImageKey        =   "DESC"
            Style           =   1
         EndProperty
         BeginProperty Button8 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "CONEX"
            Object.ToolTipText     =   "Mostrar/ocultar conexiones entre localidades"
            ImageKey        =   "CONEX"
            Style           =   1
            Value           =   1
         EndProperty
         BeginProperty Button9 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "AUTOCONEX"
            Object.ToolTipText     =   "Mostrar/ocultar conex. localidad consigo misma"
            ImageKey        =   "AUTOCONEX"
            Style           =   1
            Value           =   1
         EndProperty
         BeginProperty Button10 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button11 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "ORDENARCONEX"
            Object.ToolTipText     =   "Ordena las conexiones"
            ImageKey        =   "ORDENARCONEX"
         EndProperty
         BeginProperty Button12 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "IMPEXP"
            ImageKey        =   "IMPEXP"
            Style           =   5
            BeginProperty ButtonMenus {66833FEC-8583-11D1-B16A-00C0F0283628} 
               NumButtonMenus  =   2
               BeginProperty ButtonMenu1 {66833FEE-8583-11D1-B16A-00C0F0283628} 
                  Key             =   "IMPORTAR"
                  Text            =   "Importar"
               EndProperty
               BeginProperty ButtonMenu2 {66833FEE-8583-11D1-B16A-00C0F0283628} 
                  Key             =   "EXPORTAR"
                  Text            =   "Exportar"
               EndProperty
            EndProperty
         EndProperty
      EndProperty
   End
   Begin VB.PictureBox picConex1 
      Height          =   4695
      Left            =   0
      ScaleHeight     =   4635
      ScaleWidth      =   7155
      TabIndex        =   0
      Top             =   480
      Width           =   7215
      Begin VB.PictureBox picConex2 
         Appearance      =   0  'Flat
         AutoRedraw      =   -1  'True
         BackColor       =   &H80000005&
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   6.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   4455
         Left            =   0
         ScaleHeight     =   4425
         ScaleWidth      =   6945
         TabIndex        =   1
         Top             =   0
         Width           =   6975
      End
   End
End
Attribute VB_Name = "frmConex"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' para guardar los trazos de conexiones desde una localidad
' en la rutina 'DibujaConexiones'
Private Type TrazoConex
    Loc As Long
    TxtCon As String
    X0 As Long
    Y0 As Long
    X1 As Long
    Y1 As Long
End Type

Private lLocSelecc() As Long    ' localidades seleccionadas (lLocSelecc(0)=-1 si ninguna)
Private MouseX As Single        ' posicin del ratn
Private MouseY As Single
Private SeleccX As Single       ' inicio de seleccin rectangular
Private SeleccY As Single
Private bModoConex As Boolean   ' modo de trazado de conexin
Private bModoSelecc As Boolean  ' modo de seleccin por rectngulo
Private bCuadricula As Boolean  ' ajuste a cuadrcula activado/desactivado

' dibuja la cuadrcula de fondo, la dibujamos en un control Picture auxiliar que
' luego se trasferir al definitivo
Private Sub DibujaCuadricula()
    Dim lX As Long, lY As Long, lColor As Long
    Dim iModo As Integer, iEstilo As Integer

    ' borramos la zona de dibujo
    picConex3.Line (0, 0)-(picConex3.Width, picConex3.Height), picConex3.BackColor, BF
    
    iModo = picConex3.DrawMode
    iEstilo = picConex3.DrawStyle
    lColor = picConex3.ForeColor
    picConex3.DrawMode = vbCopyPen
    picConex3.DrawStyle = vbDot
    picConex3.ForeColor = RGB(200, 200, 200)
    For lY = 0 To picConex3.ScaleHeight Step TAM_LOCY
        For lX = 0 To picConex3.ScaleWidth Step TAM_LOCX
            picConex3.Line (lX, lY)-Step(TAM_LOCX / 4, 0)
            picConex3.Line (lX, lY)-Step(-(TAM_LOCX / 4), 0)
            picConex3.Line (lX, lY)-Step(0, TAM_LOCY / 4)
            picConex3.Line (lX, lY)-Step(0, -(TAM_LOCY / 4))
        Next
    Next
    picConex3.DrawMode = iModo
    picConex3.DrawStyle = iEstilo
    picConex3.ForeColor = lColor
    
End Sub

' dibuja el mapa completo
Public Sub DibujaMapa()
    Dim i As Long
    
    LockWindowUpdate picConex2.hwnd
    BitBlt picConex2.hDC, 0, 0, picConex2.Width, picConex2.Height, picConex3.hDC, _
      0, 0, SRCCOPY
    
    If Not bHayLoc Then
        Exit Sub
    End If
    
    For i = 0 To UBound(Localidades)
        DibujaLocalidad i
    Next
    For i = 0 To UBound(Localidades)
        DibujaConexiones i
    Next

    LockWindowUpdate 0

End Sub

Private Sub DibujaLocalidad(lLoc As Long)
    Dim lX As Long, lY As Long, lAncho As Long, lColor As Long
    Dim sDesc As String
    
    lX = Localidades(lLoc).X
    lY = Localidades(lLoc).Y
    
    If lX = -1 Or lY = -1 Then
        Exit Sub
    End If

    If Toolbar1.Buttons("DESC").value = tbrPressed Then
        sDesc = Localidades(lLoc).DescCorta
    Else
        sDesc = Localidades(lLoc).Nombre
    End If

    ' cuadro
    picConex2.DrawMode = vbCopyPen
    ' miramos si est seleccionada
    If EsLocSelecc(lLoc) Then
        picConex2.DrawStyle = vbDot
    Else
        picConex2.DrawStyle = vbSolid
    End If
    picConex2.Line (lX, lY)-Step(TAM_LOCX, TAM_LOCY), , B
    
    ' texto
    picConex2.CurrentY = lY + TAM_LOCY + 25
    lAncho = picConex2.TextWidth(sDesc)
    picConex2.CurrentX = lX + ((TAM_LOCX - lAncho) / 2)
    lColor = picConex2.ForeColor
    picConex2.ForeColor = vbBlue
    picConex2.FontItalic = False
    picConex2.Print sDesc
    picConex2.ForeColor = lColor
    
End Sub

Private Sub DibujaConexiones(lLoc As Long)
    Dim c() As TrazoConex
    Dim bRepetida As Boolean
    Dim i As Long, j As Long, n As Long, lX As Long, lY As Long, lX1 As Long, _
      lY1 As Long, lColor As Long, lLocCon As Long
    Dim sLocalidad As String, sVerbo As String
    
    lX = Localidades(lLoc).X
    lY = Localidades(lLoc).Y
    
    If lX = -1 Or lY = -1 Then
        Exit Sub
    End If

    n = UBound(Localidades(lLoc).Conexiones)
    ReDim c(n)
    For i = 0 To n
        c(i).Loc = -1
    Next
    
    For i = 0 To n
        sLocalidad = Localidades(lLoc).Conexiones(i).Localidad
        sVerbo = Localidades(lLoc).Conexiones(i).Verbo
        ' cambiamos el texto del verbo para indicar que est cerrada
        If Not Localidades(lLoc).Conexiones(i).Abierta Then
            sVerbo = "[" & sVerbo & "]"
        End If
        
        ' busca la localidad con la que est conectada
        lLocCon = BuscaLocalidad(sLocalidad)
        If lLocCon >= 0 Then
            lX1 = Localidades(lLocCon).X
            lY1 = Localidades(lLocCon).Y
            If Localidades(lLocCon).Nombre <> "" And lX1 <> -1 And lY1 <> -1 Then
                ' comprobamos si ya exista una conexin entre las dos localidades
                ' en ese caso aadimos el verbo al texto para que salga encadenado
                ' y evitar que se sobreescriba
                bRepetida = False
                For j = 0 To i
                    If c(j).Loc = lLocCon Then
                        c(j).TxtCon = c(j).TxtCon & "/" & sVerbo
                        bRepetida = True
                    End If
                Next
                
                If Not bRepetida Then
                    c(i).Loc = lLocCon
                    c(i).X0 = lX
                    c(i).Y0 = lY
                    c(i).X1 = lX1
                    c(i).Y1 = lY1
                    c(i).TxtCon = sVerbo
                Else
                    ' para saltrnosla cuando dibujemos las conexiones
                    c(i).Loc = -1
                End If
            End If
        End If
    Next
    
    ' dibujamos las conexiones
    For i = 0 To n
        lLocCon = c(i).Loc
        If lLocCon <> -1 Then
            lColor = picConex2.ForeColor
        
            ' lnea
            lX = c(i).X0
            lY = c(i).Y0
            lX1 = c(i).X1
            lY1 = c(i).Y1
            picConex2.DrawMode = vbCopyPen
            picConex2.Line (lX + (TAM_LOCX / 2), lY + (TAM_LOCY / 2))-(lX1 + (TAM_LOCX / 2), lY1 + (TAM_LOCY / 2))
                       
            ' si es una conexin consigo misma
            If lLoc = lLocCon And Toolbar1.Buttons("AUTOCONEX").value = tbrPressed Then
                picConex2.CurrentX = lX - (picConex2.TextWidth(c(i).TxtCon) / 2)
                picConex2.CurrentY = lY - picConex2.TextHeight(c(i).TxtCon)
                picConex2.ForeColor = RGB(128, 0, 0)
                picConex2.FontItalic = True
                picConex2.Print c(i).TxtCon
            ElseIf Toolbar1.Buttons("CONEX").value = tbrPressed Then
                picConex2.CurrentX = lX + ((lX1 - lX) / VCONEX_DELTAX)
                picConex2.CurrentY = lY + ((lY1 - lY) / VCONEX_DELTAY)
                picConex2.ForeColor = vbRed
                picConex2.FontItalic = False
                picConex2.Print c(i).TxtCon
            End If
            
            picConex2.ForeColor = lColor
        End If
    Next

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyDelete Then
        BorrarLocalidad
    End If

End Sub

Private Sub Form_Load()

    Screen.MousePointer = vbHourglass

    ' tamao mximo de zona de dibujo
    picConex2.Width = TAM_MAPAX
    picConex2.Height = TAM_MAPAY
    picConex3.Width = picConex2.Width
    picConex3.Height = picConex2.Height
    DibujaCuadricula
    
    ' valores de las barras de desplazamiento
    hScr.Min = 0
    hScr.Max = picConex2.Width - picConex1.Width
    vScr.Min = 0
    vScr.Max = picConex2.Height - picConex1.Height
    
    ReDim lLocSelecc(0)
    lLocSelecc(0) = -1
    
    DibujaMapa
    
    ' activamos ajuste a la cuadrcula
    Toolbar1.Buttons("CUADRICULA").value = tbrPressed
    bCuadricula = True
    
    bModoConex = False
    bModoSelecc = False
    
    Screen.MousePointer = vbDefault
    
End Sub

Private Sub Form_Resize()

    On Error Resume Next
    
    ' tamao de zona de dibujo
    picConex1.Height = Me.Height - 1140
    picConex1.Width = Me.Width - 375
    
    ' posicin y tamao de barras de desplazamiento
    hScr.Top = picConex1.Top + picConex1.Height
    hScr.Width = picConex1.Width
    hScr.Max = picConex2.Width - picConex1.Width
    vScr.Left = picConex1.Left + picConex1.Width
    vScr.Height = picConex1.Height
    vScr.Max = picConex2.Height - picConex1.Height

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Unload frmLstLoc
    Unload frmLstObj
    Unload frmLstPSI

End Sub

Private Sub hScr_Change()

    picConex2.Left = -hScr.value

End Sub

' comprueba si el ratn cae dentro de algn cuadro de localidad
' devuelve el n de localidad, -1 si el ratn no est sobre ninguna
Private Function LocRaton() As Long
    Dim i As Long, n As Long, lSelecc As Long, lX As Long, lY As Long, lX1 As Long, lY1 As Long

    lSelecc = -1

    n = UBound(Localidades)
    For i = 0 To n
        lX = Localidades(i).X
        lY = Localidades(i).Y
        
        If lX <> -1 And lY <> -1 Then
            lX1 = lX + TAM_LOCX
            lY1 = lY + TAM_LOCY
            
            ' selecciona localidad sobre la que est el ratn
            If MouseX >= lX And MouseX <= lX1 And MouseY >= lY And MouseY <= lY1 Then
                lSelecc = i
                i = n
            End If
        End If
        
    Next
    
    LocRaton = lSelecc
    
End Function

Private Sub picConex2_DblClick()
    Dim frm As Form

    ' si no hay ninguna seleccionada o hay ms de una, sale
    If lLocSelecc(0) < 0 Or UBound(lLocSelecc) > 0 Then
        Exit Sub
    End If

    Set frm = New frmEditarConex
    frm.nLocalidad = lLocSelecc(0)
    frm.Show vbModal
    
    DibujaMapa

End Sub

' comprueba si una localidad est seleccionada
Private Function EsLocSelecc(ByVal lLoc As Long) As Boolean
    Dim i As Integer
    
    For i = 0 To UBound(lLocSelecc)
        If lLocSelecc(i) = lLoc Then
            EsLocSelecc = True
            Exit Function
        End If
    Next

    EsLocSelecc = False
    
End Function

' dibuja las localidades seleccionadas
Private Sub DibujaLocSelecc()
    Dim i As Long, n As Long, lX As Long, lY As Long, lX1 As Long, lY1 As Long, _
      lLoc As Long
    Dim iLoc As Integer, iModo As Integer, iEstilo As Integer
    Dim sLocalidad As String

    If lLocSelecc(0) < 0 Then
        Exit Sub
    End If
    
    iModo = picConex2.DrawMode
    iEstilo = picConex2.DrawStyle
    picConex2.DrawMode = vbInvert
    picConex2.DrawStyle = vbDot

    For iLoc = 0 To UBound(lLocSelecc)
        lX = Localidades(lLocSelecc(iLoc)).X
        lY = Localidades(lLocSelecc(iLoc)).Y
        If lX = -1 Or lY = -1 Then
            Exit Sub
        End If
            
        picConex2.Line (lX, lY)-Step(TAM_LOCX, TAM_LOCY), , B
    
        ' traza las conexiones
        n = UBound(Localidades(lLocSelecc(iLoc)).Conexiones)
        For i = 0 To n
            sLocalidad = Localidades(lLocSelecc(iLoc)).Conexiones(i).Localidad
            
            ' busca la localidad con la que est conectada
            lLoc = BuscaLocalidad(sLocalidad)
            If lLoc >= 0 Then
                lX1 = Localidades(lLoc).X
                lY1 = Localidades(lLoc).Y
                If Localidades(lLoc).Nombre <> "" And lX1 <> -1 And lY1 <> -1 Then
                    picConex2.Line (lX + (TAM_LOCX / 2), lY + (TAM_LOCY / 2))-(lX1 + (TAM_LOCX / 2), lY1 + (TAM_LOCY / 2))
                End If
            End If
        Next
    Next
    
    picConex2.DrawMode = iModo
    picConex2.DrawStyle = iEstilo

End Sub

Private Sub picConex2_DragDrop(Source As Control, X As Single, Y As Single)

    Select Case UCase(Source.Name)
        Case "LSTLOC"
            NuevaLoc Source, CLng(X), CLng(Y)
        Case "LSTOBJ"
            LocObj Source, CLng(X), CLng(Y)
        Case "LSTPSI"
            LocPsi Source, CLng(X), CLng(Y)
    End Select

End Sub

Private Sub picConex2_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim lSelecc As Long
    Dim i As Integer, iOpc As Integer

    If Button = vbLeftButton Then
        lSelecc = LocRaton
        
        ' si hemos pulsado sobre una localidad
        If lSelecc >= 0 Then
            If bModoConex Then
                bModoConex = False
                TrazaConex MouseX, MouseY
                
                ' crea conexin entre localidad origen y destino
                If lLocSelecc(0) = lSelecc Then
                    iOpc = MsgBox("Se va a crear una conexin de la localidad consigo misma. Quieres continuar?", _
                      vbYesNo + vbQuestion, "Crear conexin")
                    If iOpc <> vbYes Then
                        DibujaMapa
                        Exit Sub
                    End If
                End If
                CreaConex lLocSelecc(0), lSelecc
                DibujaMapa
                Exit Sub
            End If
        
            ' si tiene pulsada CTRL hace seleccin mltiple
            If Shift And vbCtrlMask Then
                If Not EsLocSelecc(lSelecc) Then
                    DibujaLocSelecc
                    i = UBound(lLocSelecc) + 1
                    ReDim Preserve lLocSelecc(i)
                    lLocSelecc(i) = lSelecc
                    DibujaLocSelecc
                End If
            ' si no es una localidad seleccionada, deselecciona las que haya y
            ' selecciona esta
            ElseIf Not EsLocSelecc(lSelecc) Then
                DibujaLocSelecc
                ReDim lLocSelecc(0)
                lLocSelecc(0) = lSelecc
                DibujaLocSelecc
            End If
        Else
            ReDim lLocSelecc(0)
            lLocSelecc(0) = -1
            DibujaMapa
            bModoSelecc = True
            SeleccX = X
            SeleccY = Y
            DibujaSelecc X, Y
        End If
    ElseIf Button = vbRightButton And Not bModoConex Then
        lSelecc = LocRaton
        ' si se ha pinchado con el botn derecho sobre una localidad y
        ' no hay ninguna otra seleccionada
        If lSelecc >= 0 And UBound(lLocSelecc) = 0 Then
            lLocSelecc(0) = lSelecc
            bModoConex = True
            TrazaConex MouseX, MouseY
        End If
    End If
    
End Sub

Private Sub picConex2_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim MouseX0 As Single, MouseY0 As Single
    Dim lX0 As Long, lY0 As Long, lX As Long, lY As Long, lDifX As Long, lDifY As Long
    Dim i As Integer

    MouseX0 = MouseX
    MouseY0 = MouseY
    MouseX = X
    MouseY = Y
    
    ' modo de seleccin rectangular
    If bModoSelecc Then
        DibujaSelecc MouseX0, MouseY0
        DibujaSelecc MouseX, MouseY
        Exit Sub
    End If
    
    ' modo de trazado de conexiones
    If bModoConex And lLocSelecc(0) <> -1 Then
        TrazaConex MouseX0, MouseY0
        TrazaConex MouseX, MouseY
        Exit Sub
    End If
    
    If Button = vbLeftButton Then
        ' hace scroll de la zona de dibujo, si es necesario
        ScrollPicConex X, Y
        
        ' arrastra las localidades seleccionadas
        If lLocSelecc(0) <> -1 Then
            If bCuadricula Then
                lX0 = (CLng(MouseX0) \ TAM_LOCX) * TAM_LOCX
                lY0 = (CLng(MouseY0) \ TAM_LOCY) * TAM_LOCY
                lX = (CLng(MouseX) \ TAM_LOCX) * TAM_LOCX
                lY = (CLng(MouseY) \ TAM_LOCY) * TAM_LOCY
            Else
                lX0 = CLng(MouseX0)
                lY0 = CLng(MouseY0)
                lX = CLng(MouseX)
                lY = CLng(MouseY)
            End If
            lDifX = lX - lX0
            lDifY = lY - lY0
            
            ' si se ha movido
            DibujaLocSelecc
            For i = 0 To UBound(lLocSelecc)
                lX = Localidades(lLocSelecc(i)).X + lDifX
                If bCuadricula Then
                    lX = (lX \ TAM_LOCX) * TAM_LOCX
                End If
                If lX >= 0 And lX <= picConex2.ScaleWidth - TAM_LOCX Then
                    Localidades(lLocSelecc(i)).X = lX
                End If
                lY = Localidades(lLocSelecc(i)).Y + lDifY
                If bCuadricula Then
                    lY = (lY \ TAM_LOCY) * TAM_LOCY
                End If
                If lY >= 0 And lY <= picConex2.ScaleHeight - TAM_LOCY Then
                    Localidades(lLocSelecc(i)).Y = lY
                End If
            Next
            DibujaLocSelecc
        End If
    End If

End Sub

Private Sub TrazaConex(X As Single, Y As Single)
    Dim LocX As Single, LocY As Single
    Dim iModo As Integer, iEstilo As Integer
    
    If lLocSelecc(0) < 0 Then
        Exit Sub
    End If
    
    LocX = Localidades(lLocSelecc(0)).X
    LocY = Localidades(lLocSelecc(0)).Y
    
    iModo = picConex2.DrawMode
    iEstilo = picConex2.DrawStyle
    
    picConex2.DrawMode = vbInvert
    picConex2.DrawStyle = vbDot
    
    picConex2.Line (LocX + (TAM_LOCX / 2), LocY + (TAM_LOCY / 2))-(X, Y)
    
    picConex2.DrawStyle = iEstilo
    picConex2.DrawMode = iModo
    
End Sub

Private Sub picConex2_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

    DibujaMapa
    
    If bModoSelecc Then
        SeleccRect X, Y
        bModoSelecc = False
    End If

End Sub

Private Sub Toolbar1_ButtonClick(ByVal Button As MSComctlLib.Button)

    Select Case Button.key
        Case "BORRAR"
            BorrarLocalidad
        Case "LISTA"
            frmLstLoc.Show
            frmLstLoc.ZOrder 0
        Case "OBJETOS"
            frmLstObj.Show
            frmLstObj.ZOrder 0
        Case "PSIs"
            frmLstPSI.Show
            frmLstPSI.ZOrder 0
        Case "CUADRICULA"
            bCuadricula = IIf(Toolbar1.Buttons(Button.key).value = tbrPressed, True, False)
        Case "DESC", "CONEX", "AUTOCONEX"
            DibujaMapa
        Case "ORDENARCONEX"
            OrdenarConexLoc
    End Select

End Sub

Private Sub Toolbar1_ButtonMenuClick(ByVal ButtonMenu As MSComctlLib.ButtonMenu)

    If ButtonMenu.Parent.key = "IMPEXP" Then
        Select Case ButtonMenu.key
            Case "IMPORTAR"
                ImportarMapa
            Case "EXPORTAR"
                ExportarMapa
        End Select
    End If

End Sub

Private Sub vScr_Change()

    picConex2.Top = -vScr.value

End Sub

Private Sub BorrarLocalidad()
    Dim sLoc As String
    Dim i As Integer, iOpc As Integer
    
    If lLocSelecc(0) < 0 Then
        Exit Sub
    End If
    
    iOpc = MsgBox("Se van a borrar del mapa las localidades seleccionadas (las localidades no" & _
      " se borrarn de la tabla de localidades). Quieres continuar?", _
      vbYesNo + vbQuestion, "Borrar localidades")
    If iOpc <> vbYes Then
        Exit Sub
    End If
    
    ' elimina las localidades de la pantalla y borra su tabla de conexiones
    For i = 0 To UBound(lLocSelecc)
        sLoc = Localidades(lLocSelecc(i)).Nombre
        Localidades(lLocSelecc(i)).X = -1
        Localidades(lLocSelecc(i)).Y = -1
        ReDim Localidades(lLocSelecc(i)).Conexiones(0)
        
        ' borra conexiones con la localidad eliminada
        BorrarConexLocalidad sLoc
    Next
    
    DibujaMapa
    
End Sub

Private Sub CreaConex(lLocOrigen As Long, lLocDestino As Long)
    Dim sLocDestino As String, sVerbo As String
    Dim i As Long, n As Long
    Dim iOpc As Integer

    If lLocOrigen < 0 Then
        Exit Sub
    End If

    ' desplegable de verbos de movimiento
    sVerbo = ListaVerbosMov
    If sVerbo = "" Then
        Exit Sub
    End If

    sLocDestino = Localidades(lLocDestino).Nombre

    ' comprueba si ya existe una conexin con ese verbo de movimiento y otra localidad
    ' si existe la cambia a la nueva localidad
    n = UBound(Localidades(lLocOrigen).Conexiones)
    For i = 0 To n
        If Localidades(lLocOrigen).Conexiones(i).Verbo = sVerbo Then
            Localidades(lLocOrigen).Conexiones(i).Localidad = sLocDestino
            Exit Sub
        End If
    Next

    ' aade una nueva conexin
    ' esta comprobacin es para la primera conexin que se aade
    ' para que no la deje en blanco
    If Localidades(lLocOrigen).Conexiones(n).Localidad <> "" Then
        n = n + 1
    End If
    ReDim Preserve Localidades(lLocOrigen).Conexiones(n)
    Localidades(lLocOrigen).Conexiones(n).Localidad = sLocDestino
    Localidades(lLocOrigen).Conexiones(n).Verbo = sVerbo
    Localidades(lLocOrigen).Conexiones(n).Abierta = True

    ' para que las conexiones aparezcan ordenadas
    OrdenarConex lLocOrigen

End Sub

' dibuja la seleccin rectangular
Private Sub DibujaSelecc(ByVal X As Single, Y As Single)
    Dim iModo As Integer, iEstilo As Integer

    iModo = picConex2.DrawMode
    iEstilo = picConex2.DrawStyle
    picConex2.DrawMode = vbInvert
    picConex2.DrawStyle = vbDot
    picConex2.Line (SeleccX, SeleccY)-(X, Y), , B
    picConex2.DrawMode = iModo
    picConex2.DrawStyle = iEstilo

End Sub

' selecciona las localidades contenidas en un contorno rectangular
Private Sub SeleccRect(ByVal X As Single, ByVal Y As Single)
    Dim Tmp As Single
    Dim i As Long, lLocX0 As Long, lLocY0 As Long, lLocX1 As Long, lLocY1 As Long
    Dim iSelecc As Integer

    ' intercambiamos coordenadas para que queden en "SeleccX" y "SeleccY" las menores
    If X < SeleccX Then
        Tmp = X
        X = SeleccX
        SeleccX = Tmp
    End If
    If Y < SeleccY Then
        Tmp = Y
        Y = SeleccY
        SeleccY = Tmp
    End If

    ReDim lLocSelecc(0)
    lLocSelecc(0) = -1
    iSelecc = 0
    
    DibujaLocSelecc
    
    For i = 0 To UBound(Localidades)
        lLocX0 = Localidades(i).X
        lLocY0 = Localidades(i).Y
        lLocX1 = lLocX0 + TAM_LOCX
        lLocY1 = lLocY0 + TAM_LOCY
        If lLocX0 >= SeleccX And lLocX0 <= X And lLocX1 >= SeleccX And lLocX1 <= X And _
          lLocY0 >= SeleccY And lLocY0 <= Y And lLocY1 >= SeleccY And lLocY1 <= Y Then
            ReDim Preserve lLocSelecc(iSelecc)
            lLocSelecc(iSelecc) = i
            iSelecc = iSelecc + 1
        End If
    Next
    
    DibujaLocSelecc

End Sub

Private Sub ScrollPicConex(ByVal X As Single, Y As Single)
    Dim i As Long
    
    ' scroll horizontal
    If X < -picConex2.Left Then
        i = hScr.value - hScr.SmallChange
        If i >= hScr.Min Then
            hScr.value = i
        End If
        picConex2.Left = -hScr.value
    ElseIf X > -picConex2.Left + picConex1.ScaleWidth Then
        i = hScr.value + hScr.SmallChange
        If i <= hScr.Max Then
            hScr.value = i
        End If
        picConex2.Left = -hScr.value
    End If

    ' scroll vertical
    If Y < -picConex2.Top Then
        i = vScr.value - vScr.SmallChange
        If i >= vScr.Min Then
            vScr.value = i
        End If
        picConex2.Top = -vScr.value
    ElseIf Y > -picConex2.Top + picConex1.ScaleHeight Then
        i = vScr.value + vScr.SmallChange
        If i <= vScr.Max Then
            vScr.value = i
        End If
        picConex2.Top = -vScr.value
    End If
    
    Me.Refresh
    
End Sub

' presenta la lista de verbos de movimiento y permite elegir uno, devuelve
' cadena vaca si no seleccion nada
Private Function ListaVerbosMov() As String
    Dim i As Long
    
    If Not bHayVoc Then
        Exit Function
    End If
    
    Load frmLista
    For i = 0 To UBound(Vocabulario)
        If Vocabulario(i).Tipo = VOC_VERBOMOV Then
            frmLista.lstLista.AddItem Vocabulario(i).Palabra
        End If
    Next
    
    frmLista.Left = Me.Left + (MouseX + picConex2.Left)
    frmLista.Top = Me.Top + (MouseY + picConex2.Top)
    
    frmLista.Show vbModal
    ListaVerbosMov = frmLista.sSelecc
    Unload frmLista
        
End Function

' aade una nueva localidad
Private Sub NuevaLoc(Lst As ListView, ByVal X As Long, Y As Long)
    Dim lLoc As Long
    Dim iOpc As Integer
    
    ' coge la localidad que est seleccionada
    If Lst.ListItems.Count < 1 Then
        Exit Sub
    End If
    lLoc = CLng(Mid(Lst.SelectedItem.key, 2))
    
    ' comprobamos si se intenta superponer sobre otra ya existente
    MouseX = X
    MouseY = Y
    If LocRaton <> -1 Then
        iOpc = MsgBox("La localidad se superpone con una existente. Quieres continuar?", _
          vbYesNo + vbQuestion, "Colocar localidad")
        If iOpc <> vbYes Then
            Exit Sub
        End If
    End If
    
    DibujaMapa
        
    ' coloca la localidad en la pantalla
    If Localidades(lLoc).X = -1 And Localidades(lLoc).Y = -1 Then
        Localidades(lLoc).X = (X \ TAM_LOCX) * TAM_LOCX
        Localidades(lLoc).Y = (Y \ TAM_LOCY) * TAM_LOCY
    End If
    
    DibujaMapa

End Sub

' coloca un objeto en una localidad
Private Sub LocObj(Lst As ListView, ByVal X As Long, Y As Long)
    Dim lLoc As Long, lObj As Long
    Dim iOpc As Integer

    ' coge el objeto seleccionado
    If Lst.ListItems.Count < 1 Then
        Exit Sub
    End If
    lObj = CLng(Mid(Lst.SelectedItem.key, 2))

    MouseX = X
    MouseY = Y
    lLoc = LocRaton

    If lLoc = -1 Then
        Exit Sub
    End If

    If Objetos(lObj).Contenedor <> "" Then
        iOpc = MsgBox("Se va a cambiar la localizacin del objeto " & _
          Objetos(lObj).Nombre & " " & Objetos(lObj).Adjetivo & vbCrLf & _
          "Quieres continuar?", _
          vbYesNo + vbQuestion, "Situar objeto en localidad")
        If iOpc <> vbYes Then
            Exit Sub
        End If
    End If
    
    Objetos(lObj).TipoContenedor = OBJ_CONTLOC
    Objetos(lObj).Contenedor = Localidades(lLoc).Nombre

End Sub

' coloca un PSI en una localidad
Private Sub LocPsi(Lst As ListView, ByVal X As Long, Y As Long)
    Dim lLoc As Long, lPSI As Long
    Dim iOpc As Integer

    ' coge el PSI seleccionado
    If Lst.ListItems.Count < 1 Then
        Exit Sub
    End If
    lPSI = CLng(Mid(Lst.SelectedItem.key, 2))

    MouseX = X
    MouseY = Y
    lLoc = LocRaton

    If lLoc = -1 Then
        Exit Sub
    End If
    
    If PSIs(lPSI).Localidad <> "" Then
        iOpc = MsgBox("Se va a cambiar la localizacin del PSI " & _
          PSIs(lPSI).Nombre & " " & PSIs(lPSI).Adjetivo & vbCrLf & _
          "Quieres continuar?", _
          vbYesNo + vbQuestion, "Situar PSI en localidad")
        If iOpc <> vbYes Then
            Exit Sub
        End If
    End If
    
    PSIs(lPSI).Localidad = Localidades(lLoc).Nombre

End Sub

' ordena las conexiones de una localidad de acuerdo a la posicin de los verbos
' de movimiento en el vocabulario
Private Sub OrdenarConex(ByVal lLoc As Long)
    Dim bCambio As Boolean, bAbierta1 As Boolean, bAbierta2 As Boolean
    Dim i As Long, lPal1 As Long, lPal2 As Long
    Dim sVerbo1 As String, sVerbo2 As String, sLoc1 As String, sLoc2 As String

    If Localidades(lLoc).Conexiones(0).Localidad <> "" And Localidades(lLoc).Conexiones(0).Verbo <> "" Then
        Do
            bCambio = False
            For i = 0 To UBound(Localidades(lLoc).Conexiones) - 1
                sVerbo1 = Localidades(lLoc).Conexiones(i).Verbo
                sLoc1 = Localidades(lLoc).Conexiones(i).Localidad
                sVerbo2 = Localidades(lLoc).Conexiones(i + 1).Verbo
                sLoc2 = Localidades(lLoc).Conexiones(i + 1).Localidad
                lPal1 = EstaEnVoc(sVerbo1, -1, 0)
                lPal2 = EstaEnVoc(sVerbo2, -1, 0)
                bAbierta1 = Localidades(lLoc).Conexiones(i).Abierta
                bAbierta2 = Localidades(lLoc).Conexiones(i + 1).Abierta
                ' si el 2 verbo de conexin tiene una posicin menor en el vocabulario
                ' intercambiamos las conexiones
                If lPal2 < lPal1 Then
                    Localidades(lLoc).Conexiones(i).Verbo = sVerbo2
                    Localidades(lLoc).Conexiones(i).Localidad = sLoc2
                    Localidades(lLoc).Conexiones(i).Abierta = bAbierta2
                    Localidades(lLoc).Conexiones(i + 1).Verbo = sVerbo1
                    Localidades(lLoc).Conexiones(i + 1).Localidad = sLoc1
                    Localidades(lLoc).Conexiones(i + 1).Abierta = bAbierta1
                    bCambio = True
                End If
            Next
        Loop While bCambio
    End If

End Sub

' ordena las conexiones de todas las localidades
Private Sub OrdenarConexLoc()
    Dim i As Long
    Dim iOpc As Integer
    
    iOpc = MsgBox("Esta opcin ordena las conexiones de todas las localidades para que aparezcan" & _
      " en el orden en el que estn definidos los verbos de movimiento en el vocabulario." & _
      " Quieres continuar?", vbYesNo + vbQuestion, "Ordenar conexiones")
    If iOpc <> vbYes Then
        Exit Sub
    End If
    
    Screen.MousePointer = vbHourglass
    For i = 0 To UBound(Localidades)
        OrdenarConex i
    Next
    Screen.MousePointer = vbDefault

End Sub

' exporta las localidades seleccionadas
Private Sub ExportarMapa()
    Dim iFich As Integer, iOpc As Integer
    Dim sFich As String
    Dim i As Long
    
    If lLocSelecc(0) < 0 Then
        MsgBox "No hay ninguna localidad seleccionada.", vbOKOnly + vbInformation, "Exportar mapa"
        Exit Sub
    End If
    
    CommonDialog1.DialogTitle = "Exportar mapa"
    CommonDialog1.Filter = "Mapas de Visual SINTAC|*" & EXT_LOCX & "|Todos los archivos|*.*"
    CommonDialog1.InitDir = App.Path
    CommonDialog1.Flags = cdlOFNPathMustExist Or cdlOFNHideReadOnly Or cdlOFNNoReadOnlyReturn
    CommonDialog1.CancelError = True
    CommonDialog1.fileName = ""
    
    On Error Resume Next
    CommonDialog1.ShowOpen
    If Err.Number <> 0 Then
        Exit Sub
    End If
    sFich = CommonDialog1.fileName
    
    ' comprobamos si el fichero ya existe
    If ExisteFichero(sFich) Then
        iOpc = MsgBox("El fichero ya existe. Quieres sobreescribirlo?", vbYesNo + vbQuestion, "Exportar mdulo")
        If iOpc <> vbYes Then
            Exit Sub
        End If
    End If

    Screen.MousePointer = vbHourglass
    On Error GoTo Error_ExportarMapa2
    iFich = FreeFile
    Open sFich For Output As #iFich
    On Error GoTo Error_ExportarMapa1
    
    EscribirLocalidades iFich, lLocSelecc
    Close #iFich
    
    Screen.MousePointer = vbDefault
    MsgBox "El mapa ha sido exportado correctamente.", vbOKOnly + vbInformation, "Exportar mapa"
    Exit Sub

Error_ExportarMapa1:
    Close #iFich
Error_ExportarMapa2:
    Screen.MousePointer = vbDefault
    MsgBox "Error al exportar mapa: " & Err.Description, vbOKOnly + vbCritical, "Exportar mapa"
End Sub

' importa un mapa
Private Sub ImportarMapa()
    Dim l() As Localidad
    Dim bLocalidades As Boolean, bConexValida As Boolean
    Dim sFich As String, sNombre As String, sAntNombre As String
    Dim iFich As Integer
    Dim i As Long, j As Long, k As Long, n As Long, lMinX As Long, lMinY As Long
    
    CommonDialog1.DialogTitle = "Importar mapa"
    CommonDialog1.Filter = "Mapas de Visual SINTAC|*" & EXT_LOCX & "|Todos los archivos|*.*"
    CommonDialog1.InitDir = App.Path
    CommonDialog1.Flags = cdlOFNFileMustExist Or cdlOFNPathMustExist Or cdlOFNHideReadOnly
    CommonDialog1.CancelError = True
    CommonDialog1.fileName = ""
    
    On Error Resume Next
    CommonDialog1.ShowOpen
    If Err.Number <> 0 Then
        Exit Sub
    End If
    sFich = CommonDialog1.fileName

    Screen.MousePointer = vbHourglass
    On Error GoTo Error_ImportarMapa2
    iFich = FreeFile
    Open sFich For Input As #iFich
    On Error GoTo Error_ImportarMapa1

    bLocalidades = LeerLocalidades(iFich, l())
    Close #iFich

    If Not bLocalidades Then
        Screen.MousePointer = vbDefault
        MsgBox "No se import ninguna localidad.", vbOKOnly + vbInformation, "Importar mapa"
        Exit Sub
    End If

    ' comprobamos conflictos de nombres
    ' calculamos las coordenadas mnimas
    lMinX = 99999999
    lMinY = 99999999
    For i = 0 To UBound(l)
        ' coordenadas mximas y mnimas
        If l(i).X < lMinX Then
            lMinX = l(i).X
        End If
        If l(i).Y < lMinY Then
            lMinY = l(i).Y
        End If
    
        If ExisteLocalidad(l(i).Nombre) Then
            sNombre = l(i).Nombre
            Screen.MousePointer = vbDefault
            Do
                sNombre = InputBox("La localidad " & sNombre & " ya existe." & _
                  " Teclee un nuevo nombre para esta localidad.", "Localidad repetida", _
                  sNombre)
                If sNombre = "" Then
                    Screen.MousePointer = vbDefault
                    MsgBox "El proceso de importacin se ha cancelado.", vbOKOnly + vbInformation, "Importar mapa"
                    Exit Sub
                End If
                sNombre = UCase(sNombre)
            Loop While ExisteLocalidad(sNombre)
            Screen.MousePointer = vbHourglass
            
            ' cambiamos nombre de localidad
            sAntNombre = l(i).Nombre
            l(i).Nombre = sNombre
            
            ' cambiamos posibles referencias a esa localidad en las conexiones
            For j = 0 To UBound(l)
                If l(j).Conexiones(0).Verbo <> "" Then
                    For k = 0 To UBound(l(j).Conexiones)
                        If l(j).Conexiones(k).Localidad = sAntNombre Then
                            l(j).Conexiones(k).Localidad = sNombre
                        End If
                    Next
                End If
            Next
        End If
    Next
    
    ' posicionamos las localidades en el mapa, las aadimos y las
    ' dejamos seleccionadas
    ReDim lLocSelecc(0)
    lLocSelecc(0) = -1
    For i = 0 To UBound(l)
        If Not NuevaLocalidad(l(i).Nombre, l(i).DescCorta, l(i).DescLarga, l(i).Iluminada, _
          l(i).Exterior) Then
                ReDim lLocSelecc(0)
                lLocSelecc(0) = -1
                Err.Description = "Error al crear nueva localidad"
                GoTo Error_ImportarMapa2
        End If
        
        j = UBound(Localidades)
        Localidades(j).Grafico = l(i).Grafico
        Localidades(j).Sonido = l(i).Sonido
        Localidades(j).X = l(i).X - lMinX
        Localidades(j).Y = l(i).Y - lMinY
        ReDim Localidades(j).Conexiones(0)
        If l(i).Conexiones(0).Verbo <> "" Then
            For k = 0 To UBound(l(i).Conexiones)
                ' comprobamos que la conexion va a una localidad existente
                bConexValida = ExisteLocalidad(l(i).Conexiones(k).Localidad)
                If Not bConexValida Then
                    For n = 0 To UBound(l)
                        If l(i).Conexiones(k).Localidad = l(n).Nombre Then
                            bConexValida = True
                            Exit For
                        End If
                    Next
                End If
                
                If bConexValida Then
                    If Localidades(j).Conexiones(0).Verbo = "" Then
                        n = 0
                    Else
                        n = UBound(Localidades(j).Conexiones) + 1
                        ReDim Localidades(j).Conexiones(n)
                    End If
                    Localidades(j).Conexiones(n) = l(i).Conexiones(k)
                End If
            Next
        End If
        
        ReDim Preserve lLocSelecc(i)
        lLocSelecc(i) = j
    Next
       
    DibujaMapa
    ActualizarFormularios
    
    Screen.MousePointer = vbDefault
    MsgBox "El mapa se ha importado correctamente.", vbOKOnly + vbInformation, "Importar mapa"
    Exit Sub

Error_ImportarMapa1:
    Close #iFich
Error_ImportarMapa2:
    Screen.MousePointer = vbDefault
    MsgBox "Error al importar mapa: " & Err.Description, vbOKOnly + vbCritical, "Importar mapa"
End Sub

' actualiza los formularios que dependen de este
Private Sub ActualizarFormularios()

    If EstaCargado(frmLocalidades) Then
        frmLocalidades.ActualizarListaLoc
    End If

End Sub
