/****************************************************************************
				  RATON.C

	Biblioteca de funciones para gestionar el ratn.

			     (c)1995 JSJ Soft Ltd.

	Las siguientes funciones son pblicas:
		- r_inicializa: inicializa las rutinas de control del ratn
		- r_puntero: muestra u oculta el puntero del ratn
		- r_estado: devuelve el estado actual del ratn
		- r_pon_puntero: coloca el puntero en una posicin de
		    pantalla
		- r_desconecta: desconecta ratn

	Las siguientes estructuras estn definidas en RATON.H
		STC_RATON: informacin sobre el estado del ratn
****************************************************************************/

#include "raton.h"

/* Variables globales internas */
static int raton_inicializado=0;	/* 0 ratn no inicializado */

/****************************************************************************
	R_INICIALIZA: inicializa las rutinas de control de ratn.
	  Salida:       1 si hay ratn conectado, 0 si no
****************************************************************************/
int r_inicializa(void)
{
int raton;

/* inicializa rutinas de control */
asm {
	mov ax,0        // inicializar 'driver' de ratn
	int 33h
	mov raton,ax
}

/* sale si no hay ratn */
if(!raton) return(0);

/* si hay ratn, visualiza el puntero */
asm {
	mov ax,1
	int 33h
}

raton_inicializado=1;

return(1);
}

/****************************************************************************
	R_PUNTERO: muestra u oculta el puntero del ratn.
	  Entrada:      'modo' puede ser R_MUESTRA para mostrar el puntero
			o R_OCULTA para ocultarlo
	  Salida:       1 si ratn inicializado, 0 si no o no hay ratn
			conectado
****************************************************************************/
int r_puntero(int modo)
{

/* si ratn no est inicializado, sale */
if(!raton_inicializado) return(0);

asm {
	mov ax,modo
	int 33h
}

return(1);
}

/****************************************************************************
	R_ESTADO: recoge la posicin actual del ratn y el estado de los
	  botones.
	  Entrada:      'r' puntero a estructura en la que se devolver
			la informacin del ratn
	  Salida:       1 si ratn inicializado, 0 si no o no hay ratn
			conectado
****************************************************************************/
int r_estado(STC_RATON *r)
{
int bot, x, y;

r->boton1=0;
r->boton2=0;
r->xv=R_NOVAL;
r->yv=R_NOVAL;
r->fil=R_NOVAL;
r->col=R_NOVAL;

/* si ratn no est inicializado, sale */
if(!raton_inicializado) return(0);

/* recoge estado de los botones y posicin del ratn */
asm {
	mov ax,3
	int 33h
	mov bot,bx
	mov x,cx
	mov y,dx
}

/* coordenadas virtuales */
r->xv=x;
r->yv=y;

/* calcula fila, columna suponiendo una pantalla virtual de 640x200 */
/* y que est en un modo de texto de 80x25 */
r->col=x/8;
r->fil=y/8;

/* comprueba estado de los botones */
if(bot & 0x0001) r->boton1=1;
if(bot & 0x0002) r->boton2=1;

return(1);
}

/****************************************************************************
	R_PON_PUNTERO: coloca el puntero en una nueva posicin de pantalla.
	  Entrada:	'fil', 'col' nueva posicin del ratn
	  Salida:       1 si ratn inicializado, 0 si no o no hay ratn
			conectado
****************************************************************************/
int r_pon_puntero(int fil, int col)
{
int xv, yv;

/* si ratn no est inicializado, sale */
if(!raton_inicializado) return(0);

/* convierte coordenadas reales en coordenadas virtuales, suponiendo una */
/* pantalla virtual de 640x200 y que est en un modo de texto de 80x25 */
xv=col*8;
yv=fil*8;

/* coloca puntero en nueva posicin */
asm {
	mov ax,4
	mov cx,xv
	mov dx,yv
	int 33h
}

return(1);
}

/****************************************************************************
	R_DESCONECTA: desconecta ratn.
****************************************************************************/
void r_desconecta(void)
{

asm {
	mov ax,0        // inicializar 'driver' de ratn
	int 33h
}

raton_inicializado=0;

}
