/**************************************
      Fichero de cabecera principal
      del sistema SINTAC
**************************************/

#if !defined (SINTAC_H)
#define SINTAC_H

/*** Constantes ***/
#define MODO0_COL  80           /* columnas en el modo 0 (640x480x16) */
#define MODO0_FIL  30           /* filas en el modo 0 */
#define MODO1_COL  40           /* columnas en el modo 1 (320x200x256) */
#define MODO1_FIL  25           /* filas en el modo 1 */

#define N_SECCS    6            /* nmero de secciones en base de datos */
#define LONG_LIN   129          /* longitud mxima de lnea de entrada */
#define MARCA_S    (char)'\\'   /* marca de inicio de seccin */
#define CHR_COMENT (char)';'    /* indicador de comentario */
#define CHR_DELIM  (char)'@'    /* delimitador de texto */
#define MARCA_CNX  (char)'#'    /* marca de inicio de conexin */
#define CHR_NOPAL  (char)'_'    /* carcter indicador 'cualquier palabra' */
#define MARCA_ETQ  (char)'$'    /* marca de etiqueta */
#define BAND_0     (char)'O'    /* carcter para band. usuario desactivada */
#define BAND_1     (char)'X'    /* carcter para band. usuario activada */
#define LNGCOND    7            /* longitud de un condacto */
#define LABELS     100          /* mximo nmero de etiquetas */
#define LONGETQ    14           /* longitud mxima de etiqueta */
#define FSKIP      100          /* mximo nmero de saltos (SKIP) 'forward' */
#define FPROCESS   2000         /* mximo nmero de llamadas 'forward' */
#define NCONST     1000         /* mximo nmero de constantes */
#define LNGCONST   14           /* longitud mxima de constantes */
#define VARS       256          /* nmero de variables */
#define BANDS      32           /* nmero de banderas/8 */
#define MAXLONG    128          /* mxima longitud de la lnea de entrada */
				/* en el intrprete */

#define V_MOV      14           /* mximo nm. para verbos de movimiento */
#define N_CONV     20           /*    "    "     "  nombres convertibles */
#define N_PROP     50           /*    "    "     "     "    propios */

#define LONGPAL    6            /* longitud de palabra de vocabulario */
#if SHARE==0
#define NUM_PAL    2500         /* mximo nmero de palabras en vocabulario */
#define MAX_MSY    255          /*   "      "    "  Mensajes del Sistema */
#define MAX_MSG    255          /*   "      "    "  Mensajes */
#define MAX_LOC    252          /*   "      "    "  Localidades */
#define MAX_OBJ    255          /*   "      "    "  Objetos */
#define MAX_PRO    255          /*   "      "    "  Procesos */
#define MAX_TMSG   255          /*   "      "    "  Tablas de mensajes */
#else
#define NUM_PAL    200          /* mximo nmero de palabras en vocabulario */
#define MAX_MSY    256          /*   "      "    "  Mensajes del Sistema */
#define MAX_MSG    25           /*   "      "    "  Mensajes */
#define MAX_LOC    25           /*   "      "    "  Localidades */
#define MAX_OBJ    25           /*   "      "    "  Objetos */
#define MAX_PRO    25           /*   "      "    "  Procesos */
#define MAX_TMSG   3            /*   "      "    "  Tablas de mensajes */
#endif
#define NUM_MSY    32           /* nmero mnimo de Mensajes del Sistema */
#define TAM_MEM    0xffdc     	/* tamao (bytes) de buffers de compilador */

#define BANCOS_RAM 2    /* nmero de bancos de memoria para RAMSAVE/RAMLOAD */
#define N_VENT     10   /* mximo nmero de ventanas */
#define N_BORD     9    /* mximo nmero de tipos de borde */

/* orden de las secciones */
#define VOC 0
#define MSY 1
#define MSG 2
#define LOC 3
#define OBJ 4
#define PRO 5

#define _VERB  0        /* valor para verbo */
#define _NOMB  1        /*   "     "  nombre */
#define _ADJT  2        /*   "     "  adjetivo */
#define _CONJ  3        /*   "     "  conjuncin */
#define NO_PAL 255	/* valor de palabra nula */

#define NO_CREADO  252  /* nmero de localidad para objs. no creados */
#define PUESTO     253  /*   "    "      "      "     "   puestos */
#define COGIDO     254  /*   "    "      "      "     "   cogidos */
#define LOC_ACTUAL 255  /*   "    "      "     que equivale a loc. actual */

/* cadena de reconocimiento de fichero de base de datos */
/* los 2 caracteres finales indican la versin de la base de datos */
/* las versiones disponibles son: */
/*      'T1' primera versin, modo texto */
/*      'T2' segunda versin, modo texto */
/*      'G1' primera versin, modo grfico */
/*      'G2' segunda versin, modo grfico */
/*	'G3' tercera versin, modo grfico */
#define SRECON  "JSJ SINTAC G3"
#define L_RECON 13              /* longitud de la cadena de reconocimiento */

/* cadena de reconocimiento de fichero de fuente */
/* el ltimo carcter indica la versin de fichero */
/* versiones disponibles: */
/*      "1"     fuente de 8x14 */
/*      "2"     fuentes de 8x16 y 8x8 */
/*	"3"	fuentes de 8x16 y 8x8 proporcionales */
#define RECON_FUENTE  "JSJ SINTAC FNT3"
#define LONG_RECON_F  15        /* longitud de la cadena de reconocimiento */

/* prefijo de indireccin */
#define INDIR   255

/* nombre de fichero donde se guardarn los errores del compilador */
#define NF_ERR  "$SINT$.ERR"

/* nombre de fichero de configuracin */
#define NF_CFG  "SINTAC.CFG"

/*** Macros ***/
/* macro para codificar BYTES */
#define CODIGO(b) (BYTE)0xff-(BYTE)b

/*** Tipos de datos y estructuras ***/
#if !defined (BYTE)
#define BYTE unsigned char
#endif

typedef enum {FALSE=0, TRUE} BOOLEAN;

/* estructura de palabra de vocabulario */
struct palabra {
	char p[LONGPAL+1];      /* palabra */
	BYTE num;		/* valor */
	BYTE tipo;		/* tipo */
};

/* estructura de cabecera de fichero de base de datos */
typedef struct {
	char srecon[L_RECON+1];         /* cadena de reconocimiento */
	long fpos_voc;                  /* pos. en fichero de vocabulario */
	BYTE v_mov;                     /* mx. nm. de verbo de movimiento */
	BYTE n_conv;                    /*  "    "    " nombre convertible */
	BYTE n_prop;                    /*  "    "    " nombre propio */
	int pal_voc;                    /* nmero de palabras en vocabulario */
	long fpos_msy;                  /* pos. en fichero de mens. sistema */
	BYTE num_msy;                   /* nmero de mensajes del sistema */
	unsigned bytes_msy;             /* memoria para mensajes del sistema */
	long fpos_msg[MAX_TMSG];        /* pos. en fichero de tablas de */
					/* mensajes, 0 si tabla no existe */
	BYTE num_msg[MAX_TMSG];         /* nmero de mensajes (por tabla) */
	unsigned bytes_msg[MAX_TMSG];   /* memoria para mensajes (por tabla) */
	long fpos_loc;                  /* pos. en fichero de localidades */
	BYTE num_loc;                   /* nmero de localidades */
	unsigned bytes_loc;             /* memoria para localidades */
	unsigned bytes_conx;            /*   "      "   conexiones */
	long fpos_obj;                  /* pos. en fichero de objetos */
	BYTE num_obj;                   /* nmero de objetos */
	unsigned bytes_obj;             /* memoria para objetos */
	long fpos_pro;                  /* pos. en fichero de procesos */
	BYTE num_pro;                   /* nmero de procesos */
	unsigned bytes_pro;             /* memoria para procesos */
} CAB_SINTAC;

/* estructura de cdigo de retorno de error */
typedef struct {
	int codigo;
	unsigned long linea;
} STC_ERR;

/* estructura de etiqueta */
typedef struct {
	char etq[LONGETQ+1];    /* para guardar nombre etiqueta */
	BYTE *petq;             /*   "     "    direccin etiqueta */
} STC_ETIQUETA;

/* estructura para saltos (SKIP) 'forward' */
typedef struct {
	char etq[LONGETQ+1];    /* nombre etiqueta a sustituir */
	BYTE *fsk;              /* dnde sustituir etiqueta */
	unsigned long nl;       /* nmero de lnea en archivo de entrada */
} STC_SKPFORWARD;

/* estructura para llamadas a procesos 'forward' */
typedef struct {
	BYTE numpro;            /* nmero de proceso al que se llama */
	unsigned long nl;       /* lnea de archivo de entrada dnde llama */
} STC_PRCFORWARD;

/* estructura para constantes */
typedef struct {
	char cnst[LNGCONST+1];  /* nombre de la constante */
	BYTE valor;             /* valor de la constante */
} STC_CONSTANTE;

/* estructura del fichero de configuracin */
typedef struct {
	char dir_sintac[MAXPATH];       /* dir. del sistema SINTAC */
	char dir_bd[MAXPATH];           /* dir. bases de datos */
	char dir_util[MAXPATH];         /* dir. de utilidades */
	BYTE color_men;                 /* colores de mens de opciones */
	BYTE color_mens1;
	BYTE color_mens2;
	BYTE color_mentec;
	BYTE color_mensel;
	BYTE color_ved;                 /* colores de ventana de edicin */
	BYTE color_veds1;
	BYTE color_veds2;
	BYTE color_vedblq;
	BYTE color_vedcoment;
	BYTE color_vedesp;
	BYTE color_vedpalclv;
	BYTE color_dlg;                 /* colores de cuadros de dilogo */
	BYTE color_dlgs1;
	BYTE color_dlgs2;
	BYTE color_dlgboton;
	BYTE color_dlginput;
	BYTE color_dlgsel;
	BYTE color_dlgtec;
	BYTE color_dlgtecboton;
	BYTE color_ayd;                 /* colores de ventana de ayuda */
	BYTE color_ayds1;
	BYTE color_ayds2;
	BYTE color_aydboton;
	BYTE color_aydinput;
	BYTE color_aydsel;
	BYTE color_aydtec;
	BYTE color_aydtecboton;
	BYTE color_err;                 /* colores de ventana de errores */
	BYTE color_errs1;
	BYTE color_errs2;
	BYTE color_errboton;
	BYTE color_errinput;
	BYTE color_errsel;
	BYTE color_errtec;
	BYTE color_errtecboton;
	BYTE color_cs;                  /* colores de ventana compilador */
	BYTE color_css1;   		/* y de linkador */
	BYTE color_css2;
	BYTE color_csboton;
	BYTE color_csinput;
	BYTE color_cssel;
	BYTE color_cstec;
	BYTE color_cstecboton;
} STC_CFG;

#endif  /* SINTAC_H */
