/* UnQuill: Disassemble games written with the "Quill" adventure game system
    Copyright (C) 1996-2000  John Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "unquill.h"


void oneitem(ushrt table, uchr item)
{
    ushrt n;
    uchr  cch;
	uchr  term;

	if (arch == ARCH_SPECTRUM) term = 0x1F; else term = 0;
	cch = ~term;
    
    n=zword(table+2*item);
    xpos=0;

    while (1)
        {
        cch=(0xFF-(zmem(n++)));
		if (cch == term) break;
        expch(cch,&n);
        }
}






void clrscr(void)
{
#if 0
	char n;

	for (n = 0; n < 24; n++)
        opch32('\n');
#else
    ozcls();
#endif

    ypos=0;
}



void expdict(uchr cch, ushrt *n)
{
	ushrt d=dict;

 	if (dbver > 0) /* Early games aren't compressed & have no dictionary */
	{
		cch -= 164;
		while (cch)
       		if (zmem(d++) > 0x7f) cch--;

      /* d=address of expansion text */

		while (zmem(d) < 0x80) expch (zmem(d++) & 0x7F,n);
	        expch (zmem(d) & 0x7F,n);
	}
}



void expch_c64(uchr cch, ushrt *n)
{
	if (cch >= 'A' && cch <= 'Z') cch = tolower(cch);
	cch &= 0x7F;
	
		if      ((cch > 31) && (cch < 127)) opch32(cch);
		else if (cch > 126)  opch32('?');
		else if (cch == 8)   opch32(8);
		else if (cch == 0x0D) opch32('\n');
}



void expch_cpc(uchr cch, ushrt *n)
{
		if      ((cch > 31) && (cch < 127)) opch32(cch);
	/*	else if (cch > 164)  expdict(cch, n); */
		else if (cch > 126)  opch32('?');
                else if (cch == 9)   return;
		else if (cch == 0x0D) opch32('\n');
		else if (cch == 0x14) opch32('\n');
		else if (cch < 31)    opch32('?');
}



void expch(uchr cch, ushrt *n)
{
	ushrt tbsp;

	if (arch == ARCH_CPC)
	{
		expch_cpc(cch, n);
		return;
	}
	if (arch == ARCH_C64)
	{
		expch_c64(cch, n);
		return;
	}
	

		if      ((cch > 31) && (cch < 127)) opch32(cch);
		else if (cch > 164)  expdict(cch, n);
		else if (cch > 126)  opch32('?');
		else if (cch == 6)   for (opch32(' ');(xpos%16);opch32(' '));
		else if (cch == 8)   opch32(8);
		else if (cch ==0x0D) opch32('\n');
		else if (cch == 0x17)
		{
			tbsp=(255-zmem((*n)++)) & 0x1F;
			++(*n);
			if (xpos > tbsp) opch32('\n');
			for (;tbsp>0;tbsp--) opch32(' ');
		}
		else if ((cch > 0x0F) && (cch<0x16)) (*n)++;
}





/*
static const char *p1_moves[] = {" 001  000",
                                 " 001  001",
				 " 000  001",
				 "-001  001",
				 "-001  000",
				 "-001 -001",
				 " 000 -001",
				 " 001 -001" };
*/

/* 2 is a lousy sample size, but all the Spectrum Quill games I've examined 
 * have their graphics tables at 0xFAB8. */

