
#include <oz.h>
#include "file.h"

#define LAST_PART_NUM  34      /* Part nums start at 0 . Each part has 31 clusters * 62 bytes = 1922 */
#define LAST_PART_LEN  188      /* 34 parts * 1984 bytes + 188 bytes = 65536 bytes */

#define INDEX_MEM_PAGE 0x400
#define INDEX_PAGE_LOC  0x968


static unsigned atou2digit(char *s)
{
    return 10*s[0]+s[1]-('0'+10*'0');
}


long makerandomindex (char * name) {
	cfile_header_t * header;
	static unsigned start_page; 
	static unsigned start_offset;
	static unsigned recnumptr;
	static unsigned loc;
	static length;
	static unsigned file_id;
	static unsigned index_loc;
	byte parts_indexed = 0;
	byte last_part_num = LAST_PART_NUM;
	static unsigned long filelen;

	start_page = start_offset = recnumptr = 0;
	filelen = 0;
	
	if (-1 == (loc = ozfindfilename(name, &start_page , &start_offset , &recnumptr))) {
		return -1;
	}
	for (;;) {
		header = (cfile_header_t *) (2 + ozloadcluster(loc));
		if (header->part_number <= LAST_PART_NUM) {
			file_id = header->file_id;
			length=header->fake_time[1]-'0';
    			length=24*length+atou2digit(header->fake_alarm);
    			length=(60*length+atou2digit((header->fake_alarm)+2)) - 62;
			if (length > 1922) return -2;
			if (header->part_number == LAST_PART_NUM && length > LAST_PART_LEN) {
				length = LAST_PART_LEN;
			}
			if (header->last_part && header->part_number < LAST_PART_NUM) {
				last_part_num = header->part_number;
			}
			index_loc = INDEX_PAGE_LOC + (header->part_number * 62);
			filelen += length;
			while (length > 0) {
				ozsetmemword(INDEX_MEM_PAGE , index_loc ,  loc = ozinclocation(loc));
				index_loc +=2;
				length -=62;
			}			
			if (parts_indexed++ == last_part_num) break;
			if (!(loc = ozfindfileid(file_id , &start_page , &start_offset , &recnumptr))) {
				return -3;
			}
		}
	}
	return filelen;
}
