/***************************************************************************
 *                                                                         *
 * Copyright (C) 2006 by Mark J. Tilford                                   *
 *                                                                         *
 * This file is part of Geas.                                              *
 *                                                                         *
 * Geas is free software; you can redistribute it and/or modify            *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * Geas is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with Geas; if not, write to the Free Software                     *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *                                                                         *
 ***************************************************************************/

#include "geas-util.hh"
#include <sstream>
#include <cctype>
#include "general.hh"

using namespace std;

int eval_int (string s)
{
  uint index = 0, index2;
  string tmp;
  while (index < s.length() && isspace (s[index]))
    index ++;
  if (index == s.length() || !isdigit (s[index]))
    return 0;
  for (index2 = index; index2 < s.length() && isdigit (s[index2]); index2 ++)
    ;
  tmp = s.substr (index, index2 - index);

  //cout << "index == " << index << ", index2 == " << index2 
  //     << ", tmp == " << tmp << endl;

  int arg1 = atoi (tmp.c_str());
  index = index2;
  while (index < s.length() && isspace (s[index]))
    ;
  if (index == s.length())
    return arg1;

  //cout << "index == " << index << ", s.length() == " << s.length() << endl;

  char symbol = s[index];

  //cout << "symbol == " << symbol << "; find --> " 
  //     << string("+-*/").find (symbol) << endl;

  if (string ("+-*/").find (symbol) == string::npos)
    return arg1;

  index ++;
  while (index < s.length() && isspace (s[index]))
    ;
  if (index == s.length() || ! isdigit (s[index]))
    {
      if (symbol == '*')
	return 0;
      return arg1;
    }
  index2 = index + 1;
  while (index2 < s.length() && isdigit (s[index2]))
    ++ index2;
  tmp = s.substr (index, index2 - index);
  int arg2 = atoi (tmp.c_str());
  
  switch (symbol)
    {
    case '+': return arg1 + arg2;
    case '-': return arg1 - arg2;
    case '*': return arg1 * arg2;
    case '/': return arg1 / arg2; 
      // TODO: division should use accountant's round
    }
  return 0;
}

string trim_braces (string s)
{
  if (s.length() > 1 && s[0] == '[' && s[s.length() - 1] == ']')
    return s.substr (1, s.length() - 2);
  else
    return s;
}

bool is_param (string s)
{
  return s.length() > 1 && s[0] == '<' && s[s.length() - 1] == '>';
}

string param_contents (string s)
{
  assert (is_param(s));
  return s.substr (1, s.length() - 2);
}

string nonparam (string type, string var)
{
  return "Non-parameter for " + type + " in \"" + var + "\"";
}

//ostream &operator << (ostream &o, const GeasBlock &gb) { return o; }
//string trim (string s, trim_modes) { return s; }

std::string string_geas_block (const GeasBlock &gb)
{
  ostringstream oss;
  oss << gb;  // temporary removed TODO
  return oss.str();
}


bool starts_with (string a, string b)
{
  return (a.length() >= b.length()) && (a.substr (0, b.length()) == b);
}
bool ends_with (string a, string b)
{
  return (a.length() >= b.length()) && 
    (a.substr (a.length() - b.length(), b.length()) == b);
}

string pcase (string s)
{
  if (s.length() == 0)
    return s;
  if (islower (s[0]))
    s[0] = toupper(s[0]);
  return s;
}

string ucase (string s)
{
  for (uint i = 0; i < s.length(); i ++)
    s[i] = toupper (s[i]);
  return s;
}

// There's a good chance s is already all-lowercase, in which case
// the test will avoid making a copy
string lcase (string s)
{
  for (uint i = 0; i < s.length(); i ++)
    if (isupper (s[i]))
      s[i] = tolower (s[i]);
  return s;
}

/*
ostream &operator<< (ostream &o, const vector<string> &v)
{
  o << "{ ";
  for (uint i = 0; i < v.size(); i ++)
    {
      o << v[i];
      if (i + 1 < v.size())
	o << ", ";
    }
  o << " }";
  return o;
}
*/

/*
string trim1 (string s)
{
  uint i, j;
  for (i = 0; i < s.length() && isspace (s[i]); i ++)
    ;
  if (i == s.length())
    return "";
  for (j = s.length() - 1; j >= i && isspace (s[j]); j --)
    ;
  return s.substr (i, j - i + 1);
}
*/


/*
vector<string> split_param (string s)
{
  vector<string> rv;
  uint c1, c2, c3;
  
  c1 = 0;
  do
    {
      while (c1 < s.length() && isspace (s[c1]))
	++ c1;
      if (c1 == s.length())
	{
	  if (rv.size() > 0)
	    rv.push_back ("");
	  break;
	}
      c2 = c1 + 1;
      while (c2 < s.length() && s[c2] != ';')
	++ c2;
      c3 = c2 - 1;
      while (c3 > c1 && isspace(s[c3]))
	-- c3;
      rv.push_back (s.substr (c1, c3-c1+1));
      c1 = c2 + 1;
    } while (c1 < s.length());
  return rv;
}
*/

vector<string> split_param (string s)
{
  vector<string> rv;
  uint c1 = 0, c2;

  for (;;)
    {
      c2 = s.find (';', c1);
      if (c2 == string::npos)
	{
	  rv.push_back (trim (s.substr (c1)));
	  return rv;
	}
      rv.push_back (trim (s.substr (c1, c2-c1)));
      c1 = c2 + 1;
    }
}

vector<string> split_f_args (string s)
{
  vector<string> rv = split_param (s);
  for (uint i = 0; i < rv.size(); i ++)
    {
      string tmp = rv[i];
      if (tmp[0] == '_')
	rv[i][0] = ' ';
      if (tmp[tmp.length() - 1] == '_')
	rv[i][tmp.length() - 1] = ' ';
    }
  return rv;
}

void show_split (string s)
{
  vector<string> tmp = split_param (s);
  cout << "Splitting <" << s << ">: ";
  for (uint i = 0; i < tmp.size(); i ++)
    cout << "<" << tmp[i] << ">, ";
  cout << "\n";
}

/*
void show_parse (string s)
{
  cout << "eval_int (" << s << ") --> " << eval_int (s) << endl << endl;
}

int main (int argc, char *argv[])
{
  string data[] = { "1", "2", "2+3", "2-5", "6/3" };
  for (uint i = 0; i < ARRAYSIZE (data); i ++)
    show_parse (data[i]);
}
*/


/*
int main (int argc, char *argv[])
{
  show_split ("        ");
  show_split ("  ABC");

  show_split ("AB  ; DEF");
  show_split ("AB  ; DEF;");
  show_split ("ABC; DEF");
  show_split ("ABC ; DEF;");
  show_split ("AB; DEF");
  show_split ("AB ; DEF;");

  show_split (" AB  ; DEF");
  show_split (" AB  ; DEF;");
  show_split (" ABC; DEF");
  show_split (" ABC ; DEF;");
  show_split (" AB; DEF");
  show_split (" AB ; DEF;");
  show_split ("  AB  ; DEF");
  show_split ("  AB  ; DEF;");
  show_split ("  ABC; DEF");
  show_split ("  ABC ; DEF;");
  show_split ("  AB; DEF");
  show_split ("  AB ; DEF;");
}
*/
