/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.adverb;
import iageserver.character;
import iageserver.codemodule;
import iageserver.error;
import iageserver.flag;
import iageserver.game;
import iageserver.iagecollection;
import iageserver.item;
import iageserver.location;
import iageserver.message;
import iageserver.noun;
import iageserver.npctimer;
import iageserver.runafterinput;
import iageserver.runbeforeinput;
import iageserver.vdu;
import iageserver.verb;
import java.io.File;
import java.io.FileInputStream;

public class data {
    static boolean fileeof;
    static boolean isencrypted;
    static int encrypttype;
    public static final boolean debugging = false;
    public static int maxflags;
    public static int ipport;
    public static String versionno;
    public static String internalversion;
    public static String defaultnewplayername;
    public static boolean canstartenginenow;
    public static String lasterror;
    public static int numberofconnections;
    public static int nextplayerID;
    public static String gamepath;
    public static iagecollection oadverbs;
    public static iagecollection overbs;
    public static iagecollection onouns;
    public static game ogame;
    public static iagecollection olocations;
    public static iagecollection ocharacters;
    public static iagecollection oitems;
    public static iagecollection omodules;
    public static runafterinput orunafterinput;
    public static runbeforeinput orunbeforeinput;
    public static error oerror;
    public static npctimer onpctimer;
    public static iagecollection oplayers;
    public static iagecollection omessages;
    public static flag[] oflags;

    public data(String string) {
        block20: {
            Object object;
            canstartenginenow = false;
            numberofconnections = 0;
            nextplayerID = 1;
            oadverbs = new iagecollection();
            overbs = new iagecollection();
            onouns = new iagecollection();
            ogame = new game();
            olocations = new iagecollection();
            ocharacters = new iagecollection();
            oitems = new iagecollection();
            omodules = new iagecollection();
            orunafterinput = new runafterinput();
            orunbeforeinput = new runbeforeinput();
            oerror = new error();
            oplayers = new iagecollection();
            omessages = new iagecollection();
            oflags = new flag[maxflags];
            int n = 1;
            while (n < maxflags) {
                data.oflags[n] = object = new flag();
                ++n;
            }
            fileeof = false;
            object = new File(string);
            if (!((File)object).exists()) {
                vdu.println("file - " + string + " does not exist.");
                lasterror = "file - " + string + " does not exist.";
                return;
            }
            gamepath = string;
            try {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                vdu.println(String.valueOf(((File)object).getName()) + " opened.");
                String string2 = data.readline(fileInputStream);
                if (string2.indexOf("IAGE 2") != -1) {
                    vdu.println("IAGE File Format 2.0 detected.");
                    string2 = data.readline(fileInputStream);
                    if (string2.indexOf("0") == -1) {
                        vdu.println("File is encrypted.");
                        isencrypted = true;
                        if (string2.indexOf("1") != -1) {
                            encrypttype = 1;
                        }
                        if (string2.indexOf("2") != -1) {
                            encrypttype = 2;
                        }
                    } else {
                        vdu.println("File is not encrypted.");
                        isencrypted = false;
                    }
                    vdu.println("Loading data, please wait...");
                    while (!fileeof) {
                        string2 = data.decrypt(data.readline(fileInputStream));
                        if (this.comparestring(string2, "GAME")) {
                            vdu.print("Reading game properties...");
                            this.loadgame(fileInputStream);
                        }
                        if (this.comparestring(string2, "LOCATIONS")) {
                            vdu.print("Reading locations...");
                            this.loadlocations(fileInputStream);
                        }
                        if (this.comparestring(string2, "ITEMS")) {
                            vdu.print("Reading objects...");
                            this.loaditems(fileInputStream);
                        }
                        if (this.comparestring(string2, "CHARACTERS")) {
                            vdu.print("Reading characters...");
                            this.loadcharacters(fileInputStream);
                        }
                        if (this.comparestring(string2, "MESSAGES")) {
                            vdu.print("Reading messages...");
                            this.loadmessages(fileInputStream);
                        }
                        if (this.comparestring(string2, "NOUNS")) {
                            vdu.print("Reading dictionary (nouns)...");
                            this.loadnouns(fileInputStream);
                        }
                        if (this.comparestring(string2, "ADVERBS")) {
                            vdu.print("Reading dictionary (adverbs)...");
                            this.loadadverbs(fileInputStream);
                        }
                        if (this.comparestring(string2, "VERBS")) {
                            vdu.print("Reading dictionary (verbs)...");
                            this.loadverbs(fileInputStream);
                        }
                        if (this.comparestring(string2, "MODULES")) {
                            vdu.print("Reading code modules...");
                            this.loadmodules(fileInputStream);
                        }
                        if (this.comparestring(string2, "RUNBEFOREINPUT")) {
                            vdu.print("Reading event code (1 of 2)...");
                            this.loadrunbeforeinput(fileInputStream);
                        }
                        if (!this.comparestring(string2, "RUNAFTERINPUT")) continue;
                        vdu.print("Reading event code (2 of 2)...");
                        this.loadrunafterinput(fileInputStream);
                    }
                    vdu.println("Load complete.");
                    break block20;
                }
                vdu.println(String.valueOf(string) + " has an unrecognised file format.");
                lasterror = String.valueOf(string) + " has an unrecognised file format.";
                return;
            }
            catch (Exception exception) {
                vdu.println("Error occurred: " + exception.getMessage());
                lasterror = "Error occurred: " + exception.getMessage();
                exception.printStackTrace();
                return;
            }
        }
        canstartenginenow = true;
    }

    public static String readline(FileInputStream fileInputStream) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = -1;
        boolean bl = false;
        while (true) {
            try {
                n = fileInputStream.read();
            }
            catch (Exception exception) {
                vdu.println("Error reading from file - " + exception.getMessage());
                return stringBuffer.toString();
            }
            if (n == 10 && !bl) {
                try {
                    n = fileInputStream.read();
                }
                catch (Exception exception) {
                    vdu.println("Error reading from file - " + exception.getMessage());
                    return stringBuffer.toString();
                }
            }
            if (n == 13 || n == 10) {
                return stringBuffer.toString();
            }
            if (n == -1) {
                fileeof = true;
                return stringBuffer.toString();
            }
            bl = true;
            Integer n2 = new Integer(n);
            byte[] byArray = new byte[]{n2.byteValue()};
            stringBuffer.append(new String(byArray));
        }
    }

    private void loadgame(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !fileeof) {
            if (data.comparebuff(string, "MaxItemsCanCarry")) {
                data.ogame.MaxItemsCanCarry = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "MaxWeightCanCarry")) {
                data.ogame.MaxWeightCanCarry = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "MaxSizeCanCarry")) {
                data.ogame.MaxSizeCanCarry = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "StartingLocation")) {
                data.ogame.StartingLocation = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "RepeatDescription")) {
                data.ogame.RepeatDescription = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "ShowAvailableExits")) {
                data.ogame.ShowAvailableExits = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "AllowPersist")) {
                data.ogame.AllowPersist = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "SinglePlayerGame")) {
                data.ogame.SinglePlayerGame = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "MaxUsers")) {
                data.ogame.MaxUsers = (int)data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "IDEPassword")) {
                data.ogame.IDEPassword = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "Name")) {
                data.ogame.Name = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "OverrideSecondaryNouns")) {
                data.ogame.OverrideSecondaryNouns = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "MediaBase")) {
                data.ogame.MediaBase = data.getpropvalue_string(string);
            }
            if (data.comparebuff(string, "UsingIAGECombat")) {
                data.ogame.UsingIAGECombat = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "UsingIAGEMoney")) {
                data.ogame.UsingIAGEMoney = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "WideDisplay")) {
                game.WideDisplay = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "RealTimeNPCs")) {
                data.ogame.RealTimeNPCs = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "PlayersStayDead")) {
                data.ogame.PlayersStayDead = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "NPCsStayDead")) {
                data.ogame.NPCsStayDead = data.getpropvalue_boolean(string);
            }
            if (data.comparebuff(string, "DefaultHitPoints")) {
                data.ogame.DefaultHitPoints = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DefaultDamage")) {
                data.ogame.DefaultDamage = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DefaultMoney")) {
                data.ogame.DefaultMoney = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DefaultChanceOfHitting")) {
                data.ogame.DefaultChanceOfHitting = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "ChanceOfHittingIncrementForKill")) {
                data.ogame.ChanceOfHittingIncrementForKill = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "DamageIndicatorIncrementForKill")) {
                data.ogame.DamageIndicatorIncrementForKill = data.getpropvalue_long(string);
            }
            if (data.comparebuff(string, "OnAfterInputImmediate")) {
                data.ogame.OnAfterInputImmediate.add(data.getpropvalue_string(string));
            }
            if (data.comparebuff(string, "OnDisplayBanner")) {
                data.ogame.OnDisplayBanner.add(data.getpropvalue_string(string));
            }
            if (data.comparebuff(string, "OnQuit")) {
                data.ogame.OnQuit.add(data.getpropvalue_string(string));
            }
            if (data.comparebuff(string, "OnStart")) {
                data.ogame.OnStart.add(data.getpropvalue_string(string));
            }
            if (data.comparebuff(string, "OnScore")) {
                data.ogame.OnScore.add(data.getpropvalue_string(string));
            }
            if (data.comparebuff(string, "OnInitialise")) {
                data.ogame.OnInitialise.add(data.getpropvalue_string(string));
            }
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK.");
    }

    private void loadlocations(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            location location2 = new location();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    location2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Name")) {
                    location2.Name = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "ImagePath")) {
                    location2.ImagePath = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "Description")) {
                    location2.Description = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "IsDark")) {
                    location2.IsDark = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "CustomProperties")) {
                    location2.CustomProperties = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "N")) {
                    location2.N = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "S")) {
                    location2.S = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "E")) {
                    location2.E = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "W")) {
                    location2.W = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "U")) {
                    location2.U = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "D")) {
                    location2.D = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "NE")) {
                    location2.NE = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "NW")) {
                    location2.NW = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "SE")) {
                    location2.SE = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "SW")) {
                    location2.SW = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "OnInput")) {
                    location2.OnInput.add(data.getpropvalue_string(string));
                }
                if (data.comparebuff(string, "OnDisplay")) {
                    location2.OnDisplay.add(data.getpropvalue_string(string));
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            olocations.add(location2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(olocations.getCount()) + " Locations).");
    }

    private void loaditems(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            item item2 = new item();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    item2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Name")) {
                    item2.Name = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "CurrentLocation")) {
                    item2.CurrentLocation = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Weight")) {
                    item2.Weight = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Description")) {
                    item2.Description = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "CustomProperties")) {
                    item2.CustomProperties = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "UserBooleans")) {
                    item2.UserBooleans = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "NounID")) {
                    item2.NounID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "IsLightSource")) {
                    item2.IsLightSource = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "IsLit")) {
                    item2.IsLit = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "IsWorn")) {
                    item2.IsWorn = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "IsWeapon")) {
                    item2.IsWeapon = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "Transparent")) {
                    item2.Transparent = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "HasSurface")) {
                    item2.HasSurface = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "CanBeLaidOn")) {
                    item2.CanBeLaidOn = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "CanBeStoodOn")) {
                    item2.CanBeStoodOn = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "CanBeSatOn")) {
                    item2.CanBeSatOn = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "CanBeGotIn")) {
                    item2.CanBeGotIn = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "DefaultExamine")) {
                    item2.DefaultExamine = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "IsContainer")) {
                    item2.IsContainer = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "IsEdible")) {
                    item2.IsEdible = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "EdibleHitPoints")) {
                    item2.EdibleHitPoints = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "IsWearable")) {
                    item2.IsWearable = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "IsReadable")) {
                    item2.IsReadable = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "ReadableText")) {
                    item2.ReadableText = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "Size")) {
                    item2.Size = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "DamageIndicator")) {
                    item2.DamageIndicator = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Invisible")) {
                    item2.Invisible = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "IsFixed")) {
                    item2.IsFixed = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "CanOpenClose")) {
                    item2.CanOpenClose = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "OpenCloseState")) {
                    item2.OpenCloseState = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "FixedMessage")) {
                    item2.FixedMessage = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "IsSubItem")) {
                    item2.IsSubItem = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "SubItemOf")) {
                    item2.SubItemOf = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "OnAction")) {
                    item2.OnAction.add(data.getpropvalue_string(string));
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            oitems.add(item2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(oitems.getCount()) + " Objects).");
    }

    private void loadcharacters(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            character character2 = new character();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    character2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Name")) {
                    character2.Name = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "CurrentLocation")) {
                    character2.CurrentLocation = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Description")) {
                    character2.Description = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "CustomProperties")) {
                    character2.CustomProperties = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "NounID")) {
                    character2.NounID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "TimerInterval")) {
                    character2.TimerInterval = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "DefaultExamine")) {
                    character2.DefaultExamine = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "HitPoints")) {
                    character2.HitPoints = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "DamageIndicator")) {
                    character2.DamageIndicator = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "AutoAttack")) {
                    character2.AutoAttack = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "AttackWhenAttacked")) {
                    character2.AttackWhenAttacked = data.getpropvalue_boolean(string);
                }
                if (data.comparebuff(string, "Money")) {
                    character2.Money = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "OnTimer")) {
                    character2.OnTimer.add(data.getpropvalue_string(string));
                }
                if (data.comparebuff(string, "OnTalk")) {
                    character2.OnTalk.add(data.getpropvalue_string(string));
                }
                if (data.comparebuff(string, "OnAction")) {
                    character2.OnAction.add(data.getpropvalue_string(string));
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            ocharacters.add(character2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(ocharacters.getCount()) + " NPCs).");
    }

    private void loadverbs(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            verb verb2 = new verb();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    verb2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Text")) {
                    verb2.Text = data.getpropvalue_string(string);
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            overbs.add(verb2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(overbs.getCount()) + " Verbs).");
    }

    private void loadadverbs(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            adverb adverb2 = new adverb();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    adverb2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Text")) {
                    adverb2.Text = data.getpropvalue_string(string);
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            oadverbs.add(adverb2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(oadverbs.getCount()) + " Adverbs).");
    }

    private void loadmodules(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            codemodule codemodule2 = new codemodule();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    codemodule2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "N")) {
                    codemodule2.Name = data.getpropvalue_string(string);
                }
                if (data.comparebuff(string, "C")) {
                    codemodule2.Code.add(data.getpropvalue_string(string));
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            omodules.add(codemodule2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(omodules.getCount()) + " Code modules).");
    }

    private void loadnouns(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            noun noun2 = new noun();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    noun2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Text")) {
                    noun2.Text = data.getpropvalue_string(string);
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            onouns.add(noun2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(onouns.getCount()) + " Nouns).");
    }

    private void loadrunbeforeinput(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "$END$") && !fileeof) {
            data.orunbeforeinput.code.add(string);
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(data.orunbeforeinput.code.getCount()) + " lines).");
    }

    private void loadrunafterinput(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "$END$") && !fileeof) {
            data.orunafterinput.code.add(string);
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(data.orunafterinput.code.getCount()) + " lines).");
    }

    private void loadmessages(FileInputStream fileInputStream) {
        String string = data.decrypt(data.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !fileeof) {
            message message2 = new message();
            while (!(this.comparestring(string, "BREAK") || fileeof || this.comparestring(string, "END"))) {
                if (data.comparebuff(string, "ID")) {
                    message2.ID = data.getpropvalue_long(string);
                }
                if (data.comparebuff(string, "Text")) {
                    message2.Text = data.getpropvalue_string(string);
                }
                string = data.decrypt(data.readline(fileInputStream));
            }
            omessages.add(message2);
            if (this.comparestring(string, "END")) continue;
            string = data.decrypt(data.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(omessages.getCount()) + " Messages).");
    }

    public static long getpropvalue_long(String string) {
        String string2 = data.getvalue(string);
        return Long.parseLong(string2);
    }

    public static String getpropvalue_string(String string) {
        return data.getvalue(string);
    }

    public static boolean getpropvalue_boolean(String string) {
        String string2 = data.getvalue(string);
        return string2.equals("true") || string2.equals("True");
    }

    public static String getvalue(String string) {
        String string2 = string.substring(string.indexOf("=") + 1, string.length());
        if (string2.startsWith(" ") && string2.length() == 1) {
            return "";
        }
        string2 = data.removeleadingspaces(string2);
        string2 = data.removetrailingspaces(string2);
        return string2;
    }

    public static boolean comparebuff(String string, String string2) {
        if (string.indexOf("=") == -1) {
            return false;
        }
        String string3 = string.substring(0, string.indexOf("=") - 1);
        string3 = data.removeleadingspaces(string3);
        return (string3 = data.removetrailingspaces(string3)).equals(string2);
    }

    private boolean comparestring(String string, String string2) {
        string = data.removeleadingspaces(string);
        return (string = data.removetrailingspaces(string)).equals(string2);
    }

    public static String removeleadingspaces(String string) {
        string = string.trim();
        return string;
    }

    public static String removetrailingspaces(String string) {
        string = string.trim();
        return string;
    }

    public static String trimstring(String string) {
        string = string.trim();
        return string;
    }

    public static String decrypt(String string) {
        if (!isencrypted) {
            return string;
        }
        if (encrypttype == 1) {
            String string2 = "0123456789ABCDEF";
            byte[] byArray = new byte[string.length() / 2];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n4 = 0;
            while (n4 < string.length()) {
                string3 = string.substring(n4, n4 + 1);
                n2 = string2.indexOf(string3) * 16;
                string4 = string.substring(++n4, n4 + 1);
                n3 = string2.indexOf(string4);
                byArray[n] = Byte.parseByte(Integer.toString(n2 + n3));
                ++n;
                ++n4;
            }
            string5 = new String(byArray);
            string5 = string5.substring(0, n);
            return string5;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length];
        String string6 = "";
        int n = 0;
        while (n < byArray.length) {
            byArray2[n] = byArray[n];
            byArray2[n] = (byte)(byArray2[n] - 2);
            ++n;
        }
        string6 = new String(byArray2);
        return string6;
    }

    public static String encrypt(String string) {
        String string2 = "0123456789ABCDEF";
        byte[] byArray = string.getBytes();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n3 = 0;
        while (n3 < byArray.length) {
            d = byArray[n3];
            d2 = d / 16.0;
            int n4 = (int)d2;
            d2 = n4;
            d3 = d - d2 * 16.0;
            string3 = Double.toString(d2);
            string4 = Double.toString(d3);
            if (string3.endsWith(".0")) {
                string3 = string3.substring(0, string3.length() - 2);
            }
            if (string4.endsWith(".0")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
            string6 = string2.substring(n, n + 1);
            string6 = String.valueOf(string6) + string2.substring(n2, n2 + 1);
            string5 = String.valueOf(string5) + string6;
            ++n3;
        }
        return string5;
    }

    public static String booleanToString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static boolean stringToBoolean(String string) {
        return string.equalsIgnoreCase("true");
    }

    static {
        maxflags = 1000;
        ipport = 1111;
        versionno = "Version 020709";
        internalversion = "Internet Adventure Game Engine " + versionno + "\nWritten by R.Rawson-Tetley\nCopyright(c)2000-2002, R.Rawson-Tetley";
        defaultnewplayername = "<new player>";
        lasterror = "No error.";
        nextplayerID = 1;
        gamepath = "";
        oadverbs = new iagecollection();
        overbs = new iagecollection();
        onouns = new iagecollection();
        ogame = new game();
        olocations = new iagecollection();
        ocharacters = new iagecollection();
        oitems = new iagecollection();
        omodules = new iagecollection();
        orunafterinput = new runafterinput();
        orunbeforeinput = new runbeforeinput();
        oerror = new error();
        onpctimer = null;
        oplayers = new iagecollection();
        omessages = new iagecollection();
        oflags = new flag[maxflags];
    }
}

