/*
 * Decompiled with CFR 0.152.
 */
package iagecompiler;

import iagecompiler.character;
import iagecompiler.codemodule;
import iagecompiler.data;
import iagecompiler.iagecode;
import iagecompiler.importer;
import iagecompiler.item;
import iagecompiler.location;
import iagecompiler.message;
import iagecompiler.noun;
import iagecompiler.syntaxchecker;
import iagecompiler.vdu;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class importiage
extends importer {
    private iagecode tf = new iagecode();
    private int ci = 1;
    private boolean errorflag = false;
    private String errormsg = "";
    private boolean islibrary = false;

    public void importandcompilefromsubclass(String string) {
        this.openfilename = string;
        this.islibrary = true;
        this.fileeof = false;
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.parsesubfile(fileInputStream);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                vdu.println("Library compilation failed - " + exception.getMessage());
                return;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            vdu.println("IO Error compiling library - " + string);
            return;
        }
    }

    public void parse(FileInputStream fileInputStream) throws Exception {
        while (!this.fileeof) {
            this.tf.add(this.readline(fileInputStream));
        }
        this.startcompile();
    }

    public void parsesubfile(FileInputStream fileInputStream) throws Exception {
        while (!this.fileeof) {
            this.tf.add(this.readline(fileInputStream));
        }
        this.importsubfile();
    }

    private void importsubfile() throws Exception {
        try {
            String string;
            if (!this.islibrary) {
                vdu.println("Building " + this.openfilename + "...");
            } else {
                System.out.println("Building " + this.openfilename + "...");
            }
            System.out.println("Number of lines in file: " + Integer.toString(this.tf.getCount()));
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "#import ") || this.checkstart(string, "#import\t")) {
                    this.importandcompile(string);
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "location ") || this.checkstart(string, "location\t")) {
                    this.storelocation();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "item ") || this.checkstart(string, "item\t")) {
                    this.storeitem();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if ((string = string.trim()).indexOf(" extends ") != -1 && this.checkstart(string, "item ")) {
                    this.resolveextendeditem(string);
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "character ") || this.checkstart(string, "character\t")) {
                    this.storenpc();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "module ") || this.checkstart(string, "module\t")) {
                    this.storemodule();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "gamecode ") || this.checkstart(string, "gamecode\t")) {
                    this.storegame();
                }
                ++this.ci;
            }
            this.ci = 1;
            boolean bl = false;
            while (this.ci <= this.tf.getCount()) {
                String string2 = this.tf.get(this.ci);
                if (this.checkstart(string2 = string2.trim(), "librarymessage ") || this.checkstart(string2, "librarymessage\t")) {
                    message message2 = new message();
                    message2.ID = Long.parseLong(this.getwithproperty(string2));
                    message2.Text = this.getwithtextproperty(string2);
                    int n = 1;
                    message message3 = null;
                    bl = false;
                    while (n <= data.omessages.getCount()) {
                        message3 = (message)data.omessages.get(n);
                        if (message3.ID == message2.ID) {
                            message3.Text = message2.Text;
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        data.omessages.add(message2);
                    }
                }
                ++this.ci;
            }
            return;
        }
        catch (Exception exception) {
            vdu.println(exception.getMessage());
            exception.printStackTrace();
            throw new Exception("Errors occurred.");
        }
    }

    private void startcompile() throws Exception {
        try {
            Object object;
            Object object2;
            String string;
            if (!this.islibrary) {
                vdu.println("Building " + this.openfilename + "...");
            } else {
                System.out.println("Building " + this.openfilename + "...");
            }
            System.out.println("Number of lines in file: " + Integer.toString(this.tf.getCount()));
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "#import ") || this.checkstart(string, "#import\t")) {
                    this.importandcompile(string);
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "location ") || this.checkstart(string, "location\t")) {
                    this.storelocation();
                }
                ++this.ci;
            }
            this.resolvelocation();
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "item ") || this.checkstart(string, "item\t")) {
                    this.storeitem();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if ((string = string.trim()).indexOf(" extends ") != -1 && this.checkstart(string, "item ")) {
                    this.resolveextendeditem(string);
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "character ") || this.checkstart(string, "character\t")) {
                    this.storenpc();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "module ") || this.checkstart(string, "module\t")) {
                    this.storemodule();
                }
                ++this.ci;
            }
            this.ci = 1;
            while (this.ci <= this.tf.getCount()) {
                string = this.tf.get(this.ci);
                if (this.checkstart(string = string.trim(), "gamecode ") || this.checkstart(string, "gamecode\t")) {
                    this.storegame();
                }
                ++this.ci;
            }
            this.ci = 1;
            boolean bl = false;
            while (this.ci <= this.tf.getCount()) {
                String string2 = this.tf.get(this.ci);
                if (this.checkstart(string2 = string2.trim(), "librarymessage ") || this.checkstart(string2, "librarymessage\t")) {
                    object2 = new message();
                    ((message)object2).ID = Long.parseLong(this.getwithproperty(string2));
                    ((message)object2).Text = this.getwithtextproperty(string2);
                    int n = 1;
                    object = null;
                    bl = false;
                    while (n <= data.omessages.getCount()) {
                        object = (message)data.omessages.get(n);
                        if (((message)object).ID == ((message)object2).ID) {
                            ((message)object).Text = ((message)object2).Text;
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        data.omessages.add(object2);
                    }
                }
                ++this.ci;
            }
            int n = 1;
            object2 = null;
            while (n <= data.olocations.getCount()) {
                object2 = (location)data.olocations.get(n);
                try {
                    this.translatecode(((location)object2).OnInput, "location(" + ((location)object2).ID + ")", ((location)object2).CodeName);
                }
                catch (Exception exception) {
                    vdu.println("Error in " + ((location)object2).CodeName + ".OnInput");
                    throw new Exception(exception.getMessage());
                }
                try {
                    this.translatecode(((location)object2).OnDisplay, "location(" + ((location)object2).ID + ")", ((location)object2).CodeName);
                }
                catch (Exception exception) {
                    vdu.println("Error resolving objects in " + ((location)object2).CodeName + ".OnDisplay");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            n = 1;
            item item2 = null;
            while (n <= data.oitems.getCount()) {
                item2 = (item)data.oitems.get(n);
                try {
                    this.translatecode(item2.OnAction, "item(" + item2.ID + ")", item2.CodeName);
                }
                catch (Exception exception) {
                    vdu.println("Error resolving objects in " + item2.CodeName + ".OnAction");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            n = 1;
            object = null;
            while (n <= data.ocharacters.getCount()) {
                object = (character)data.ocharacters.get(n);
                try {
                    this.translatecode(((character)object).OnAction, "character(" + ((character)object).ID + ")", ((character)object).CodeName);
                }
                catch (Exception exception) {
                    vdu.println("Error resolving objects in " + ((character)object).CodeName + ".OnAction");
                    throw new Exception(exception.getMessage());
                }
                try {
                    this.translatecode(((character)object).OnTalk, "character(" + ((character)object).ID + ")", ((character)object).CodeName);
                }
                catch (Exception exception) {
                    vdu.println("Error resolving objects in " + ((character)object).CodeName + ".OnTalk");
                    throw new Exception(exception.getMessage());
                }
                try {
                    this.translatecode(((character)object).OnTimer, "character(" + ((character)object).ID + ")", ((character)object).CodeName);
                }
                catch (Exception exception) {
                    vdu.println("Error resolving objects in " + ((character)object).CodeName + ".OnTimer");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            n = 1;
            codemodule codemodule2 = null;
            while (n <= data.omodules.getCount()) {
                codemodule2 = (codemodule)data.omodules.get(n);
                try {
                    this.translatecode(codemodule2.Code, "Module(" + codemodule2.Name + ")", codemodule2.Name);
                }
                catch (Exception exception) {
                    vdu.println("Error resolving objects in module " + codemodule2.Name + ".Code");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            try {
                this.translatecode(data.ogame.OnInitialise, "game", "Game.OnInitialise");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.OnInitialise");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.ogame.OnStart, "game", "Game.OnStart");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.OnStart");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.ogame.OnQuit, "game", "Game.OnQuit");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.OnQuit");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.ogame.OnAfterInputImmediate, "game", "Game.OnAfterInputImmediate");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.OnAfterInputImmediate");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.ogame.OnScore, "game", "Game.OnScore");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.OnScore");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.ogame.OnDisplayBanner, "game", "Game.OnDisplayBanner");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.OnDisplayBanner");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.orunafterinput.code, "game", "Game.AfterInput");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.AfterInput");
                throw new Exception(exception.getMessage());
            }
            try {
                this.translatecode(data.orunafterinput.code, "game", "Game.BeforeInput");
            }
            catch (Exception exception) {
                vdu.println("Error resolving objects in Game.BeforeInput");
                throw new Exception(exception.getMessage());
            }
            syntaxchecker syntaxchecker2 = new syntaxchecker();
            n = 1;
            while (n <= data.olocations.getCount()) {
                object2 = (location)data.olocations.get(n);
                try {
                    syntaxchecker2.docheck(((location)object2).OnInput);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in " + ((location)object2).CodeName + ".OnInput");
                    throw new Exception(exception.getMessage());
                }
                try {
                    syntaxchecker2.docheck(((location)object2).OnDisplay);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in " + ((location)object2).CodeName + ".OnDisplay");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            n = 1;
            while (n <= data.oitems.getCount()) {
                item2 = (item)data.oitems.get(n);
                try {
                    syntaxchecker2.docheck(item2.OnAction);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in " + item2.CodeName + ".OnAction");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            n = 1;
            while (n <= data.ocharacters.getCount()) {
                object = (character)data.ocharacters.get(n);
                try {
                    syntaxchecker2.docheck(((character)object).OnAction);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in " + ((character)object).CodeName + ".OnAction");
                    throw new Exception(exception.getMessage());
                }
                try {
                    syntaxchecker2.docheck(((character)object).OnTalk);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in " + ((character)object).CodeName + ".OnTalk");
                    throw new Exception(exception.getMessage());
                }
                try {
                    syntaxchecker2.docheck(((character)object).OnTimer);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in " + ((character)object).CodeName + ".OnTimer");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            n = 1;
            while (n <= data.omodules.getCount()) {
                codemodule2 = (codemodule)data.omodules.get(n);
                try {
                    syntaxchecker2.docheck(codemodule2.Code);
                }
                catch (Exception exception) {
                    vdu.println("Syntax error in module " + codemodule2.Name + ".Code");
                    throw new Exception(exception.getMessage());
                }
                ++n;
            }
            try {
                syntaxchecker2.docheck(data.ogame.OnInitialise);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.OnInitialise");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.ogame.OnStart);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.OnStart");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.ogame.OnQuit);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.OnQuit");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.ogame.OnAfterInputImmediate);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.OnAfterInputImmediate");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.ogame.OnScore);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.OnScore");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.ogame.OnDisplayBanner);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.OnDisplayBanner");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.orunafterinput.code);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.AfterInput");
                throw new Exception(exception.getMessage());
            }
            try {
                syntaxchecker2.docheck(data.orunafterinput.code);
            }
            catch (Exception exception) {
                vdu.println("Syntax error in Game.BeforeInput");
                throw new Exception(exception.getMessage());
            }
            if (!this.islibrary) {
                vdu.println("Process completed.");
                return;
            }
        }
        catch (Exception exception) {
            vdu.println(exception.getMessage());
            exception.printStackTrace();
            throw new Exception("Errors occurred.");
        }
    }

    private void storeitem() throws Exception {
        String string = "";
        String string2 = "";
        string = this.tf.get(this.ci);
        iagecode iagecode2 = this.splitstring(string, " ");
        int n = 2;
        string2 = iagecode2.get(n);
        item item2 = new item();
        item2.ID = data.oitems.getCount() + 1;
        item2.CodeName = string2;
        item2.Name = this.getwithtextproperty(string);
        ++this.ci;
        string = this.tf.get(this.ci);
        string = string.trim();
        while (!string.startsWith("}") && this.ci <= this.tf.getCount()) {
            if (this.checkstart(string, "nouns")) {
                this.createnouns(1000L + item2.ID, string);
                item2.NounID = 1000L + item2.ID;
            }
            if (this.checkstart(string, "description")) {
                item2.DefaultExamine = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "initial")) {
                item2.Description = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "startsin")) {
                item2.CurrentLocation = this.getlocationbyname(this.getwithproperty(string));
            }
            if (this.checkstart(string, "readabletext")) {
                item2.ReadableText = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "staticmessage")) {
                item2.FixedMessage = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "subitemof")) {
                item2.SubItemOf = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "size")) {
                item2.Size = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "weight")) {
                item2.Weight = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "HasUDB")) {
                item2.UserBooleans = string;
            }
            if (this.checkstart(string, "damageindicator")) {
                item2.DamageIndicator = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "has")) {
                if ((string = String.valueOf(string) + " ").indexOf("lightsource") != -1) {
                    item2.IsLightSource = true;
                }
                if (string.indexOf("light ") != -1) {
                    item2.IsLit = true;
                }
                if (string.indexOf("worn") != -1) {
                    item2.IsWorn = true;
                }
                if (string.indexOf("wearable") != -1) {
                    item2.IsWearable = true;
                }
                if (string.indexOf("weapon") != -1) {
                    item2.IsWeapon = true;
                }
                if (string.indexOf("transparent") != -1) {
                    item2.Transparent = true;
                }
                if (string.indexOf("supporter") != -1) {
                    item2.HasSurface = true;
                }
                if (string.indexOf("lay") != -1) {
                    item2.CanBeLaidOn = true;
                }
                if (string.indexOf("sit") != -1) {
                    item2.CanBeSatOn = true;
                }
                if (string.indexOf("stand") != -1) {
                    item2.CanBeStoodOn = true;
                }
                if (string.indexOf("enterable") != -1) {
                    item2.CanBeGotIn = true;
                }
                if (string.indexOf("container") != -1) {
                    item2.IsContainer = true;
                }
                if (string.indexOf("edible") != -1) {
                    item2.IsEdible = true;
                }
                if (string.indexOf("readable") != -1) {
                    item2.IsReadable = true;
                }
                if (string.indexOf("static") != -1) {
                    item2.IsFixed = true;
                }
                if (string.indexOf("openable") != -1) {
                    item2.CanOpenClose = true;
                }
                if (string.indexOf("open ") != -1) {
                    item2.OpenCloseState = true;
                }
                if (string.indexOf("invisible ") != -1) {
                    item2.Invisible = true;
                }
                if (string.indexOf("scenery ") != -1) {
                    item2.Invisible = true;
                }
                if (string.indexOf("subitem") != -1) {
                    item2.IsSubItem = true;
                }
            }
            if (this.checkstart(string, "OnAction:")) {
                item2.OnAction = this.loadcode(item2.OnAction);
            }
            ++this.ci;
            string = this.tf.get(this.ci);
            string = string.trim();
        }
        if (item2.NounID == 0L) {
            item2.NounID = -1L;
        }
        data.oitems.add(item2);
    }

    private void storenpc() throws Exception {
        String string = "";
        String string2 = "";
        string = this.tf.get(this.ci);
        iagecode iagecode2 = this.splitstring(string, " ");
        int n = 2;
        string2 = iagecode2.get(n);
        character character2 = new character();
        character2.ID = data.ocharacters.getCount() + 1;
        character2.CodeName = string2;
        character2.Name = this.getwithtextproperty(string);
        ++this.ci;
        string = this.tf.get(this.ci);
        string = string.trim();
        while (!string.startsWith("}") && this.ci <= this.tf.getCount()) {
            if (this.checkstart(string, "nouns")) {
                this.createnouns(100000L + character2.ID, string);
                character2.NounID = 100000L + character2.ID;
            }
            if (this.checkstart(string, "description")) {
                character2.DefaultExamine = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "initial")) {
                character2.Description = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "startsin")) {
                character2.CurrentLocation = this.getlocationbyname(this.getwithproperty(string));
            }
            if (this.checkstart(string, "timerinterval")) {
                character2.TimerInterval = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "hitpoints")) {
                character2.HitPoints = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "damageindicator")) {
                character2.DamageIndicator = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "money")) {
                character2.Money = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "has")) {
                if ((string = String.valueOf(string) + " ").indexOf("autoattack") != -1) {
                    character2.AutoAttack = true;
                }
                if (string.indexOf("attackwhenattacked") != -1) {
                    character2.AttackWhenAttacked = true;
                }
            }
            if (this.checkstart(string, "OnAction:")) {
                character2.OnAction = this.loadcode(character2.OnAction);
            }
            if (this.checkstart(string, "OnTalk:")) {
                character2.OnTalk = this.loadcode(character2.OnTalk);
            }
            if (this.checkstart(string, "OnTimer:")) {
                character2.OnTimer = this.loadcode(character2.OnTimer);
            }
            ++this.ci;
            string = this.tf.get(this.ci);
            string = string.trim();
        }
        data.ocharacters.add(character2);
    }

    private void storemodule() throws Exception {
        String string = "";
        String string2 = "";
        string = this.tf.get(this.ci);
        iagecode iagecode2 = this.splitstring(string, " ");
        int n = 2;
        string2 = iagecode2.get(n);
        codemodule codemodule2 = new codemodule();
        codemodule2.ID = data.omodules.getCount() + 1;
        codemodule2.Name = string2;
        ++this.ci;
        string = this.tf.get(this.ci);
        while (!string.trim().startsWith("}") && this.ci <= this.tf.getCount()) {
            codemodule2.Code.add(string);
            ++this.ci;
            string = this.tf.get(this.ci);
        }
        data.omodules.add(codemodule2);
    }

    private void storelocation() throws Exception {
        String string = "";
        String string2 = "";
        item item2 = null;
        string = this.tf.get(this.ci);
        iagecode iagecode2 = this.splitstring(string, " ");
        int n = 2;
        string2 = iagecode2.get(n);
        location location2 = new location();
        location2.ID = data.olocations.getCount() + 1;
        location2.CodeName = string2;
        location2.Name = this.getwithtextproperty(string);
        ++this.ci;
        string = this.tf.get(this.ci);
        string = string.trim();
        while (!string.startsWith("}") && this.ci <= this.tf.getCount()) {
            if (this.checkstart(string, "nouns")) {
                item2 = new item();
                item2.ID = data.oitems.getCount() + 1;
                item2.Name = location2.Name;
                item2.Invisible = true;
                item2.NounID = 1000L + item2.ID;
                item2.CurrentLocation = location2.ID;
                item2.DefaultExamine = "[ That is just scenery and does not need to be referred to during this game. ]";
                data.oitems.add(item2);
                this.createnouns(1000L + item2.ID, string);
            }
            if (this.checkstart(string, "description")) {
                location2.Description = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "imagepath")) {
                location2.ImagePath = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "examine")) {
                if (item2 == null) {
                    this.errormsg = "Examine statement found without noun list at line: " + Integer.toString(this.ci);
                    this.errorflag = true;
                    return;
                }
                item2.DefaultExamine = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "n_to")) {
                location2.N_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "s_to")) {
                location2.S_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "e_to")) {
                location2.E_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "w_to")) {
                location2.W_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "u_to")) {
                location2.U_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "d_to")) {
                location2.D_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "ne_to")) {
                location2.NE_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "nw_to")) {
                location2.NW_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "se_to")) {
                location2.SE_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "sw_to")) {
                location2.SW_to = this.getwithproperty(string);
            }
            if (this.checkstart(string, "has")) {
                if ((string = String.valueOf(string) + " ").indexOf("light") != -1) {
                    location2.IsDark = false;
                }
                if (string.indexOf("darkness") != -1) {
                    location2.IsDark = true;
                }
            }
            if (this.checkstart(string, "OnDisplay:")) {
                location2.OnDisplay = this.loadcode(location2.OnDisplay);
            }
            if (this.checkstart(string, "OnInput:")) {
                location2.OnInput = this.loadcode(location2.OnInput);
            }
            ++this.ci;
            string = this.tf.get(this.ci);
            string = string.trim();
        }
        data.olocations.add(location2);
    }

    private void storegame() throws Exception {
        ++this.ci;
        String string = this.tf.get(this.ci);
        string = string.trim();
        while (!string.startsWith("}") && this.ci <= this.tf.getCount()) {
            if (this.checkstart(string, "name")) {
                data.ogame.Name = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "maxitemscancarry")) {
                data.ogame.MaxItemsCanCarry = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "maxweightcancarry")) {
                data.ogame.MaxWeightCanCarry = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "maxsizecancarry")) {
                data.ogame.MaxSizeCanCarry = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "startinglocation")) {
                data.ogame.StartingLocation = this.getlocationbyname(this.getwithproperty(string));
            }
            if (this.checkstart(string, "verbose")) {
                data.ogame.RepeatDescription = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "showavailableexits")) {
                data.ogame.ShowAvailableExits = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "allowpersist")) {
                data.ogame.AllowPersist = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "singleplayergame")) {
                data.ogame.SinglePlayerGame = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "maxusers")) {
                data.ogame.MaxUsers = Integer.parseInt(this.getwithproperty(string));
            }
            if (this.checkstart(string, "realtimenpcs")) {
                data.ogame.RealTimeNPCs = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "idepassword")) {
                data.ogame.IDEPassword = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "usingiagecombat")) {
                data.ogame.UsingIAGECombat = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "usingiagemoney")) {
                data.ogame.UsingIAGEMoney = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "wideinventorydisplay")) {
                data.ogame.WideDisplay = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "defaulthitpoints")) {
                data.ogame.DefaultHitPoints = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "defaultdamage")) {
                data.ogame.DefaultDamage = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "defaultmoney")) {
                data.ogame.DefaultMoney = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "defaultchanceofhitting")) {
                data.ogame.DefaultChanceOfHitting = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "chanceofhittingincrementforkill")) {
                data.ogame.ChanceOfHittingIncrementForKill = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "damageindicatorincrementforkill")) {
                data.ogame.DamageIndicatorIncrementForKill = Long.parseLong(this.getwithproperty(string));
            }
            if (this.checkstart(string, "mediabase")) {
                data.ogame.MediaBase = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "overridesecondarynouns")) {
                data.ogame.OverrideSecondaryNouns = this.getwithtextproperty(string);
            }
            if (this.checkstart(string, "playersstaydead")) {
                data.ogame.PlayersStayDead = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "npcsstaydead")) {
                data.ogame.NPCsStayDead = this.getwithproperty(string).equalsIgnoreCase("yes");
            }
            if (this.checkstart(string, "initialise:")) {
                data.ogame.OnInitialise = this.loadcode(data.ogame.OnInitialise);
            }
            if (this.checkstart(string, "afterinputimmediate:")) {
                data.ogame.OnAfterInputImmediate = this.loadcode(data.ogame.OnAfterInputImmediate);
            }
            if (this.checkstart(string, "quit:")) {
                data.ogame.OnQuit = this.loadcode(data.ogame.OnQuit);
            }
            if (this.checkstart(string, "start:")) {
                data.ogame.OnStart = this.loadcode(data.ogame.OnStart);
            }
            if (this.checkstart(string, "displaybanner:")) {
                data.ogame.OnDisplayBanner = this.loadcode(data.ogame.OnDisplayBanner);
            }
            if (this.checkstart(string, "score:")) {
                data.ogame.OnScore = this.loadcode(data.ogame.OnScore);
            }
            if (this.checkstart(string, "afterinput:")) {
                data.orunafterinput.code = this.loadcode(data.orunafterinput.code);
            }
            if (this.checkstart(string, "beforeinput:")) {
                data.orunbeforeinput.code = this.loadcode(data.orunbeforeinput.code);
            }
            ++this.ci;
            string = this.tf.get(this.ci);
            string = string.trim();
        }
    }

    private void resolvelocation() throws Exception {
        int n = 1;
        location location2 = null;
        while (n <= data.olocations.getCount()) {
            location2 = (location)data.olocations.get(n);
            try {
                if (location2.N_to != "") {
                    location2.N = this.getlocationbyname(location2.N_to);
                }
                if (location2.S_to != "") {
                    location2.S = this.getlocationbyname(location2.S_to);
                }
                if (location2.E_to != "") {
                    location2.E = this.getlocationbyname(location2.E_to);
                }
                if (location2.W_to != "") {
                    location2.W = this.getlocationbyname(location2.W_to);
                }
                if (location2.U_to != "") {
                    location2.U = this.getlocationbyname(location2.U_to);
                }
                if (location2.D_to != "") {
                    location2.D = this.getlocationbyname(location2.D_to);
                }
                if (location2.NE_to != "") {
                    location2.NE = this.getlocationbyname(location2.NE_to);
                }
                if (location2.NW_to != "") {
                    location2.NW = this.getlocationbyname(location2.NW_to);
                }
                if (location2.SE_to != "") {
                    location2.SE = this.getlocationbyname(location2.SE_to);
                }
                if (location2.SW_to != "") {
                    location2.SW = this.getlocationbyname(location2.SW_to);
                }
            }
            catch (Exception exception) {
                vdu.println("Error occurred resolving locations for map in location '" + location2.CodeName + "' (" + exception.getMessage() + ")");
            }
            ++n;
        }
    }

    private long getlocationbyname(String string) throws Exception {
        int n = 1;
        location location2 = null;
        while (n <= data.olocations.getCount()) {
            location2 = (location)data.olocations.get(n);
            if (location2.CodeName.equalsIgnoreCase(string)) {
                return location2.ID;
            }
            ++n;
        }
        if (string.equalsIgnoreCase("limbo")) {
            return 0L;
        }
        if (string.equalsIgnoreCase("random")) {
            return -1L;
        }
        n = 1;
        item item2 = null;
        while (n <= data.oitems.getCount()) {
            item2 = (item)data.oitems.get(n);
            if (item2.CodeName.equalsIgnoreCase(string)) {
                if (item2.HasSurface) {
                    return item2.ID + location.SURFACEBASE;
                }
                return item2.ID + location.CONTAINERBASE;
            }
            ++n;
        }
        n = 1;
        character character2 = null;
        while (n <= data.ocharacters.getCount()) {
            character2 = (character)data.ocharacters.get(n);
            if (character2.CodeName.equalsIgnoreCase(string)) {
                return character2.ID + location.NPCBASE;
            }
            ++n;
        }
        throw new Exception("Unable to resolve location named '" + string + "'");
    }

    private iagecode splitstring(String string, String string2) {
        int n = 0;
        int n2 = 0;
        iagecode iagecode2 = new iagecode();
        n = string.indexOf(string2);
        while (n != -1) {
            iagecode2.add(string.substring(n2, n));
            n2 = n + 1;
            n = string.indexOf(string2, n2);
        }
        iagecode2.add(string.substring(n2, string.length()));
        return iagecode2;
    }

    private boolean checkstart(String string, String string2) {
        return string.toLowerCase().startsWith(string2.toLowerCase());
    }

    private String getwithproperty(String string) throws Exception {
        String string2 = string.trim();
        int n = 0;
        while (n <= string2.length() - 1) {
            if (string2.substring(n, n + 1).equals(" ") || string2.substring(n, n + 1).equals("\t")) break;
            ++n;
        }
        if (n == string2.length() - 1) {
            throw new Exception("Bad WITH statement at line: " + Integer.toString(this.ci));
        }
        String string3 = string2.substring(n, string2.length());
        string3 = string3.trim();
        n = 0;
        while (n <= string3.length() - 1) {
            if (string3.substring(n, n + 1).equals(" ") || string3.substring(n, n + 1).equals("\t")) break;
            ++n;
        }
        if (n == string3.length() - 1) {
            n = string3.length();
        }
        return string3.substring(0, n);
    }

    private String getwithtextproperty(String string) throws Exception {
        int n = string.indexOf("\"");
        int n2 = string.indexOf("\"", n + 1);
        String string2 = "";
        if (n != -1 && n2 == -1) {
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            ++this.ci;
            string = this.tf.get(this.ci);
            n = string.indexOf("\"");
            while (n == -1) {
                string2 = String.valueOf(string2) + " " + string.trim();
                ++this.ci;
                string = this.tf.get(this.ci);
                n = string.indexOf("\"");
            }
            if ((string2 = String.valueOf(string2) + " " + string.trim()).endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return vdu.replace(string2, "~", "\"");
        }
        if (n > n2 || n == -1 || n2 == -1) {
            throw new Exception("Bad WITH text property at line: " + Integer.toString(this.ci));
        }
        String string3 = string.substring(n + 1, n2);
        return vdu.replace(string3, "~", "\"");
    }

    private void createnouns(long l, String string) throws Exception {
        iagecode iagecode2 = this.splitstring(string, " ");
        if (iagecode2.getCount() < 2) {
            throw new Exception("Noun list started but no list given at line: " + Integer.toString(this.ci));
        }
        int n = 2;
        while (n <= iagecode2.getCount()) {
            noun noun2 = new noun();
            noun2.ID = l;
            noun2.Text = iagecode2.get(n).replace('\"', ' ').trim();
            if (noun2.Text.trim().equals("")) {
                throw new Exception("Too many spaces in noun list - blank nouns not allowed at line: " + Integer.toString(this.ci));
            }
            data.onouns.add(noun2);
            ++n;
        }
    }

    private iagecode loadcode(iagecode iagecode2) {
        boolean bl;
        String string = this.tf.get(this.ci).toLowerCase();
        boolean bl2 = bl = string.indexOf("override") > -1;
        if (bl) {
            iagecode2 = new iagecode();
        }
        ++this.ci;
        String string2 = this.tf.get(this.ci);
        while (!string2.trim().equals("]")) {
            iagecode2.add(string2);
            ++this.ci;
            string2 = this.tf.get(this.ci);
        }
        return iagecode2;
    }

    private void translatecode(iagecode iagecode2, String string, String string2) throws Exception {
        new iagecode();
        int n = 1;
        String string3 = "";
        try {
            while (n <= iagecode2.getCount()) {
                string3 = iagecode2.get(n);
                string3 = this.codereplace(string3, "this.", String.valueOf(string) + ".");
                location location2 = null;
                int n2 = 1;
                while (n2 <= data.olocations.getCount()) {
                    location2 = (location)data.olocations.get(n2);
                    if (!location2.CodeName.equals("")) {
                        string3 = this.codereplace(string3, String.valueOf(location2.CodeName) + ".", "location(" + location2.ID + ").");
                    }
                    ++n2;
                }
                item item2 = null;
                n2 = 1;
                while (n2 <= data.oitems.getCount()) {
                    item2 = (item)data.oitems.get(n2);
                    if (!item2.CodeName.equals("")) {
                        string3 = this.codereplace(string3, String.valueOf(item2.CodeName) + ".", "item(" + item2.ID + ").");
                    }
                    ++n2;
                }
                character character2 = null;
                n2 = 1;
                while (n2 <= data.ocharacters.getCount()) {
                    character2 = (character)data.ocharacters.get(n2);
                    if (!character2.CodeName.equals("")) {
                        string3 = this.codereplace(string3, String.valueOf(character2.CodeName) + ".", "character(" + character2.ID + ").");
                    }
                    ++n2;
                }
                string3 = this.findandfillspacesbetween(string3, "\"", ' ', '^');
                string3 = vdu.replace(string3, "~", "\"");
                string3 = this.findandfillspacesbetween(string3, "|", ' ', '_');
                iagecode2.set(n, string3);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            vdu.println(exception.getMessage());
            vdu.println("Error occurred in " + string + "codename '" + string2 + "' at line " + Integer.toString(n));
            return;
        }
    }

    private String codereplace(String string, String string2, String string3) {
        String string4 = new String(string);
        string4 = this.crep(string4, " " + string2, " " + string3);
        string4 = this.crep(string4, "\t" + string2, "\t" + string3);
        string4 = this.crep(string4, "|" + string2, "|" + string3);
        string4 = this.crep(string4, "(" + string2, "(" + string3);
        return string4;
    }

    private String crep(String string, String string2, String string3) {
        int n = 0;
        String string4 = new String(string);
        while (n <= string4.length() - string2.length()) {
            if (string4.substring(n, n + string2.length()).equalsIgnoreCase(string2) && !string4.substring(n + string2.length(), n + string2.length() + 1).equals("\"") && !string4.substring(n + string2.length(), n + string2.length() + 1).equals(" ")) {
                string4 = vdu.stringbuffreplace(new StringBuffer(string4), n, n + string2.length(), string3).toString();
            }
            ++n;
        }
        return string4.toString();
    }

    private String findandfillspacesbetween(String string, String string2, char c, char c2) throws Exception {
        int n = string.indexOf(string2);
        int n2 = 0;
        while (n != -1) {
            n2 = string.indexOf(string2, n + 1);
            if (n > n2) {
                throw new Exception("Incorrect number of " + c + " arguments.");
            }
            String string3 = string.substring(n + 1, n2);
            string3 = string3.replace(c, c2);
            string = n2 == string.length() - 1 ? String.valueOf(string.substring(0, n)) + string3 : String.valueOf(string.substring(0, n)) + string3 + string.substring(n2 + 1, string.length());
            n = string.indexOf(string2);
        }
        return string;
    }

    private void resolveextendeditem(String string) throws Exception {
        String string2 = "";
        boolean bl = false;
        iagecode iagecode2 = this.splitstring(string, " ");
        int n = 1;
        while (n <= iagecode2.getCount()) {
            if (iagecode2.get(n).equalsIgnoreCase("extends")) {
                string2 = iagecode2.get(n + 1);
                if (string2.equals("{")) {
                    throw new Exception("Extend found but no item named at line: " + Integer.toString(this.ci));
                }
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        n = 1;
        item item2 = null;
        while (n <= data.oitems.getCount()) {
            item2 = (item)data.oitems.get(n);
            if (item2.CodeName.equalsIgnoreCase(iagecode2.get(2))) break;
            ++n;
        }
        n = 1;
        item item3 = null;
        String string3 = "";
        while (n <= data.oitems.getCount()) {
            item3 = (item)data.oitems.get(n);
            if (item3.CodeName.equalsIgnoreCase(string2)) {
                int n2 = 1;
                while (n2 <= item3.OnAction.getCount()) {
                    string3 = item3.OnAction.get(n2);
                    string3 = vdu.replace(string3, "item(" + Long.toString(item3.ID) + ").", "item(" + Long.toString(item2.ID) + ").");
                    item2.OnAction.add(string3);
                    ++n2;
                }
                return;
            }
            ++n;
        }
    }

    private void importandcompile(String string) throws Exception {
        String string2 = this.getwithtextproperty(string);
        String string3 = new File(this.openfilename).getAbsolutePath();
        string3 = string3.substring(0, string3.lastIndexOf(File.separator) + 1);
        File file = new File(string3 = String.valueOf(string3) + string2);
        if (!file.exists()) {
            string3 = new File("").getAbsolutePath();
            string3 = String.valueOf(string3) + File.separator + string2;
        }
        System.out.println("Including " + string3 + "...");
        new importiage().importandcompilefromsubclass(string3);
    }
}

