/*
 * Decompiled with CFR 0.152.
 */
package iagecompiler;

import iagecompiler.adverb;
import iagecompiler.character;
import iagecompiler.codemodule;
import iagecompiler.game;
import iagecompiler.iagecode;
import iagecompiler.iagecollection;
import iagecompiler.item;
import iagecompiler.location;
import iagecompiler.mainframe;
import iagecompiler.message;
import iagecompiler.noun;
import iagecompiler.runafterinput;
import iagecompiler.runbeforeinput;
import iagecompiler.vdu;
import iagecompiler.verb;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class data {
    boolean fileeof;
    boolean isencrypted;
    public static final boolean debugging = true;
    public static mainframe theframe;
    public static int maxflags;
    public static int ipport;
    public static String defaultnewplayername;
    public static boolean canstartenginenow;
    public static int numberofconnections;
    public static int nextplayerID;
    public static iagecollection oadverbs;
    public static iagecollection overbs;
    public static iagecollection onouns;
    public static game ogame;
    public static iagecollection olocations;
    public static iagecollection ocharacters;
    public static iagecollection oitems;
    public static iagecollection omodules;
    public static runafterinput orunafterinput;
    public static runbeforeinput orunbeforeinput;
    public static iagecollection oplayers;
    public static iagecollection omessages;
    public static String openfilename;

    public data() {
        this.fileeof = false;
        this.isencrypted = false;
    }

    public data(String string) {
        block17: {
            this.fileeof = false;
            this.isencrypted = false;
            canstartenginenow = false;
            numberofconnections = 0;
            nextplayerID = 1;
            oadverbs = new iagecollection();
            overbs = new iagecollection();
            onouns = new iagecollection();
            ogame = new game();
            olocations = new iagecollection();
            ocharacters = new iagecollection();
            oitems = new iagecollection();
            omodules = new iagecollection();
            orunafterinput = new runafterinput();
            orunbeforeinput = new runbeforeinput();
            oplayers = new iagecollection();
            omessages = new iagecollection();
            this.fileeof = false;
            File file = new File(string);
            if (!file.exists()) {
                vdu.println("file - " + string + " does not exist.");
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                vdu.println(String.valueOf(file.getName()) + " opened.");
                openfilename = string;
                String string2 = this.readline(fileInputStream);
                if (string2.indexOf("IAGE 2") != -1) {
                    vdu.println("IAGE File Format 2.0 detected.");
                    string2 = this.readline(fileInputStream);
                    if (string2.indexOf("1") != -1) {
                        vdu.println("File is encrypted.");
                        this.isencrypted = true;
                    } else {
                        vdu.println("File is not encrypted.");
                        this.isencrypted = false;
                    }
                    vdu.println("Loading data, please wait...");
                    while (!this.fileeof) {
                        string2 = this.decrypt(this.readline(fileInputStream));
                        if (this.comparestring(string2, "GAME")) {
                            vdu.print("Reading game properties...");
                            this.loadgame(fileInputStream);
                        }
                        if (this.comparestring(string2, "LOCATIONS")) {
                            vdu.print("Reading locations...");
                            this.loadlocations(fileInputStream);
                        }
                        if (this.comparestring(string2, "ITEMS")) {
                            vdu.print("Reading objects...");
                            this.loaditems(fileInputStream);
                        }
                        if (this.comparestring(string2, "CHARACTERS")) {
                            vdu.print("Reading characters...");
                            this.loadcharacters(fileInputStream);
                        }
                        if (this.comparestring(string2, "MESSAGES")) {
                            vdu.print("Reading messages...");
                            this.loadmessages(fileInputStream);
                        }
                        if (this.comparestring(string2, "NOUNS")) {
                            vdu.print("Reading dictionary (nouns)...");
                            this.loadnouns(fileInputStream);
                        }
                        if (this.comparestring(string2, "ADVERBS")) {
                            vdu.print("Reading dictionary (adverbs)...");
                            this.loadadverbs(fileInputStream);
                        }
                        if (this.comparestring(string2, "VERBS")) {
                            vdu.print("Reading dictionary (verbs)...");
                            this.loadverbs(fileInputStream);
                        }
                        if (this.comparestring(string2, "MODULES")) {
                            vdu.print("Reading code modules...");
                            this.loadmodules(fileInputStream);
                        }
                        if (this.comparestring(string2, "RUNBEFOREINPUT")) {
                            vdu.print("Reading event code (1 of 2)...");
                            this.loadrunbeforeinput(fileInputStream);
                        }
                        if (!this.comparestring(string2, "RUNAFTERINPUT")) continue;
                        vdu.print("Reading event code (2 of 2)...");
                        this.loadrunafterinput(fileInputStream);
                    }
                    vdu.println("Load complete.");
                    break block17;
                }
                vdu.println(String.valueOf(string) + " has an unrecognised file format.");
                return;
            }
            catch (Exception exception) {
                vdu.println("Error occurred: " + exception.getMessage());
                exception.printStackTrace();
                return;
            }
        }
        canstartenginenow = true;
    }

    private String readline(FileInputStream fileInputStream) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = -1;
        while (true) {
            try {
                n = fileInputStream.read();
            }
            catch (Exception exception) {
                vdu.println("Error reading from file - " + exception.getMessage());
                return stringBuffer.toString();
            }
            if (n == 13) {
                try {
                    n = fileInputStream.read();
                }
                catch (Exception exception) {
                    vdu.println("Error reading from file - " + exception.getMessage());
                    return stringBuffer.toString();
                }
                return stringBuffer.toString();
            }
            if (n == -1) {
                this.fileeof = true;
                return stringBuffer.toString();
            }
            Integer n2 = new Integer(n);
            byte[] byArray = new byte[]{n2.byteValue()};
            stringBuffer.append(new String(byArray));
        }
    }

    public void writeline(FileOutputStream fileOutputStream, String string) {
        string = data.encrypt(string);
        byte[] byArray = string.getBytes();
        try {
            fileOutputStream.write(byArray);
            byte[] byArray2 = new byte[]{13, 10};
            fileOutputStream.write(byArray2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vdu.println("Error writing to file - " + exception.getMessage());
            return;
        }
    }

    public void writelineunencrypted(FileOutputStream fileOutputStream, String string) {
        byte[] byArray = string.getBytes();
        try {
            fileOutputStream.write(byArray);
            byte[] byArray2 = new byte[]{13, 10};
            fileOutputStream.write(byArray2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vdu.println("Error writing to file - " + exception.getMessage());
            return;
        }
    }

    public void writecode(FileOutputStream fileOutputStream, String string, iagecode iagecode2) {
        int n = 1;
        while (n <= iagecode2.getCount()) {
            this.writeline(fileOutputStream, String.valueOf(string) + " = " + iagecode2.get(n));
            ++n;
        }
    }

    private void loadgame(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (string.indexOf("END") == -1 && !this.fileeof) {
            if (this.comparebuff(string, "MaxItemsCanCarry")) {
                data.ogame.MaxItemsCanCarry = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "MaxWeightCanCarry")) {
                data.ogame.MaxWeightCanCarry = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "MaxSizeCanCarry")) {
                data.ogame.MaxSizeCanCarry = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "StartingLocation")) {
                data.ogame.StartingLocation = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "RepeatDescription")) {
                data.ogame.RepeatDescription = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "ShowAvailableExits")) {
                data.ogame.ShowAvailableExits = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "AllowPersist")) {
                data.ogame.AllowPersist = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "SinglePlayerGame")) {
                data.ogame.SinglePlayerGame = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "MaxUsers")) {
                data.ogame.MaxUsers = (int)this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "IDEPassword")) {
                data.ogame.IDEPassword = this.getpropvalue_string(string);
            }
            if (this.comparebuff(string, "Name")) {
                data.ogame.Name = this.getpropvalue_string(string);
            }
            if (this.comparebuff(string, "OverrideSecondaryNouns")) {
                data.ogame.OverrideSecondaryNouns = this.getpropvalue_string(string);
            }
            if (this.comparebuff(string, "MediaBase")) {
                data.ogame.MediaBase = this.getpropvalue_string(string);
            }
            if (this.comparebuff(string, "UsingIAGECombat")) {
                data.ogame.UsingIAGECombat = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "UsingIAGEMoney")) {
                data.ogame.UsingIAGEMoney = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "WideDisplay")) {
                data.ogame.WideDisplay = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "RealTimeNPCs")) {
                data.ogame.RealTimeNPCs = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "PlayersStayDead")) {
                data.ogame.PlayersStayDead = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "NPCsStayDead")) {
                data.ogame.NPCsStayDead = this.getpropvalue_boolean(string);
            }
            if (this.comparebuff(string, "DefaultHitPoints")) {
                data.ogame.DefaultHitPoints = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "DefaultDamage")) {
                data.ogame.DefaultDamage = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "DefaultMoney")) {
                data.ogame.DefaultMoney = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "DefaultChanceOfHitting")) {
                data.ogame.DefaultChanceOfHitting = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "ChanceOfHittingIncrementForKill")) {
                data.ogame.ChanceOfHittingIncrementForKill = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "DamageIndicatorIncrementForKill")) {
                data.ogame.DamageIndicatorIncrementForKill = this.getpropvalue_long(string);
            }
            if (this.comparebuff(string, "OnDisplayBanner")) {
                data.ogame.OnDisplayBanner.add(this.getuntrimmedvalue(string));
            }
            if (this.comparebuff(string, "OnAfterInputImmediate")) {
                data.ogame.OnAfterInputImmediate.add(this.getuntrimmedvalue(string));
            }
            if (this.comparebuff(string, "OnQuit")) {
                data.ogame.OnQuit.add(this.getuntrimmedvalue(string));
            }
            if (this.comparebuff(string, "OnStart")) {
                data.ogame.OnStart.add(this.getuntrimmedvalue(string));
            }
            if (this.comparebuff(string, "OnScore")) {
                data.ogame.OnScore.add(this.getuntrimmedvalue(string));
            }
            if (this.comparebuff(string, "OnInitialise")) {
                data.ogame.OnInitialise.add(this.getuntrimmedvalue(string));
            }
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK.");
    }

    private void loadlocations(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            location location2 = new location();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    location2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Name")) {
                    location2.Name = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "ImagePath")) {
                    location2.ImagePath = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "Description")) {
                    location2.Description = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "IsDark")) {
                    location2.IsDark = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "CustomProperties")) {
                    location2.CustomProperties = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "N")) {
                    location2.N = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "S")) {
                    location2.S = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "E")) {
                    location2.E = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "W")) {
                    location2.W = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "U")) {
                    location2.U = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "D")) {
                    location2.D = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "NE")) {
                    location2.NE = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "NW")) {
                    location2.NW = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "SE")) {
                    location2.SE = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "SW")) {
                    location2.SW = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "OnInput")) {
                    location2.OnInput.add(this.getuntrimmedvalue(string));
                }
                if (this.comparebuff(string, "OnDisplay")) {
                    location2.OnDisplay.add(this.getuntrimmedvalue(string));
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            olocations.add(location2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(olocations.getCount()) + " Locations).");
    }

    private void loaditems(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            item item2 = new item();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    item2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Name")) {
                    item2.Name = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "CurrentLocation")) {
                    item2.CurrentLocation = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Weight")) {
                    item2.Weight = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Description")) {
                    item2.Description = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "CustomProperties")) {
                    item2.CustomProperties = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "UserBooleans")) {
                    item2.UserBooleans = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "NounID")) {
                    item2.NounID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "IsLightSource")) {
                    item2.IsLightSource = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "IsLit")) {
                    item2.IsLit = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "IsWorn")) {
                    item2.IsWorn = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "IsWeapon")) {
                    item2.IsWeapon = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "Transparent")) {
                    item2.Transparent = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "HasSurface")) {
                    item2.HasSurface = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "CanBeLaidOn")) {
                    item2.CanBeLaidOn = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "CanBeStoodOn")) {
                    item2.CanBeStoodOn = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "CanBeSatOn")) {
                    item2.CanBeSatOn = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "CanBeGotIn")) {
                    item2.CanBeGotIn = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "DefaultExamine")) {
                    item2.DefaultExamine = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "IsContainer")) {
                    item2.IsContainer = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "IsEdible")) {
                    item2.IsEdible = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "EdibleHitPoints")) {
                    item2.EdibleHitPoints = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "IsWearable")) {
                    item2.IsWearable = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "IsReadable")) {
                    item2.IsReadable = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "ReadableText")) {
                    item2.ReadableText = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "Size")) {
                    item2.Size = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "DamageIndicator")) {
                    item2.DamageIndicator = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Invisible")) {
                    item2.Invisible = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "IsFixed")) {
                    item2.IsFixed = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "CanOpenClose")) {
                    item2.CanOpenClose = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "OpenCloseState")) {
                    item2.OpenCloseState = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "FixedMessage")) {
                    item2.FixedMessage = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "IsSubItem")) {
                    item2.IsSubItem = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "SubItemOf")) {
                    item2.SubItemOf = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "OnAction")) {
                    item2.OnAction.add(this.getuntrimmedvalue(string));
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            oitems.add(item2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(oitems.getCount()) + " Objects).");
    }

    private void loadcharacters(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            character character2 = new character();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    character2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Name")) {
                    character2.Name = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "CurrentLocation")) {
                    character2.CurrentLocation = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Description")) {
                    character2.Description = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "CustomProperties")) {
                    character2.CustomProperties = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "NounID")) {
                    character2.NounID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "TimerInterval")) {
                    character2.TimerInterval = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "DefaultExamine")) {
                    character2.DefaultExamine = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "HitPoints")) {
                    character2.HitPoints = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "DamageIndicator")) {
                    character2.DamageIndicator = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "AutoAttack")) {
                    character2.AutoAttack = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "AttackWhenAttacked")) {
                    character2.AttackWhenAttacked = this.getpropvalue_boolean(string);
                }
                if (this.comparebuff(string, "Money")) {
                    character2.Money = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "OnTimer")) {
                    character2.OnTimer.add(this.getuntrimmedvalue(string));
                }
                if (this.comparebuff(string, "OnTalk")) {
                    character2.OnTalk.add(this.getuntrimmedvalue(string));
                }
                if (this.comparebuff(string, "OnAction")) {
                    character2.OnAction.add(this.getuntrimmedvalue(string));
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            ocharacters.add(character2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(ocharacters.getCount()) + " NPCs).");
    }

    private void loadverbs(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            verb verb2 = new verb();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    verb2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Text")) {
                    verb2.Text = this.getpropvalue_string(string);
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            overbs.add(verb2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(overbs.getCount()) + " Verbs).");
    }

    private void loadmodules(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            codemodule codemodule2 = new codemodule();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    codemodule2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "N")) {
                    codemodule2.Name = this.getpropvalue_string(string);
                }
                if (this.comparebuff(string, "C")) {
                    codemodule2.Code.add(this.getpropvalue_string(string));
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            omodules.add(codemodule2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(omodules.getCount()) + " Code modules).");
    }

    private void loadadverbs(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            adverb adverb2 = new adverb();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    adverb2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Text")) {
                    adverb2.Text = this.getpropvalue_string(string);
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            oadverbs.add(adverb2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(oadverbs.getCount()) + " Adverbs).");
    }

    private void loadnouns(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            noun noun2 = new noun();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    noun2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Text")) {
                    noun2.Text = this.getpropvalue_string(string);
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            onouns.add(noun2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(onouns.getCount()) + " Nouns).");
    }

    private void loadrunbeforeinput(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "$END$") && !this.fileeof) {
            data.orunbeforeinput.code.add(string);
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(data.orunbeforeinput.code.getCount()) + " lines).");
    }

    private void loadrunafterinput(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "$END$") && !this.fileeof) {
            data.orunafterinput.code.add(string);
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(data.orunafterinput.code.getCount()) + " lines).");
    }

    private void loadmessages(FileInputStream fileInputStream) {
        String string = this.decrypt(this.readline(fileInputStream));
        while (!this.comparestring(string, "END") && !this.fileeof) {
            message message2 = new message();
            while (!(this.comparestring(string, "BREAK") || this.fileeof || this.comparestring(string, "END"))) {
                if (this.comparebuff(string, "ID")) {
                    message2.ID = this.getpropvalue_long(string);
                }
                if (this.comparebuff(string, "Text")) {
                    message2.Text = this.getpropvalue_string(string);
                }
                string = this.decrypt(this.readline(fileInputStream));
            }
            omessages.add(message2);
            if (this.comparestring(string, "END")) continue;
            string = this.decrypt(this.readline(fileInputStream));
        }
        vdu.println("OK (" + Integer.toString(omessages.getCount()) + " Messages).");
    }

    private long getpropvalue_long(String string) {
        String string2 = this.getvalue(string);
        return Long.parseLong(string2);
    }

    private String getpropvalue_string(String string) {
        return this.getvalue(string);
    }

    private boolean getpropvalue_boolean(String string) {
        String string2 = this.getvalue(string);
        return string2.equals("true") || string2.equals("True");
    }

    private String getvalue(String string) {
        String string2 = string.substring(string.indexOf("=") + 1, string.length());
        if (string2.startsWith(" ") && string2.length() == 1) {
            return "";
        }
        string2 = data.removeleadingspaces(string2);
        string2 = data.removetrailingspaces(string2);
        return string2;
    }

    private String getuntrimmedvalue(String string) {
        String string2 = string.substring(string.indexOf("=") + 1, string.length());
        if (string2.startsWith(" ") && string2.length() == 1) {
            return "";
        }
        return string2;
    }

    private boolean comparebuff(String string, String string2) {
        if (string.indexOf("=") == -1) {
            return false;
        }
        String string3 = string.substring(0, string.indexOf("=") - 1);
        string3 = data.removeleadingspaces(string3);
        return (string3 = data.removetrailingspaces(string3)).equals(string2);
    }

    private boolean comparestring(String string, String string2) {
        string = data.removeleadingspaces(string);
        return (string = data.removetrailingspaces(string)).equals(string2);
    }

    public static String removeleadingspaces(String string) {
        while (string.startsWith(" ")) {
            if (string.length() <= 0) continue;
            string = string.substring(1, string.length());
        }
        return string;
    }

    public static String removetrailingspaces(String string) {
        while (string.endsWith(" ")) {
            if (string.length() <= 0) continue;
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String trimstring(String string) {
        string = data.removeleadingspaces(string);
        string = data.removetrailingspaces(string);
        return string;
    }

    private String decrypt(String string) {
        if (!this.isencrypted) {
            return string;
        }
        String string2 = "0123456789ABCDEF";
        byte[] byArray = new byte[8192];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n4 = 0;
        while (n4 < string.length()) {
            string3 = string.substring(n4, n4 + 1);
            n2 = string2.indexOf(string3) * 16;
            string4 = string.substring(++n4, n4 + 1);
            n3 = string2.indexOf(string4);
            byArray[n] = Byte.parseByte(Integer.toString(n2 + n3));
            ++n;
            ++n4;
        }
        string5 = new String(byArray);
        string5 = string5.substring(0, n);
        return string5;
    }

    public static String encrypthex(String string) {
        String string2 = "0123456789ABCDEF";
        byte[] byArray = string.getBytes();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n3 = 0;
        while (n3 < byArray.length) {
            d = byArray[n3];
            d2 = d / 16.0;
            int n4 = (int)d2;
            d2 = n4;
            d3 = d - d2 * 16.0;
            string3 = Double.toString(d2);
            string4 = Double.toString(d3);
            if (string3.endsWith(".0")) {
                string3 = string3.substring(0, string3.length() - 2);
            }
            if (string4.endsWith(".0")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
            string6 = string2.substring(n, n + 1);
            string6 = String.valueOf(string6) + string2.substring(n2, n2 + 1);
            string5 = String.valueOf(string5) + string6;
            ++n3;
        }
        return string5;
    }

    public static String encrypt(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length];
        String string2 = "";
        int n = 0;
        while (n < byArray.length) {
            byArray2[n] = byArray[n];
            byArray2[n] = (byte)(byArray2[n] + 2);
            ++n;
        }
        string2 = new String(byArray2);
        return string2;
    }

    public static String booleanToString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public void SaveData(boolean bl) {
        int n = 1;
        location location2 = null;
        item item2 = null;
        character character2 = null;
        verb verb2 = null;
        noun noun2 = null;
        adverb adverb2 = null;
        message message2 = null;
        codemodule codemodule2 = null;
        this.isencrypted = bl;
        try {
            File file = new File(openfilename);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            vdu.println("Saving " + file.getName());
            vdu.print("Writing header...");
            this.writelineunencrypted(fileOutputStream, "IAGE 2");
            if (bl) {
                this.writelineunencrypted(fileOutputStream, "2");
            } else {
                this.writelineunencrypted(fileOutputStream, "0");
            }
            byte[] byArray = new byte[1];
            this.writeline(fileOutputStream, new String(byArray));
            vdu.println("OK");
            vdu.print("Writing game properties...");
            this.writeline(fileOutputStream, "GAME");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "MaxItemsCanCarry = " + Long.toString(data.ogame.MaxItemsCanCarry));
            this.writeline(fileOutputStream, "MaxWeightCanCarry = " + Long.toString(data.ogame.MaxWeightCanCarry));
            this.writeline(fileOutputStream, "MaxSizeCanCarry = " + Long.toString(data.ogame.MaxSizeCanCarry));
            this.writeline(fileOutputStream, "StartingLocation = " + Long.toString(data.ogame.StartingLocation));
            this.writeline(fileOutputStream, "RepeatDescription = " + data.booleanToString(data.ogame.RepeatDescription));
            this.writeline(fileOutputStream, "ShowAvailableExits = " + data.booleanToString(data.ogame.ShowAvailableExits));
            this.writeline(fileOutputStream, "AllowPersist = " + data.booleanToString(data.ogame.AllowPersist));
            this.writeline(fileOutputStream, "SinglePlayerGame = " + data.booleanToString(data.ogame.SinglePlayerGame));
            this.writeline(fileOutputStream, "MaxUsers = " + Integer.toString(data.ogame.MaxUsers));
            this.writeline(fileOutputStream, "IDEPassword = " + data.ogame.IDEPassword);
            this.writeline(fileOutputStream, "Name = " + data.ogame.Name);
            this.writeline(fileOutputStream, "OverrideSecondaryNouns = " + data.ogame.OverrideSecondaryNouns);
            this.writeline(fileOutputStream, "MediaBase = " + data.ogame.MediaBase);
            this.writeline(fileOutputStream, "UsingIAGECombat = " + data.booleanToString(data.ogame.UsingIAGECombat));
            this.writeline(fileOutputStream, "UsingIAGEMoney = " + data.booleanToString(data.ogame.UsingIAGEMoney));
            this.writeline(fileOutputStream, "WideDisplay = " + data.booleanToString(data.ogame.WideDisplay));
            this.writeline(fileOutputStream, "RealTimeNPCs = " + data.booleanToString(data.ogame.RealTimeNPCs));
            this.writeline(fileOutputStream, "PlayersStayDead = " + data.booleanToString(data.ogame.PlayersStayDead));
            this.writeline(fileOutputStream, "NPCsStayDead = " + data.booleanToString(data.ogame.NPCsStayDead));
            this.writeline(fileOutputStream, "DefaultHitPoints = " + Long.toString(data.ogame.DefaultHitPoints));
            this.writeline(fileOutputStream, "DefaultDamage = " + Long.toString(data.ogame.DefaultDamage));
            this.writeline(fileOutputStream, "DefaultMoney = " + Long.toString(data.ogame.DefaultMoney));
            this.writeline(fileOutputStream, "DefaultChanceOfHitting = " + Long.toString(data.ogame.DefaultChanceOfHitting));
            this.writeline(fileOutputStream, "ChanceOfHittingIncrementForKill = " + Long.toString(data.ogame.ChanceOfHittingIncrementForKill));
            this.writeline(fileOutputStream, "DamageIndicatorIncrementForKill = " + Long.toString(data.ogame.DamageIndicatorIncrementForKill));
            this.writecode(fileOutputStream, "OnDisplayBanner", data.ogame.OnDisplayBanner);
            this.writecode(fileOutputStream, "OnAfterInputImmediate", data.ogame.OnAfterInputImmediate);
            this.writecode(fileOutputStream, "OnQuit", data.ogame.OnQuit);
            this.writecode(fileOutputStream, "OnStart", data.ogame.OnStart);
            this.writecode(fileOutputStream, "OnScore", data.ogame.OnScore);
            this.writecode(fileOutputStream, "OnInitialise", data.ogame.OnInitialise);
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK");
            vdu.print("Writing locations...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "LOCATIONS");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= olocations.getCount()) {
                location2 = (location)olocations.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(location2.ID));
                this.writeline(fileOutputStream, "Name = " + location2.Name);
                this.writeline(fileOutputStream, "ImagePath = " + location2.ImagePath);
                this.writeline(fileOutputStream, "Description = " + location2.Description);
                this.writeline(fileOutputStream, "IsDark = " + data.booleanToString(location2.IsDark));
                this.writeline(fileOutputStream, "CustomProperties = " + location2.CustomProperties);
                this.writeline(fileOutputStream, "N = " + Long.toString(location2.N));
                this.writeline(fileOutputStream, "S = " + Long.toString(location2.S));
                this.writeline(fileOutputStream, "E = " + Long.toString(location2.E));
                this.writeline(fileOutputStream, "W = " + Long.toString(location2.W));
                this.writeline(fileOutputStream, "U = " + Long.toString(location2.U));
                this.writeline(fileOutputStream, "D = " + Long.toString(location2.D));
                this.writeline(fileOutputStream, "NE = " + Long.toString(location2.NE));
                this.writeline(fileOutputStream, "NW = " + Long.toString(location2.NW));
                this.writeline(fileOutputStream, "SE = " + Long.toString(location2.SE));
                this.writeline(fileOutputStream, "SW = " + Long.toString(location2.SW));
                this.writecode(fileOutputStream, "OnInput", location2.OnInput);
                this.writecode(fileOutputStream, "OnDisplay", location2.OnDisplay);
                if (n < olocations.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " locations)");
            vdu.print("Writing items...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "ITEMS");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= oitems.getCount()) {
                item2 = (item)oitems.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(item2.ID));
                this.writeline(fileOutputStream, "Name = " + item2.Name);
                this.writeline(fileOutputStream, "CurrentLocation = " + Long.toString(item2.CurrentLocation));
                this.writeline(fileOutputStream, "Weight = " + Long.toString(item2.Weight));
                this.writeline(fileOutputStream, "Description = " + item2.Description);
                this.writeline(fileOutputStream, "CustomProperties = " + item2.CustomProperties);
                this.writeline(fileOutputStream, "UserBooleans = " + item2.UserBooleans);
                this.writeline(fileOutputStream, "NounID = " + Long.toString(item2.NounID));
                this.writeline(fileOutputStream, "IsLightSource = " + data.booleanToString(item2.IsLightSource));
                this.writeline(fileOutputStream, "IsLit = " + data.booleanToString(item2.IsLit));
                this.writeline(fileOutputStream, "IsWorn = " + data.booleanToString(item2.IsWorn));
                this.writeline(fileOutputStream, "IsWeapon = " + data.booleanToString(item2.IsWeapon));
                this.writeline(fileOutputStream, "Transparent = " + data.booleanToString(item2.Transparent));
                this.writeline(fileOutputStream, "HasSurface = " + data.booleanToString(item2.HasSurface));
                this.writeline(fileOutputStream, "CanBeLaidOn = " + data.booleanToString(item2.CanBeLaidOn));
                this.writeline(fileOutputStream, "CanBeStoodOn = " + data.booleanToString(item2.CanBeStoodOn));
                this.writeline(fileOutputStream, "CanBeSatOn = " + data.booleanToString(item2.CanBeSatOn));
                this.writeline(fileOutputStream, "CanBeGotIn = " + data.booleanToString(item2.CanBeGotIn));
                this.writeline(fileOutputStream, "DefaultExamine = " + item2.DefaultExamine);
                this.writeline(fileOutputStream, "IsContainer = " + data.booleanToString(item2.IsContainer));
                this.writeline(fileOutputStream, "IsEdible = " + data.booleanToString(item2.IsEdible));
                this.writeline(fileOutputStream, "EdibleHitPoints = " + Long.toString(item2.EdibleHitPoints));
                this.writeline(fileOutputStream, "IsWearable = " + data.booleanToString(item2.IsWearable));
                this.writeline(fileOutputStream, "IsReadable = " + data.booleanToString(item2.IsReadable));
                this.writeline(fileOutputStream, "ReadableText = " + item2.ReadableText);
                this.writeline(fileOutputStream, "Size = " + Long.toString(item2.Size));
                this.writeline(fileOutputStream, "DamageIndicator = " + Long.toString(item2.DamageIndicator));
                this.writeline(fileOutputStream, "Invisible = " + data.booleanToString(item2.Invisible));
                this.writeline(fileOutputStream, "IsFixed = " + data.booleanToString(item2.IsFixed));
                this.writeline(fileOutputStream, "CanOpenClose = " + data.booleanToString(item2.CanOpenClose));
                this.writeline(fileOutputStream, "OpenCloseState = " + data.booleanToString(item2.OpenCloseState));
                this.writeline(fileOutputStream, "FixedMessage = " + item2.FixedMessage);
                this.writeline(fileOutputStream, "IsSubItem = " + data.booleanToString(item2.IsSubItem));
                this.writeline(fileOutputStream, "SubItemOf = " + Long.toString(item2.SubItemOf));
                this.writecode(fileOutputStream, "OnAction", item2.OnAction);
                if (n < oitems.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " items)");
            vdu.print("Writing NPCs...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "CHARACTERS");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= ocharacters.getCount()) {
                character2 = (character)ocharacters.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(character2.ID));
                this.writeline(fileOutputStream, "Name = " + character2.Name);
                this.writeline(fileOutputStream, "CurrentLocation = " + Long.toString(character2.CurrentLocation));
                this.writeline(fileOutputStream, "Description = " + character2.Description);
                this.writeline(fileOutputStream, "NounID = " + Long.toString(character2.NounID));
                this.writeline(fileOutputStream, "TimerInterval = " + Long.toString(character2.TimerInterval));
                this.writeline(fileOutputStream, "DefaultExamine = " + character2.DefaultExamine);
                this.writeline(fileOutputStream, "HitPoints = " + Long.toString(character2.HitPoints));
                this.writeline(fileOutputStream, "DamageIndicator = " + Long.toString(character2.DamageIndicator));
                this.writeline(fileOutputStream, "AutoAttack = " + data.booleanToString(character2.AutoAttack));
                this.writeline(fileOutputStream, "AttackWhenAttacked = " + data.booleanToString(character2.AttackWhenAttacked));
                this.writeline(fileOutputStream, "Money = " + Long.toString(character2.Money));
                this.writecode(fileOutputStream, "OnTimer", character2.OnTimer);
                this.writecode(fileOutputStream, "OnTalk", character2.OnTalk);
                this.writecode(fileOutputStream, "OnAction", character2.OnAction);
                if (n < ocharacters.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " characters)");
            vdu.print("Writing Verbs...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "VERBS");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= overbs.getCount()) {
                verb2 = (verb)overbs.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(verb2.ID));
                this.writeline(fileOutputStream, "Text = " + verb2.Text);
                if (n < overbs.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " verbs)");
            vdu.print("Writing nouns...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "NOUNS");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= onouns.getCount()) {
                noun2 = (noun)onouns.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(noun2.ID));
                this.writeline(fileOutputStream, "Text = " + noun2.Text);
                if (n < onouns.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " nouns)");
            vdu.print("Writing adverbs...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "ADVERBS");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= oadverbs.getCount()) {
                adverb2 = (adverb)oadverbs.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(adverb2.ID));
                this.writeline(fileOutputStream, "Text = " + adverb2.Text);
                if (n < oadverbs.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " adverbs)");
            vdu.print("Writing messages...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "MESSAGES");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= omessages.getCount()) {
                message2 = (message)omessages.get(n);
                this.writeline(fileOutputStream, "ID = " + Long.toString(message2.ID));
                this.writeline(fileOutputStream, "Text = " + message2.Text);
                if (n < omessages.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " messages)");
            vdu.print("Writing code modules...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "MODULES");
            this.writeline(fileOutputStream, "");
            n = 1;
            while (n <= omodules.getCount()) {
                codemodule2 = (codemodule)omodules.get(n);
                this.writeline(fileOutputStream, "ID = " + codemodule2.ID);
                this.writeline(fileOutputStream, "N = " + codemodule2.Name);
                this.writecode(fileOutputStream, "C", codemodule2.Code);
                if (n < omodules.getCount()) {
                    this.writeline(fileOutputStream, "BREAK");
                }
                ++n;
            }
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "END");
            vdu.println("OK (" + Integer.toString(n - 1) + " code modules)");
            vdu.print("Writing event code (1 of 2)...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "RUNBEFOREINPUT");
            n = 1;
            while (n <= data.orunbeforeinput.code.getCount()) {
                this.writeline(fileOutputStream, data.orunbeforeinput.code.get(n));
                ++n;
            }
            this.writeline(fileOutputStream, "$END$");
            vdu.println("OK (" + Integer.toString(n - 1) + " lines)");
            vdu.print("Writing event code (2 of 2)...");
            this.writeline(fileOutputStream, "");
            this.writeline(fileOutputStream, "RUNAFTERINPUT");
            n = 1;
            while (n <= data.orunafterinput.code.getCount()) {
                this.writeline(fileOutputStream, data.orunafterinput.code.get(n));
                ++n;
            }
            this.writeline(fileOutputStream, "$END$");
            vdu.println("OK (" + Integer.toString(n) + " lines)");
            vdu.println("Save complete.");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vdu.println("Error opening output file - " + exception.getMessage());
            return;
        }
    }

    public static void cleardata() {
        oadverbs = new iagecollection();
        overbs = new iagecollection();
        onouns = new iagecollection();
        ogame = new game();
        olocations = new iagecollection();
        ocharacters = new iagecollection();
        oitems = new iagecollection();
        omodules = new iagecollection();
        orunafterinput = new runafterinput();
        orunbeforeinput = new runbeforeinput();
        oplayers = new iagecollection();
        omessages = new iagecollection();
    }

    static {
        maxflags = 1000;
        ipport = 1111;
        defaultnewplayername = "<new player>";
        nextplayerID = 1;
        oadverbs = new iagecollection();
        overbs = new iagecollection();
        onouns = new iagecollection();
        ogame = new game();
        olocations = new iagecollection();
        ocharacters = new iagecollection();
        oitems = new iagecollection();
        omodules = new iagecollection();
        orunafterinput = new runafterinput();
        orunbeforeinput = new runbeforeinput();
        oplayers = new iagecollection();
        omessages = new iagecollection();
        openfilename = "";
    }
}

