/*
	palm_stdio.h
	
	stdio-to-Palm OS mapping
*/

#ifndef _STDIO_H
#define _STDIO_H

#include <DataMgr.h>
#include <MemoryMgr.h>

#ifndef EOF
#define EOF (-1)
#endif

#ifndef _SIZE_T_DEFINED
#define _SIZE_T_DEFINED
typedef unsigned int size_t;
#endif

#define MAXPATH 64

#define PH_DB_DEFAULT_BLOCKSIZE 0x1000

typedef struct
{
#ifdef DEBUG_STDIO
	char name[MAXPATH];
#endif
	DmOpenRef ref;
	UInt32 blocksize;
	UInt16 open_record;
	MemHandle record_handle;
	MemPtr record_data;
	UInt16 mode;
	UInt32 pos;
	UInt32 length;
	int error;
} PH_FILE;

#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2

PH_FILE *ph_fopen(char *filename, char *mode);
int ph_fclose(PH_FILE *file);
int ph_fseek(PH_FILE *file, long pos, int mode);
int ph_fgetc(PH_FILE *file);
int ph_fputc(int c, PH_FILE *file);
size_t ph_fread (void *ptr, size_t size, size_t nmemb, PH_FILE *file);
char *ph_fgets (char *s, int n, PH_FILE *file);
int ph_fputs(const char *s, PH_FILE *file);

#define ftell(f) 	(f->pos)
#define ferror(f)	(f->error)

// Simple to replace fprintf() since all calls are the same:
#define fprintf(file, str, fmt) (0)

#define fopen	ph_fopen
#define fclose	ph_fclose
#define fseek	ph_fseek
#define fgetc	ph_fgetc
#define fputc	ph_fputc
#define fread	ph_fread
#define fgets	ph_fgets
#define fputs	ph_fputs

#endif	// ifndef _STDIO_H