/* gtw_grx.h: graphics windows definitions
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/
#ifndef ALLEGRO_H
 typedef void *BITMAP;
#endif

/* The type of a graphics window */
typedef struct window_graphics_struct
{
    window_t *owner;               /* Owner window */
    BITMAP *data;                  /* image buffer for this window */
    glui32 bgcolor;                /* background color for this window */
    int dirty;                     /* window needs redraw */
} window_graphics_t;


glui32 gli_graphics_scale(glui32 size, glui32 method);
void gli_graphics_winsize(window_t *win, glui32 *wid, glui32 *hgt);
window_graphics_t *win_graphics_create(window_t *win);
void win_graphics_destroy(window_graphics_t *dwin);
void win_graphics_rearrange(window_t *win, grect_t *box);
void win_graphics_redraw(window_t *win);
void win_graphics_update(window_t *win);
void win_graphics_clear(window_t *win);

void win_graphics_erase_rect(winid_t win,
    glsi32 left, glsi32 top, glui32 width, glui32 height);
void win_graphics_fill_rect(winid_t win, glui32 color,
    glsi32 left, glsi32 top, glui32 width, glui32 height);
void win_graphics_set_background_color(winid_t win, glui32 color);



