/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.util.ArrayList;
import mdh.aiee.Adventure;
import mdh.aiee.Stuff;

public abstract class Thing
extends Stuff {
    private static final String DEFINITE = "the ";
    private String article_ = "";
    private String loc_;
    private boolean visible_ = true;
    private ArrayList alias_;

    public Thing(String id, String name) {
        super(id, name);
    }

    public String aName() {
        if (this.article_.length() == 0) {
            return this.getName();
        }
        return this.article_ + this.getName();
    }

    public String theName() {
        if (this.article_.length() == 0) {
            return this.getName();
        }
        return DEFINITE + this.getName();
    }

    public void addAlias(String name) {
        if (this.alias_ == null) {
            this.alias_ = new ArrayList(1);
        }
        this.alias_.add(name);
    }

    public boolean equalsName(String s) {
        if (super.equalsName(s)) {
            return true;
        }
        if (s == null || this.alias_ == null) {
            return false;
        }
        int len = this.alias_.size();
        for (int i = 0; i < len; ++i) {
            String name = (String)this.alias_.get(i);
            if (!name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesName(String s) {
        if (super.matchesName(s)) {
            return true;
        }
        if (s == null || this.alias_ == null) {
            return false;
        }
        int slen = s.length();
        if (slen == 0) {
            return false;
        }
        int len = this.alias_.size();
        for (int i = 0; i < len; ++i) {
            String name = (String)this.alias_.get(i);
            if (!name.regionMatches(true, 0, s, 0, slen)) continue;
            return true;
        }
        return false;
    }

    public Stuff findLoc() {
        return Adventure.getAdv().getStuff(this.loc_);
    }

    public String getArticle() {
        return this.article_;
    }

    public String getDefinite() {
        return this.article_.length() == 0 ? "" : DEFINITE;
    }

    public boolean getVisible() {
        return this.visible_;
    }

    public String loc() {
        return this.loc_;
    }

    public void moveto(Stuff dest) {
        if (this.loc_ != null) {
            this.findLoc().removeContents(this);
        }
        if (dest != null) {
            dest.addContents(this);
        }
    }

    public void setArticle(String s) {
        this.article_ = s == null ? "" : s + " ";
    }

    public void setLoc(String l) {
        this.loc_ = l;
    }

    public void setVisible(boolean v) {
        this.visible_ = v;
    }

    protected void toString2(StringBuffer sb) {
        sb.append(" loc=\"").append(String.valueOf(this.loc_)).append('\"');
        if (this.article_.length() > 0) {
            sb.append(" article=\"").append(this.article_).append('\"');
        }
        sb.append('>');
        if (this.alias_ != null) {
            int len = this.alias_.size();
            for (int i = 0; i < len; ++i) {
                sb.append("\n<alias name=\"").append(this.alias_.get(i)).append("\"/>");
            }
        }
        if (!this.visible_) {
            sb.append("\n<invisible/>");
        }
    }
}

