/*
   winglk_startup.c: Windows-specific code for the Glk examples.
*/

#include "Glk.h"
#include "WinGlk.h"

extern frefid_t g_gamefile;

int winglk_startup_code(const char *cmdline)
{
	const char * fname;

	winglk_app_set_name("GLK AdvSys");

	/* Get the file reference. */
	fname = winglk_get_initial_filename(cmdline, "Pick an AdvSys game file",
		"AdvSys Files (.dat)|*.dat|All Files|*.*");
	if (fname)
	{
		g_gamefile = glk_fileref_create_by_name(fileusage_BinaryMode|fileusage_Data,
			fname, 0);
	}
	return g_gamefile != 0;
}
