/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

#include "StdAfx.h"
#include <stdio.h>
#include "cparser.hpp"

CParser::CParser( void )
{
	vocabulary = new CVocab;
    first_input=true;
	againAvailable = false; //no Previous command
	storeInput = false; //last command was not again

	adverb=noun1=noun2=adjective1=adjective2=preposition=verb=-1; //reset values
	_adverb=_noun1=_noun2=_adjective1=_adjective2=_preposition=_verb=-1; //reset values
}

CParser::~CParser()
{
	delete vocabulary;
}
void CParser::reset()
{

	if ( storeInput )
	{
		_adverb = adverb;
		_noun1  = noun1;
		_noun2  = noun2;
		_adjective1 = adjective1;
		_adjective2 = adjective2;
		_preposition = preposition;
		_verb = verb;

		againAvailable = true;
	}

	adverb=noun1=noun2=adjective1=adjective2=preposition=verb=-1; //reset values
	storeInput = true;
}

bool CParser::Again()
{
	if ( !first_input )
	{
		adverb = _adverb;
		noun1  = _noun1;
		noun2  = _noun2;
		adjective1 = _adjective1;
		adjective2 = _adjective2;
		preposition = _preposition;
		verb = _verb;
	}
	storeInput = false;
	return !first_input;
}




int CParser::parse( wchar_t *player_input )
{
	reset();
	wchar_t *token;
	bool endofls=false;
	int count,temp;

	token_count=0;
	
	///Reset inputs
    ptr_noun1[0] = ptr_noun2[0] = ptr_verb[0] = ptr_adverb[0] = ptr_adjective1[0] = ptr_adjective2[0] = '\0';

    //Parse input
	token = wcstok( player_input, _T(" ") );
   while( token != NULL )
   {
       tokens[token_count]=token;
      /* Get next token: */
	  token_count++;
      token = wcstok( NULL, _T(" ") );
   }

   
   count=0;
   while ( count<token_count && !endofls )
   {
	   if ( ((temp = vocabulary->GetVerb( tokens[count] )) != -1 ) && ( verb == -1 ) )
	   {
		   verb = temp;
		   wcsncpy( ptr_verb, tokens[count], 32 );
		   goto end;
	   }

	   if ( (temp = vocabulary->GetNoun( tokens[count])) != -1  )
	   {
		   if ( noun1 == -1 )
		   {
			   noun1=temp;
			   wcsncpy( ptr_noun1, tokens[count], 32 );			   
		   }
		   else
		   {
			   if ( noun2 == -1 )
			   {
				   noun2 = temp;
				   wcsncpy( ptr_noun2, tokens[count], 32 );			   
			   }
		   }
		   goto end;
	   }
	   
	   if ( (temp = vocabulary->GetAdjective( tokens[count])) != -1  )
	   {
		   if ( adjective1 == -1 )
		   {
			   adjective1=temp;
			   wcsncpy( ptr_adjective1, tokens[count], 32 );			   			   
		   }
		   else
		   {
			   if ( adjective2 == -1 )
			   {
				   adjective2 = temp;
				   wcsncpy( ptr_adjective2, tokens[count], 32 );				   
			   }
		   }
		   goto end;
	   }

	   	   if ( (temp = vocabulary->GetAdverb( tokens[count])) != -1  )
	   {
		   if ( adverb == -1 )
		   {
			   adverb=temp;
			   wcsncpy( ptr_adverb, tokens[count], 32 );				   
		   }
		   goto end;
	   }


	   if ( ((temp = vocabulary->GetPreposition( tokens[count])) != -1 ) && ( preposition == -1 ) )
	   {
		   preposition=temp;
		   goto end;
	   }

	   if ( (temp = vocabulary->GetPronoun( tokens[count])) != -1  )
	   { 
		   if ( (noun1 == -1) && ( adjective1 == -1 ) )
		   {
			   noun1 = lastnoun;
			   adjective1 = lastadjective;
				goto end;
		   }
		   if ( (noun2 == -1) && ( adjective2 == -1 ) )
		   {
			   noun2 = lastnoun;
			   adjective2 = lastadjective;
			   goto end;
		   }
	   }
	   if ( (temp = vocabulary->GetConjugation( tokens[count])) != -1  )
	   {
		   endofls = true;
	   }
end:
	   count++;
   }
   lastnoun = noun1;
   lastadjective = adjective1;


  
   return token_count;
}

void CParser::InitVocab( CArchive &ar )
{
 
	vocabulary->Serialize( ar );
	againAvailable = false;
	storeInput = true;

}

wchar_t * CParser::getNoun1()
{
	return ptr_noun1;
}

wchar_t * CParser::getNoun2()
{	
	return ptr_noun2;
}

wchar_t * CParser::getAdjective1()
{
	return ptr_adjective1;
}

wchar_t * CParser::getAdjective2()
{
	return ptr_adjective2;
}

wchar_t * CParser::getVerb()
{
	return ptr_verb;
}

wchar_t * CParser::getAdVerb()
{
	return ptr_adverb;
}

