/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.jdom.Element;

public class TriggerEditor
extends CountdownElementEditor {
    private JCheckBox iFirstonly;

    public TriggerEditor(Element element, GameEditor gameEditor) {
        super(element, gameEditor);
        this.addNewData("oneveryturn");
        this.addNewData("onjump");
        this.addNewData("onexamine", "target", "Thing being examined:", 7);
        this.addNewData("onsmell", "target", "In room:", 5);
        this.addNewData("onlisten", "target", "In room:", 5);
        this.addNewData("oncommand", null, "Command:", 1);
        this.addNewData("onenter", "target", "On entering:", 5);
        this.addNewData("onexit", "target", "On leaving:", 5);
        this.addNewData("onpickup", "target", "Thing picked up:", 7);
        this.addNewData("onputdown", "target", "Thing put down:", 7);
        this.addNewData("onopen", "target", "Thing opened:", 3);
        this.addNewData("onclose", "target", "Thing closed:", 3);
        this.addNewData("onturnon", "target", "Thing turned on:", 3);
        this.addNewData("onturnoff", "target", "Thing turned off:", 3);
        this.addNewData("onwear", "target", "Thing worn:", 3);
        this.addNewData("onunwear", "target", "Thing unworn:", 3);
        this.addNewData("onignite", "target", "Thing set on fire:", 7);
        this.addNewData("ondouse", "target", "Thing doused:", 7);
        this.addNewData("oneat", "target", "Thing eaten:", 3);
        this.addNewData("ondrink", "target", "Thing drunk:", 3);
        this.addNewData("onkill", "target", "Monster killed:", 4);
        this.addNewData("onscoreabove", "score", "Score:", 2);
        this.addNewData("onhpbelow", "target", "When HP of:", 7, "hp", "falls below:", 2);
        this.addNewData("onturn", "turn", "On turn number:", 2);
        this.addNewData("onattack", "target", "Monster attacked:", 7);
        this.addNewData("onhit", "target", "Monster hit:", 7);
        this.addNewData("onpoison", "target", "Monster poisoned:", 4);
        this.addNewData("onwield", "target", "Weapon wielded:", 3);
        this.addNewData("onunwield", "target", "Weapon unwielded:", 3);
        this.addNewData("onlock", "connection", "Connection:", 6);
        this.addNewData("onunlock", "connection", "Connection:", 6);
        this.updateWindowName();
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        this.controls = new ArrayList();
        this.iType = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.data.keySet().toArray()));
        String string = this.theEl.getName();
        if (!this.data.containsKey(string)) {
            string = ((String[])this.data.keySet().toArray())[0];
            this.theEl.setName(string);
        }
        this.iType.setSelectedItem(string);
        this.resetControls();
        this.iType.addActionListener(this);
        this.iType.setActionCommand("changetype");
        this.iFirstonly = new JCheckBox();
        this.iFirstonly.setSelected("true".equals(this.theEl.getAttributeValue("firstonly")));
        this.iFirstonly.addChangeListener(this);
        JButton jButton = new JButton("Delete");
        jButton.setActionCommand("delete");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        jPanel.add(new JLabel("Trigger type:"));
        jPanel.add(this.iType);
        jPanel.add(new JLabel("Trigger first time only:"));
        jPanel.add(this.iFirstonly);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(this.controlPanel);
        this.getContentPane().add((Component)jButton, "South");
        this.pack();
        this.setLocation(10, 10);
    }

    protected void updateWindowName() {
        String string = this.theEl.getName();
        this.setTitle("Trigger: " + string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        if (changeEvent.getSource() == this.iFirstonly) {
            this.theEl.setAttribute("firstonly", this.iFirstonly.isSelected() ? "true" : "false");
        }
    }
}

