/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jdom.Element;

public class RoomEditor
extends ElementEditor {
    private Document dName;
    private Document dBgcolor;
    private Document dDesc;
    private Document dMdesc;
    private Document dSmelldesc;
    private Document dSounddesc;
    private Document dDeadlyMsg;
    private JTextField iDeadlyMsg;
    private JSpinner iScore;
    private JCheckBox iLighted;
    private JCheckBox iDeadly;

    public RoomEditor(Element element, GameEditor gameEditor) {
        super(element, gameEditor, false);
        JTextField jTextField = new JTextField(this.theEl.getChildText("name"));
        JTextField jTextField2 = new JTextField(this.theEl.getChildText("bgcolor"));
        JTextField jTextField3 = new JTextField(this.theEl.getChildText("desc"));
        JTextField jTextField4 = new JTextField(this.theEl.getChildText("mdesc"));
        JTextField jTextField5 = new JTextField(this.theEl.getChildText("smelldesc"));
        JTextField jTextField6 = new JTextField(this.theEl.getChildText("sounddesc"));
        this.iDeadlyMsg = new JTextField(this.theEl.getChildText("deadly"));
        this.iScore = this.newSpinner("score", 1, 1, 9999);
        this.iLighted = new JCheckBox();
        this.iLighted.setSelected(this.theEl.getChild("lighted") != null);
        this.iDeadly = new JCheckBox();
        this.iDeadly.setSelected(this.theEl.getChild("deadly") != null);
        this.iDeadlyMsg.setEnabled(this.iDeadly.isSelected());
        this.dName = jTextField.getDocument();
        this.dBgcolor = jTextField2.getDocument();
        this.dDesc = jTextField3.getDocument();
        this.dMdesc = jTextField4.getDocument();
        this.dSmelldesc = jTextField5.getDocument();
        this.dSounddesc = jTextField6.getDocument();
        this.dDeadlyMsg = this.iDeadlyMsg.getDocument();
        this.dName.addDocumentListener(this);
        this.dBgcolor.addDocumentListener(this);
        this.dDesc.addDocumentListener(this);
        this.dMdesc.addDocumentListener(this);
        this.dSmelldesc.addDocumentListener(this);
        this.dSounddesc.addDocumentListener(this);
        this.dDeadlyMsg.addDocumentListener(this);
        this.iLighted.addChangeListener(this);
        this.iDeadly.addChangeListener(this);
        JButton jButton = new JButton("Delete");
        jButton.setActionCommand("delete");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(9, 2));
        jPanel.add(new JLabel("Name of this room:"));
        jPanel.add(jTextField);
        jPanel.add(new JLabel("Score for this room:"));
        jPanel.add(this.iScore);
        jPanel.add(new JLabel("Full description of this room:"));
        jPanel.add(jTextField3);
        jPanel.add(new JLabel("Shorter description this room:"));
        jPanel.add(jTextField4);
        jPanel.add(new JLabel("Description of the room's smell:"));
        jPanel.add(jTextField5);
        jPanel.add(new JLabel("Description of sounds:"));
        jPanel.add(jTextField6);
        jPanel.add(new JLabel("Death message:"));
        jPanel.add(this.iDeadlyMsg);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Lighted?"));
        jPanel2.add(this.iLighted);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Deadly?"));
        jPanel2.add(this.iDeadly);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel("HTML color code for this room:"));
        jPanel.add(jTextField2);
        if (this.theEl.getAttributeValue("number").equals("9999")) {
            jButton.setEnabled(false);
        }
        this.getContentPane().add(jPanel);
        this.getContentPane().add((Component)jButton, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(400, (int)dimension.getHeight());
        this.setLocation(10, 10);
    }

    protected void updateWindowName() {
        String string = this.theEl.getChildText("name");
        if (string == null) {
            string = "New Room";
        }
        this.setTitle(string);
    }

    public void handleDocUpdate(DocumentEvent documentEvent) {
        this.updateDocumentAfterEvent(documentEvent, this.dName, "name");
        this.updateWindowName();
        this.updateDocumentAfterEvent(documentEvent, this.dBgcolor, "bgcolor");
        this.updateDocumentAfterEvent(documentEvent, this.dDesc, "desc");
        this.updateDocumentAfterEvent(documentEvent, this.dMdesc, "mdesc");
        this.updateDocumentAfterEvent(documentEvent, this.dSmelldesc, "smelldesc");
        this.updateDocumentAfterEvent(documentEvent, this.dSounddesc, "sounddesc");
        if (this.iDeadly.isSelected()) {
            this.updateDocumentAfterEvent(documentEvent, this.dDeadlyMsg, "deadly");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateSpinnerAfterEvent(changeEvent, this.iScore, "score");
        this.updateFlagAfterEvent(changeEvent, this.iLighted, "lighted");
        if (changeEvent.getSource() == this.iDeadly) {
            if (this.iDeadly.isSelected() && this.theEl.getChild("deadly") == null) {
                this.theEl.addContent(new Element("deadly"));
                this.theEl.getChild("deadly").setText(ElementEditor.getDocumentText(this.dDeadlyMsg));
                this.iDeadlyMsg.setEnabled(true);
            }
            if (!this.iDeadly.isSelected() && this.theEl.getChild("deadly") != null) {
                this.theEl.removeChild("deadly");
                this.iDeadlyMsg.setEnabled(false);
            }
        }
    }
}

