/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class GameEditor
extends JInternalFrame
implements DocumentListener,
ChangeListener,
InternalFrameListener,
MouseListener {
    private org.jdom.Document gameDoc;
    Element gameRoot;
    ArrayList editors;
    JDesktopPane desktop;
    private JSpinner iMax;
    private JList iNewVerbs;
    private JList iChangeVerbs;
    private JList iRooms;
    private JList iConnections;
    private JList iThings;
    private JList iMonsters;
    private JList iCountdowns;
    private Document dTitle;
    private Document dAuthor;
    private Document dWin;
    private Document dLose;
    private Document dInstructions;
    ListCellRenderer cellrenderer;
    private static final MutableAttributeSet attr = new SimpleAttributeSet();

    public GameEditor(JDesktopPane jDesktopPane) {
        super("New Game", true, false, true, true);
        this.desktop = jDesktopPane;
        this.editors = new ArrayList();
        this.cellrenderer = new EntityRenderer(true, this);
        this.gameRoot = new Element("game");
        this.gameDoc = new org.jdom.Document(this.gameRoot);
        Element element = new Element("monster");
        element.setAttribute("number", "0");
        element.addContent(new Element("name"));
        element.getChild("name").setText("player");
        this.gameRoot.addContent(element);
        Element element2 = new Element("room");
        element2.setAttribute("number", "9999");
        element2.addContent(new Element("name"));
        element2.getChild("name").setText("Treasure Room");
        this.gameRoot.addContent(element2);
        this.getContentPane().setLayout(new GridLayout(3, 3));
        JPanel jPanel = new JPanel(new GridLayout(5, 2));
        JLabel jLabel = new JLabel("Title:");
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField();
        jPanel.add(jTextField);
        this.dTitle = jTextField.getDocument();
        jLabel = new JLabel("Author:");
        jPanel.add(jLabel);
        jTextField = new JTextField();
        jPanel.add(jTextField);
        this.dAuthor = jTextField.getDocument();
        jLabel = new JLabel("Win message:");
        jPanel.add(jLabel);
        jTextField = new JTextField();
        jPanel.add(jTextField);
        this.dWin = jTextField.getDocument();
        jLabel = new JLabel("Lose message:");
        jPanel.add(jLabel);
        jTextField = new JTextField();
        jPanel.add(jTextField);
        this.dLose = jTextField.getDocument();
        jLabel = new JLabel("Max score:");
        jPanel.add(jLabel);
        this.iMax = new JSpinner(new SpinnerNumberModel(100, 1, 9999, 1));
        jPanel.add(this.iMax);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("New verbs:"), "North");
        this.iNewVerbs = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.iNewVerbs);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Changed verbs:"), "North");
        this.iChangeVerbs = new JList();
        jScrollPane = new JScrollPane(this.iChangeVerbs);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Instructions:"), "North");
        JTextPane jTextPane = new JTextPane();
        jScrollPane = new JScrollPane(jTextPane);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        this.dInstructions = jTextPane.getDocument();
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Rooms:"), "North");
        this.iRooms = new JList();
        jScrollPane = new JScrollPane(this.iRooms);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Connections:"), "North");
        this.iConnections = new JList();
        jScrollPane = new JScrollPane(this.iConnections);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Things:"), "North");
        this.iThings = new JList();
        jScrollPane = new JScrollPane(this.iThings);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Monsters:"), "North");
        this.iMonsters = new JList();
        jScrollPane = new JScrollPane(this.iMonsters);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Countdowns:"), "North");
        this.iCountdowns = new JList();
        jScrollPane = new JScrollPane(this.iCountdowns);
        jPanel.add(jScrollPane);
        this.getContentPane().add(jPanel);
        this.setSize(600, 400);
        this.iNewVerbs.setCellRenderer(this.cellrenderer);
        this.iChangeVerbs.setCellRenderer(this.cellrenderer);
        this.iRooms.setCellRenderer(this.cellrenderer);
        this.iConnections.setCellRenderer(this.cellrenderer);
        this.iThings.setCellRenderer(this.cellrenderer);
        this.iMonsters.setCellRenderer(this.cellrenderer);
        this.iCountdowns.setCellRenderer(this.cellrenderer);
        this.updateElementLists();
        this.dTitle.addDocumentListener(this);
        this.dAuthor.addDocumentListener(this);
        this.dWin.addDocumentListener(this);
        this.dLose.addDocumentListener(this);
        this.dInstructions.addDocumentListener(this);
        this.iMax.addChangeListener(this);
        this.iNewVerbs.addMouseListener(this);
        this.iChangeVerbs.addMouseListener(this);
        this.iRooms.addMouseListener(this);
        this.iConnections.addMouseListener(this);
        this.iThings.addMouseListener(this);
        this.iMonsters.addMouseListener(this);
        this.iCountdowns.addMouseListener(this);
    }

    static DefaultComboBoxModel getNewList() {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        defaultComboBoxModel.insertElementAt(null, 0);
        return defaultComboBoxModel;
    }

    static String getDocumentText(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static void setDocumentText(Document document, String string) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, attr);
        }
        catch (BadLocationException badLocationException) {}
    }

    void loadGame(File file) throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            this.gameDoc = sAXBuilder.build(file);
            if (!this.gameDoc.hasRootElement()) {
                this.gameDoc.setRootElement(new Element("game"));
            }
            this.gameRoot = this.gameDoc.getRootElement();
            GameEditor.setDocumentText(this.dTitle, this.gameRoot.getAttributeValue("title"));
            GameEditor.setDocumentText(this.dAuthor, this.gameRoot.getAttributeValue("author"));
            GameEditor.setDocumentText(this.dWin, this.gameRoot.getChildText("winmessage"));
            GameEditor.setDocumentText(this.dLose, this.gameRoot.getChildText("losemessage"));
            GameEditor.setDocumentText(this.dInstructions, this.gameRoot.getChildText("instructions"));
            this.updateElementLists();
            try {
                this.iMax.setValue(new Integer(this.gameRoot.getChildTextTrim("maxscore")));
            }
            catch (NumberFormatException numberFormatException) {
                this.iMax.setValue(new Integer(100));
            }
        }
        catch (JDOMException jDOMException) {
            throw new IOException("JDOM error: " + jDOMException.getMessage());
        }
    }

    DefaultComboBoxModel elementsOfType(String string) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(this.gameRoot.getChildren(string).toArray());
        defaultComboBoxModel.insertElementAt(null, 0);
        return defaultComboBoxModel;
    }

    void saveGame(File file) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setNewlines(true);
        xMLOutputter.setIndent(3);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        xMLOutputter.output(this.gameDoc, (Writer)bufferedWriter);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    void closeWindows() {
        while (!this.editors.isEmpty()) {
            ((JInternalFrame)this.editors.get(0)).dispose();
        }
    }

    private void updateElementLists() {
        this.iNewVerbs.setModel(this.elementsOfType("newverb"));
        this.iChangeVerbs.setModel(this.elementsOfType("changeverb"));
        this.iRooms.setModel(this.elementsOfType("room"));
        this.iConnections.setModel(this.elementsOfType("connection"));
        this.iThings.setModel(this.elementsOfType("thing"));
        this.iMonsters.setModel(this.elementsOfType("monster"));
        this.iCountdowns.setModel(this.elementsOfType("countdown"));
    }

    Element getElementByNumber(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.gameRoot.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!string.equals(element.getAttributeValue("number"))) continue;
            return element;
        }
        return null;
    }

    private String getFreeNumber() {
        Object object;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.gameRoot.getChildren().iterator();
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            try {
                treeSet.add(new Integer(object.getAttributeValue("number")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = new Integer(0);
        while (treeSet.contains(object)) {
            object = new Integer((Integer)object + 1);
        }
        return ((Integer)object).toString();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.iMax) {
            Element element = this.gameRoot.getChild("maxscore");
            if (element == null) {
                element = new Element("maxscore");
                this.gameRoot.addContent(element);
            }
            element.setText(this.iMax.getValue().toString());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocUpdate(documentEvent);
    }

    void handleDocUpdate(DocumentEvent documentEvent) {
        Element element;
        if (documentEvent.getDocument() == this.dTitle) {
            this.gameRoot.setAttribute("title", GameEditor.getDocumentText(this.dTitle));
        }
        if (documentEvent.getDocument() == this.dAuthor) {
            this.gameRoot.setAttribute("author", GameEditor.getDocumentText(this.dAuthor));
        }
        if (documentEvent.getDocument() == this.dWin) {
            element = this.gameRoot.getChild("winmessage");
            if (element == null) {
                element = new Element("winmessage");
                this.gameRoot.addContent(element);
            }
            element.setText(GameEditor.getDocumentText(this.dWin));
        }
        if (documentEvent.getDocument() == this.dLose) {
            element = this.gameRoot.getChild("losemessage");
            if (element == null) {
                element = new Element("losemessage");
                this.gameRoot.addContent(element);
            }
            element.setText(GameEditor.getDocumentText(this.dLose));
        }
        if (documentEvent.getDocument() == this.dInstructions) {
            element = this.gameRoot.getChild("instructions");
            if (element == null) {
                element = new Element("instructions");
                this.gameRoot.addContent(element);
            }
            element.setText(GameEditor.getDocumentText(this.dInstructions));
        }
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.editors.remove(this.editors.indexOf(internalFrameEvent.getSource()));
        this.updateElementLists();
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameRestored(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.iNewVerbs || mouseEvent.getSource() == this.iChangeVerbs || mouseEvent.getSource() == this.iRooms || mouseEvent.getSource() == this.iConnections || mouseEvent.getSource() == this.iThings || mouseEvent.getSource() == this.iMonsters || mouseEvent.getSource() == this.iCountdowns) {
            int n;
            JList jList = (JList)mouseEvent.getSource();
            String string = "bug";
            if (jList == this.iNewVerbs) {
                string = "newverb";
            }
            if (jList == this.iChangeVerbs) {
                string = "changeverb";
            }
            if (jList == this.iRooms) {
                string = "room";
            }
            if (jList == this.iConnections) {
                string = "connection";
            }
            if (jList == this.iThings) {
                string = "thing";
            }
            if (jList == this.iMonsters) {
                string = "monster";
            }
            if (jList == this.iCountdowns) {
                string = "countdown";
            }
            if (!jList.getCellBounds(n = jList.locationToIndex(mouseEvent.getPoint()), n).contains(mouseEvent.getPoint())) {
                n = -1;
            }
            if (n != -1) {
                ElementEditor elementEditor;
                Element element = (Element)jList.getModel().getElementAt(n);
                if (element == null) {
                    element = new Element(string);
                    if (jList == this.iRooms || jList == this.iConnections || jList == this.iThings || jList == this.iMonsters || jList == this.iCountdowns) {
                        element.setAttribute("number", this.getFreeNumber());
                    }
                    this.gameRoot.addContent(element);
                    this.updateElementLists();
                }
                boolean bl = false;
                ListIterator listIterator = this.editors.listIterator();
                while (listIterator.hasNext()) {
                    elementEditor = (ElementEditor)listIterator.next();
                    if (elementEditor.getElement() != element) continue;
                    bl = true;
                    try {
                        elementEditor.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    elementEditor = null;
                    if (jList == this.iNewVerbs) {
                        elementEditor = new NewVerbEditor(element, this);
                    }
                    if (jList == this.iChangeVerbs) {
                        elementEditor = new ChangeVerbEditor(element, this);
                    }
                    if (jList == this.iRooms) {
                        elementEditor = new RoomEditor(element, this);
                    }
                    if (jList == this.iConnections) {
                        elementEditor = new ConnectionEditor(element, this);
                    }
                    if (jList == this.iThings) {
                        elementEditor = new ThingEditor(element, this);
                    }
                    if (jList == this.iMonsters) {
                        elementEditor = new MonsterEditor(element, this);
                    }
                    if (jList == this.iCountdowns) {
                        elementEditor = new CountdownEditor(element, this);
                    }
                    this.desktop.add(elementEditor);
                    this.editors.add(elementEditor);
                    elementEditor.addInternalFrameListener(this);
                    elementEditor.setVisible(true);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

