/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdom.Element;

public abstract class ElementEditor
extends JInternalFrame
implements ActionListener,
ChangeListener,
DocumentListener {
    protected Element theEl;
    protected GameEditor gameEd;

    public ElementEditor(Element element, GameEditor gameEditor, boolean bl) {
        super(null, bl, true, false, true);
        this.theEl = element;
        this.gameEd = gameEditor;
        this.updateWindowName();
    }

    public Element getElement() {
        return this.theEl;
    }

    protected abstract void updateWindowName();

    static String getDocumentText(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static void setChildText(Element element, String string, String string2) {
        if (string2 == null || "".equals(string2)) {
            element.removeChild(string);
        } else {
            Element element2 = element.getChild(string);
            if (element2 == null) {
                element.addContent(new Element(string));
                element2 = element.getChild(string);
            }
            element2.setText(string2);
        }
    }

    protected JCheckBox newFlag(String string) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(this.theEl.getChild(string) != null);
        jCheckBox.addChangeListener(this);
        return jCheckBox;
    }

    protected JSpinner newSpinner(String string, int n, int n2, int n3) {
        int n4;
        try {
            n4 = new Integer(this.theEl.getChildText(string));
        }
        catch (NumberFormatException numberFormatException) {
            n4 = n;
        }
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n4, n2, n3, 1));
        jSpinner.addChangeListener(this);
        return jSpinner;
    }

    protected void updateFlagAfterEvent(ChangeEvent changeEvent, JCheckBox jCheckBox, String string) {
        if (changeEvent.getSource() == jCheckBox) {
            if (jCheckBox.isSelected() && this.theEl.getChild(string) == null) {
                this.theEl.addContent(new Element(string));
            }
            if (!jCheckBox.isSelected() && this.theEl.getChild(string) != null) {
                this.theEl.removeChild(string);
            }
        }
    }

    protected void updateSpinnerAfterEvent(ChangeEvent changeEvent, JSpinner jSpinner, String string) {
        if (changeEvent.getSource() == jSpinner) {
            ElementEditor.setChildText(this.theEl, string, jSpinner.getValue().toString());
        }
    }

    public abstract void stateChanged(ChangeEvent var1);

    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocUpdate(documentEvent);
    }

    public abstract void handleDocUpdate(DocumentEvent var1);

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("delete")) {
            this.theEl.detach();
            this.dispose();
        }
    }

    protected void updateDocumentAfterEvent(DocumentEvent documentEvent, Document document, String string) {
        if (documentEvent.getDocument() == document) {
            ElementEditor.setChildText(this.theEl, string, ElementEditor.getDocumentText(document));
        }
    }

    protected void updateDocumentToAttributeAfterEvent(DocumentEvent documentEvent, Document document, String string) {
        if (documentEvent.getDocument() == document) {
            this.theEl.setAttribute(string, ElementEditor.getDocumentText(document));
        }
    }
}

