/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.jdom.Element;

public class CountdownEditor
extends ElementEditor
implements InternalFrameListener,
MouseListener {
    private JSpinner iCount;
    private JSpinner iDelay;
    private JSpinner iLoops;
    private JComboBox iLogic;
    private JList iTriggers;
    private JList iConditions;
    private JList iEvents;
    private Element triggerRoot;
    private Element conditionRoot;
    private Element eventRoot;
    private ListCellRenderer renderer;

    public CountdownEditor(Element element, GameEditor gameEditor) {
        super(element, gameEditor, true);
        this.renderer = new CountdownEntityRenderer(this.gameEd);
        this.triggerRoot = this.theEl.getChild("triggers");
        if (this.triggerRoot == null) {
            this.triggerRoot = new Element("triggers");
            this.theEl.addContent(this.triggerRoot);
        }
        this.conditionRoot = this.theEl.getChild("conditions");
        if (this.conditionRoot == null) {
            this.conditionRoot = new Element("conditions");
            this.theEl.addContent(this.conditionRoot);
        }
        this.eventRoot = this.theEl.getChild("event");
        if (this.eventRoot == null) {
            this.eventRoot = new Element("event");
            this.theEl.addContent(this.eventRoot);
        }
        if (this.conditionRoot.getAttributeValue("logic") != "and") {
            this.conditionRoot.setAttribute("logic", "and");
        }
        this.updateWindowName();
        this.iCount = this.newSpinner("count", 0, 0, 9999);
        this.iDelay = this.newSpinner("delay", 0, 0, 9999);
        this.iLoops = this.newSpinner("loops", 0, 0, 100);
        Vector<String> vector = new Vector<String>(2);
        vector.add("All");
        vector.add("Any");
        this.iLogic = new JComboBox(new DefaultComboBoxModel(vector));
        if ("or".equals(this.conditionRoot.getAttributeValue("logic"))) {
            this.iLogic.setSelectedItem("Any");
        }
        if ("and".equals(this.conditionRoot.getAttributeValue("logic"))) {
            this.iLogic.setSelectedItem("All");
        }
        this.iLogic.addActionListener(this);
        this.iLogic.setActionCommand("changelogic");
        this.iTriggers = new JList();
        this.iTriggers.addMouseListener(this);
        this.iTriggers.setCellRenderer(this.renderer);
        this.iConditions = new JList();
        this.iConditions.addMouseListener(this);
        this.iConditions.setCellRenderer(this.renderer);
        this.iEvents = new JList();
        this.iEvents.addMouseListener(this);
        this.iEvents.setCellRenderer(this.renderer);
        this.updateLists();
        JButton jButton = new JButton("Delete");
        jButton.setActionCommand("delete");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2));
        jPanel2.add(new JLabel("Trigger count:"));
        jPanel2.add(this.iCount);
        jPanel2.add(new JLabel("Countdown delay:"));
        jPanel2.add(this.iDelay);
        jPanel2.add(new JLabel("Times to loop:"));
        jPanel2.add(this.iLoops);
        jPanel2.add(new JLabel("Conditions needed:"));
        jPanel2.add(this.iLogic);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Triggers:"), "North");
        jPanel2.add(new JScrollPane(this.iTriggers));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Conditions:"), "North");
        jPanel2.add(new JScrollPane(this.iConditions));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Events:"), "North");
        jPanel2.add(new JScrollPane(this.iEvents));
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.getContentPane().add((Component)jButton, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(600, (int)dimension.getHeight());
        this.setLocation(10, 10);
    }

    protected void updateWindowName() {
        this.setTitle("Countdown #" + this.theEl.getAttributeValue("number"));
    }

    private void updateLists() {
        this.iTriggers.setModel(this.getChildrenList(this.triggerRoot));
        this.iConditions.setModel(this.getChildrenList(this.conditionRoot));
        this.iEvents.setModel(this.getChildrenList(this.eventRoot));
    }

    private DefaultComboBoxModel getChildrenList(Element element) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(element.getChildren().toArray());
        defaultComboBoxModel.insertElementAt(null, 0);
        return defaultComboBoxModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getActionCommand().equals("changelogic")) {
            if ("All".equals(this.iLogic.getSelectedItem())) {
                this.conditionRoot.setAttribute("logic", "and");
            }
            if ("Any".equals(this.iLogic.getSelectedItem())) {
                this.conditionRoot.setAttribute("logic", "or");
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.iCount) {
            ElementEditor.setChildText(this.theEl, "count", this.iCount.getValue().toString());
        }
        if (changeEvent.getSource() == this.iDelay) {
            ElementEditor.setChildText(this.theEl, "delay", this.iDelay.getValue().toString());
        }
        if (changeEvent.getSource() == this.iLoops) {
            ElementEditor.setChildText(this.theEl, "loops", this.iLoops.getValue().toString());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.iTriggers || mouseEvent.getSource() == this.iConditions || mouseEvent.getSource() == this.iEvents) {
            int n;
            JList jList = (JList)mouseEvent.getSource();
            Element element = null;
            String string = null;
            if (jList == this.iTriggers) {
                element = this.triggerRoot;
                string = "oneveryturn";
            }
            if (jList == this.iConditions) {
                element = this.conditionRoot;
                string = "isin";
            }
            if (jList == this.iEvents) {
                element = this.eventRoot;
                string = "deadly";
            }
            if (!jList.getCellBounds(n = jList.locationToIndex(mouseEvent.getPoint()), n).contains(mouseEvent.getPoint())) {
                n = -1;
            }
            if (n != -1) {
                ElementEditor elementEditor;
                Element element2 = (Element)jList.getModel().getElementAt(n);
                if (element2 == null) {
                    element2 = new Element(string);
                    element.addContent(element2);
                    this.updateLists();
                }
                boolean bl = false;
                ListIterator listIterator = this.gameEd.editors.listIterator();
                while (listIterator.hasNext()) {
                    elementEditor = (ElementEditor)listIterator.next();
                    if (elementEditor.getElement() != element2) continue;
                    bl = true;
                    try {
                        elementEditor.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    elementEditor = null;
                    if (jList == this.iTriggers) {
                        elementEditor = new TriggerEditor(element2, this.gameEd);
                    }
                    if (jList == this.iConditions) {
                        elementEditor = new ConditionEditor(element2, this.gameEd);
                    }
                    if (jList == this.iEvents) {
                        elementEditor = new EventEditor(element2, this.gameEd);
                    }
                    this.gameEd.desktop.add(elementEditor);
                    this.gameEd.editors.add(elementEditor);
                    elementEditor.addInternalFrameListener(this.gameEd);
                    elementEditor.addInternalFrameListener(this);
                    elementEditor.setVisible(true);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.updateLists();
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameRestored(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void handleDocUpdate(DocumentEvent documentEvent) {
    }
}

