/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jdom.Element;

public class ConnectionEditor
extends ElementEditor {
    private Document dDir;
    private Document dDeadlyMsg;
    private JTextField iDeadlyMsg;
    private JComboBox iFrom;
    private JComboBox iTo;
    private JComboBox iKey;
    private JComboBox iDir;
    private JCheckBox iLocked;
    private JCheckBox iDeadly;

    public ConnectionEditor(Element element, GameEditor gameEditor) {
        super(element, gameEditor, false);
        EntityRenderer entityRenderer = new EntityRenderer(false, this.gameEd);
        ArrayList arrayList = new ArrayList(this.gameEd.gameRoot.getChildren("room"));
        arrayList.add(0, null);
        this.iFrom = new JComboBox<Object>(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.iFrom.setRenderer(entityRenderer);
        this.iFrom.setSelectedItem(this.gameEd.getElementByNumber(this.theEl.getChildText("from")));
        this.iFrom.addActionListener(this);
        this.iFrom.setActionCommand("changefrom");
        this.iTo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.iTo.setRenderer(entityRenderer);
        this.iTo.setSelectedItem(this.gameEd.getElementByNumber(this.theEl.getChildText("to")));
        this.iTo.addActionListener(this);
        this.iTo.setActionCommand("changeto");
        ArrayList arrayList2 = new ArrayList(this.gameEd.gameRoot.getChildren("thing"));
        arrayList2.addAll(this.gameEd.gameRoot.getChildren("monster"));
        arrayList2.add(0, null);
        this.iKey = new JComboBox<Object>(new DefaultComboBoxModel<Object>(arrayList2.toArray()));
        this.iKey.setRenderer(entityRenderer);
        this.iKey.setSelectedItem(this.gameEd.getElementByNumber(this.theEl.getChildText("key")));
        this.iKey.addActionListener(this);
        this.iKey.setActionCommand("changekey");
        Vector<String> vector = new Vector<String>(6);
        vector.add("n");
        vector.add("s");
        vector.add("e");
        vector.add("w");
        vector.add("u");
        vector.add("d");
        this.iDir = new JComboBox(new DefaultComboBoxModel(vector));
        this.iDir.setSelectedItem(this.theEl.getChildText("dir"));
        this.iDir.addActionListener(this);
        this.iDir.setActionCommand("changedir");
        this.iLocked = new JCheckBox();
        this.iLocked.setSelected(this.theEl.getChild("locked") != null);
        this.iLocked.addChangeListener(this);
        this.iDeadly = new JCheckBox();
        this.iDeadly.setSelected(this.theEl.getChild("deadly") != null);
        this.iDeadly.addChangeListener(this);
        this.iDeadlyMsg = new JTextField(this.theEl.getChildText("deadly"));
        this.iDeadlyMsg.setEnabled(this.iDeadly.isSelected());
        this.dDeadlyMsg = this.iDeadlyMsg.getDocument();
        this.dDeadlyMsg.addDocumentListener(this);
        JButton jButton = new JButton("Delete");
        jButton.setActionCommand("delete");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 2));
        jPanel.add(new JLabel("Connection from:"));
        jPanel.add(this.iFrom);
        jPanel.add(new JLabel("To:"));
        jPanel.add(this.iTo);
        jPanel.add(new JLabel("Direction of connection:"));
        jPanel.add(this.iDir);
        jPanel.add(new JLabel("Lock/unlock with:"));
        jPanel.add(this.iKey);
        jPanel.add(new JLabel("Death message:"));
        jPanel.add(this.iDeadlyMsg);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Locked?"));
        jPanel2.add(this.iLocked);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Deadly?"));
        jPanel2.add(this.iDeadly);
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.getContentPane().add((Component)jButton, "South");
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(400, (int)dimension.getHeight());
        this.setLocation(10, 10);
    }

    protected void updateWindowName() {
        this.setTitle("Connection Editor");
    }

    public void handleDocUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.dDeadlyMsg && this.iDeadly.isSelected()) {
            ElementEditor.setChildText(this.theEl, "deadly", ElementEditor.getDocumentText(this.dDeadlyMsg));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getActionCommand().equals("changedir")) {
            ElementEditor.setChildText(this.theEl, "dir", (String)this.iDir.getSelectedItem());
        }
        if (actionEvent.getActionCommand().equals("changefrom")) {
            if (this.iFrom.getSelectedItem() == null) {
                ElementEditor.setChildText(this.theEl, "from", null);
            } else {
                ElementEditor.setChildText(this.theEl, "from", ((Element)this.iFrom.getSelectedItem()).getAttributeValue("number"));
            }
        }
        if (actionEvent.getActionCommand().equals("changeto")) {
            if (this.iTo.getSelectedItem() == null) {
                ElementEditor.setChildText(this.theEl, "to", null);
            } else {
                ElementEditor.setChildText(this.theEl, "to", ((Element)this.iTo.getSelectedItem()).getAttributeValue("number"));
            }
        }
        if (actionEvent.getActionCommand().equals("changekey")) {
            if (this.iKey.getSelectedItem() == null) {
                ElementEditor.setChildText(this.theEl, "key", null);
            } else {
                ElementEditor.setChildText(this.theEl, "key", ((Element)this.iKey.getSelectedItem()).getAttributeValue("number"));
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.iLocked) {
            if (this.iLocked.isSelected() && this.theEl.getChild("locked") == null) {
                this.theEl.addContent(new Element("locked"));
            }
            if (!this.iLocked.isSelected() && this.theEl.getChild("locked") != null) {
                this.theEl.removeChild("locked");
            }
        }
        if (changeEvent.getSource() == this.iDeadly) {
            if (this.iDeadly.isSelected() && this.theEl.getChild("deadly") == null) {
                this.theEl.addContent(new Element("deadly"));
                this.theEl.getChild("deadly").setText(ElementEditor.getDocumentText(this.dDeadlyMsg));
                this.iDeadlyMsg.setEnabled(true);
            }
            if (!this.iDeadly.isSelected() && this.theEl.getChild("deadly") != null) {
                this.theEl.removeChild("deadly");
                this.iDeadlyMsg.setEnabled(false);
            }
        }
    }
}

