/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class AASide
extends JFrame
implements ActionListener,
WindowListener {
    GameEditor ge;
    JDesktopPane desktop;
    File gamefile;

    public static void main(String[] stringArray) {
        AASide aASide = new AASide();
    }

    public AASide() {
        super("Advanced Authoring System IDE v2.0b");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setMnemonic(78);
        jMenuItem.setActionCommand("New");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Open");
        jMenuItem.setMnemonic(79);
        jMenuItem.setActionCommand("Open");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setMnemonic(83);
        jMenuItem.setActionCommand("Save");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("Save As");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenuItem.setActionCommand("Exit");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Help");
        jMenuItem.setMnemonic(72);
        jMenuItem.setActionCommand("Help");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("About");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.desktop = new JDesktopPane();
        this.getContentPane().add(this.desktop);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.show();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeCurrentGame();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        String string = actionEvent.getActionCommand();
        if (string.equals("New")) {
            this.closeCurrentGame();
            this.gamefile = null;
            this.ge = new GameEditor(this.desktop);
            this.desktop.add(this.ge);
            this.ge.setVisible(true);
        }
        if (string.equals("Open")) {
            serializable = new JFileChooser();
            serializable.setFileFilter(new ARGFileFilter());
            if (serializable.showOpenDialog(this) == 0) {
                this.closeCurrentGame();
                this.gamefile = serializable.getSelectedFile();
                this.ge = new GameEditor(this.desktop);
                try {
                    this.ge.loadGame(this.gamefile);
                    this.ge.setTitle(this.gamefile.getName());
                    this.desktop.add(this.ge);
                    this.ge.setVisible(true);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "An error occurred while opening the file: " + iOException.getMessage(), "Error", 0);
                    this.ge = null;
                }
            }
        }
        if (string.equals("Save")) {
            this.doSave();
        }
        if (string.equals("Save As")) {
            this.doSaveAs();
        }
        if (string.equals("Exit")) {
            this.closeCurrentGame();
            this.dispose();
        }
        if (string.equals("Help")) {
            serializable = ClassLoader.getSystemResource("images/lanty-register.gif");
            ImageIcon imageIcon = new ImageIcon((URL)serializable, "Please register AAS to access online help!");
            JOptionPane.showMessageDialog(this, imageIcon, "Please register!", -1);
        }
        if (string.equals("About")) {
            JOptionPane.showMessageDialog(this, "AASide: Advanced Authoring System Integrated Development Environment\nVersion 2.0 public beta, release 6\nby Roddy Ramieson", "About", 1);
        }
    }

    void doSave() {
        if (this.gamefile == null) {
            this.doSaveAs();
        } else {
            try {
                this.ge.saveGame(this.gamefile);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "An error occurred while saving the file: " + iOException.getMessage(), "Error", 0);
            }
        }
    }

    void doSaveAs() {
        block2: {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new ARGFileFilter());
            if (jFileChooser.showSaveDialog(this) != 0) break block2;
            try {
                this.ge.saveGame(jFileChooser.getSelectedFile());
                this.gamefile = jFileChooser.getSelectedFile();
                this.ge.setTitle(this.gamefile.getName());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "An error occurred while saving the file: " + iOException.getMessage(), "Error", 0);
            }
        }
    }

    void closeCurrentGame() {
        if (this.ge != null) {
            if (JOptionPane.showConfirmDialog(this, "Do you want to save the current game first?", "Save first?", 0) == 0) {
                this.doSave();
            }
            this.ge.closeWindows();
            this.desktop.remove(this.ge);
            this.desktop.repaint();
            this.ge = null;
            this.gamefile = null;
        }
    }
}

