/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public class GUITerp {
    private Random rGen = new Random();
    private static final Color statusLineColor = new Color(156, 144, 244);
    private Vector emoticons;
    private int moveCount;
    private ImageIcon staticBrowserIcon;
    private ImageIcon animatedBrowserIcon;
    private Graphics scrollPaneGFX;
    JFrame terpWindow;
    private JPanel terpPane;
    private JTextField commandLine;
    private JPanel browserIconPanel;
    private JPanel statusLinePanel;
    private JScrollPane gameTextScrollPane;
    private JTextPane gameTextPane;
    public StyledDocument gameDoc;
    private Style gameTextStyle;
    private JLabel browserIconLabel;
    private JScrollBar gameTextScrollBar;
    private AAS aas;
    String statusString1;
    String statusString2;
    private JLabel statusLineLabel;
    private Timer processDelayTimer = new Timer(800, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            GUITerp.this.aas.runNext(GUITerp.this.commandLine.getText());
            GUITerp.this.browserIconLabel.setIcon(GUITerp.this.staticBrowserIcon);
            if (bl) {
                GUITerp.this.quitTimer.start();
            } else {
                GUITerp.this.commandLine.enable();
                GUITerp.this.commandLine.setText("");
                GUITerp.this.commandLine.setBackground(Color.WHITE);
                GUITerp.this.commandLine.requestFocus();
            }
            GUITerp.this.moveCount++;
            GUITerp.this.updateStatusLine();
            GUITerp.this.processDelayTimer.stop();
        }
    });
    private Timer quitTimer = new Timer(1500, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    });
    public Timer statusLineTimer = new Timer(100, new ActionListener(){
        private int mode;
        private int ticks;

        public void actionPerformed(ActionEvent actionEvent) {
            ++this.ticks;
            this.mode = this.ticks / 50 % 4;
            switch (this.mode) {
                case 0: {
                    GUITerp.this.statusLineLabel.setText(GUITerp.this.statusString1);
                    break;
                }
                case 1: {
                    GUITerp.this.statusLineLabel.setText(GUITerp.this.statusString2);
                    break;
                }
                case 2: {
                    Date date = new Date();
                    GUITerp.this.statusLineLabel.setText(DateFormat.getDateInstance(3).format(date) + "  " + DateFormat.getTimeInstance(2).format(date));
                    break;
                }
                case 3: {
                    GUITerp.this.statusLineLabel.setForeground(new Color(Math.abs(GUITerp.this.rGen.nextInt()) % 255, Math.abs(GUITerp.this.rGen.nextInt()) % 255, Math.abs(GUITerp.this.rGen.nextInt()) % 255));
                    GUITerp.this.statusLineLabel.setText("PLEASE REGISTER!!!!");
                }
            }
            if (this.ticks % 50 == 0) {
                GUITerp.this.statusLineLabel.setText(" ");
                GUITerp.this.statusLineLabel.setForeground(statusLineColor);
            }
        }
    });
    private Timer autocompleteTimer = new Timer(10, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = GUITerp.this.commandLine.getText(0, GUITerp.this.commandLine.getCaretPosition());
                if (string.indexOf(" ") != -1) {
                    string = string.substring(string.lastIndexOf(32) + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            GUITerp.this.autocompleteTimer.stop();
        }
    });
    KeyListener enterTextListener = new KeyListener(){

        public void keyPressed(KeyEvent keyEvent) {
            if (Character.isLetter(keyEvent.getKeyChar())) {
                GUITerp.this.autocompleteTimer.start();
            }
            if (keyEvent.getKeyCode() == 10) {
                GUITerp.this.browserIconLabel.setIcon(GUITerp.this.animatedBrowserIcon);
                GUITerp.this.commandLine.disable();
                GUITerp.this.commandLine.setBackground(Color.LIGHT_GRAY);
                GUITerp.this.processDelayTimer.setInitialDelay(200 + Math.abs(GUITerp.this.rGen.nextInt()) % 1000);
                GUITerp.this.processDelayTimer.start();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };

    private void getEmoticons() {
        this.emoticons = new Vector();
        this.emoticons.add(new Emoticon("icons/grin.gif", ":D"));
        this.emoticons.add(new Emoticon("icons/amazed.gif", ":O"));
        this.emoticons.add(new Emoticon("icons/hug.gif", "[HUG]"));
        this.emoticons.add(new Emoticon("icons/hearts.gif", "<3"));
        this.emoticons.add(new Emoticon("icons/angry.gif", ":@"));
        this.emoticons.add(new Emoticon("icons/cool.gif", "B)"));
        this.emoticons.add(new Emoticon("icons/spin.gif", "[SPIN]"));
        this.emoticons.add(new Emoticon("icons/penguin.gif", "[PENGUIN]"));
        this.emoticons.add(new Emoticon("icons/cry.gif", "[SAD]"));
        this.emoticons.add(new Emoticon("icons/love.gif", "[LOVE]"));
        this.emoticons.add(new Emoticon("icons/wink.gif", "[WINK]"));
        this.emoticons.add(new Emoticon("icons/banghead.gif", "[BANGHEAD]"));
        this.emoticons.add(new Emoticon("icons/shocking.gif", "[SHOCKING]"));
    }

    public void drawBlood() {
        this.scrollPaneGFX.setColor(Color.RED);
        this.scrollPaneGFX.fillOval(0, 0, 50, 50);
        this.gameTextScrollPane.repaint();
    }

    public void clearGameText() {
        this.gameTextPane.setText("");
    }

    public void addGameText(String string) {
        this.gameTextPane.setEditable(true);
        int n = this.gameDoc.getLength();
        try {
            this.gameDoc.insertString(this.gameDoc.getLength(), string, this.gameTextStyle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.gameDoc.getLength() - n;
        String string2 = "";
        try {
            string2 = this.gameTextPane.getText(n, n2).toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = 0;
        while (n3 < this.emoticons.size()) {
            Emoticon emoticon = (Emoticon)this.emoticons.get(n3);
            boolean bl = false;
            int n4 = string2.indexOf(emoticon.toString());
            int n5 = 0;
            while (n4 != -1) {
                this.gameTextPane.setCaretPosition(n + n4 + n5);
                this.gameTextPane.insertIcon(emoticon.getIcon());
                ++n5;
                n4 = string2.indexOf(emoticon.toString(), n4 + 1);
            }
            ++n3;
        }
        this.gameTextScrollBar.setValue(this.gameTextScrollBar.getMaximum());
        this.gameTextPane.setCaretPosition(this.gameDoc.getLength());
        this.gameTextPane.setEditable(false);
    }

    public void addSelected(String string) {
        block2: {
            if (string == null || string == "") break block2;
            try {
                int n = this.commandLine.getCaretPosition();
                this.commandLine.setSelectionStart(this.commandLine.getCaretPosition());
                String string2 = this.commandLine.getText(0, n);
                String string3 = this.commandLine.getText(this.commandLine.getCaretPosition(), this.commandLine.getText().length() - n);
                this.commandLine.setText(string2 + string + string3);
                this.commandLine.setCaretPosition(n + string.length());
                this.commandLine.setSelectionEnd(this.commandLine.getCaretPosition());
                this.commandLine.select(n, n + string.length());
            }
            catch (Exception exception) {}
        }
    }

    public void updateStatusLine() {
        this.statusString1 = "Location: " + this.aas.getCurrentRoom().name + " - " + "Points: " + this.aas.score + "/" + this.aas.maxscore + " - " + "Turns: " + this.moveCount;
        this.statusString2 = "Now Playing: \"" + this.aas.title + "\" (" + this.aas.author + ")";
    }

    public Component createComponents() {
        Font font;
        this.terpPane = new JPanel();
        this.terpPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.commandLine = new JTextField();
        this.commandLine.setToolTipText("Enter a command here.");
        this.statusLinePanel = new JPanel();
        this.statusLinePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.statusLinePanel.setBackground(Color.WHITE);
        Font font2 = font = new Font("Times New Roman", 0, 20);
        Font font3 = new Font("Arial", 0, 35);
        this.statusLineLabel = new JLabel("AAS v2.0", 0);
        this.statusLineLabel.setForeground(statusLineColor);
        this.statusLinePanel.add(this.statusLineLabel);
        this.statusLineLabel.setVerticalAlignment(0);
        this.statusLineLabel.setFont(font3);
        this.gameTextScrollPane = new JScrollPane(22, 31);
        this.gameTextPane = new JTextPane();
        this.gameDoc = (StyledDocument)this.gameTextPane.getDocument();
        this.gameTextStyle = this.gameDoc.addStyle("StyleName", null);
        this.gameTextScrollPane.getViewport().add(this.gameTextPane);
        this.gameTextScrollBar = this.gameTextScrollPane.getVerticalScrollBar();
        this.staticBrowserIcon = new ImageIcon(ClassLoader.getSystemResource("icons/browser1.gif"), "browser");
        this.animatedBrowserIcon = new ImageIcon(ClassLoader.getSystemResource("icons/browser2.gif"), "browser");
        this.browserIconLabel = new JLabel(this.staticBrowserIcon);
        this.browserIconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.terpPane.setLayout(gridBagLayout2);
        this.terpPane.add(this.statusLinePanel);
        this.terpPane.add(this.browserIconLabel);
        this.terpPane.add(this.gameTextScrollPane);
        this.terpPane.add(this.commandLine);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 0, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, -1, 0, 2, 1.0, 0.0, 15, 2, new Insets(2, 2, 2, 2), 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, -1, 5, 1.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(10, 0, -1, 5, 0.0, 0.0, 12, 0, new Insets(2, 2, 2, 2), 0, 0);
        gridBagLayout2.setConstraints(this.statusLinePanel, gridBagConstraints3);
        gridBagLayout2.setConstraints(this.browserIconLabel, gridBagConstraints4);
        gridBagLayout2.setConstraints(this.gameTextScrollPane, gridBagConstraints);
        gridBagLayout2.setConstraints(this.commandLine, gridBagConstraints2);
        this.gameTextPane.setBackground(new Color(240, 240, 255));
        this.gameTextPane.setForeground(new Color(20, 20, 100));
        this.gameTextPane.setFont(font);
        this.scrollPaneGFX = this.gameTextScrollPane.getGraphics();
        this.commandLine.setFont(font2);
        this.gameTextPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.gameTextPane.setEditable(false);
        return this.terpPane;
    }

    public GUITerp() {
        this.getEmoticons();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terpWindow = new JFrame("AAS Interpreter v2.0");
        Component component = this.createComponents();
        this.terpWindow.getContentPane().add(component, "Center");
        this.commandLine.addKeyListener(this.enterTextListener);
        this.browserIconLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }
        });
        this.terpWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.terpWindow.pack();
        this.terpWindow.setExtendedState(6);
        this.commandLine.requestFocus();
        this.aas = new AAS((AAS.IO)new GuiIO(this));
    }

    public static void main(String[] stringArray) {
        try {
            GUITerp gUITerp = new GUITerp();
            gUITerp.terpWindow.setVisible(false);
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Open An AAS Game");
            jFileChooser.addChoosableFileFilter(new AasFilter());
            jFileChooser.showOpenDialog(gUITerp.terpWindow);
            while (!jFileChooser.isEnabled()) {
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                System.exit(0);
            }
            gUITerp.terpWindow.setVisible(true);
            gUITerp.aas.loadFile(file.toString());
            gUITerp.aas.runInit();
            gUITerp.updateStatusLine();
            gUITerp.statusLineTimer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

