/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public abstract class AASLoader {
    Map tagLoadables = new HashMap();
    Map attributeLoadables = new HashMap();
    static /* synthetic */ Class class$org$jdom$Element;

    public void addStringAttr(String string) {
        try {
            Field field = this.getClass().getField(string);
            FieldAttr fieldAttr = new FieldAttr(field, this){

                public void load(Attribute attribute) throws Exception {
                    String string = attribute.getValue();
                    if (string != null && string.length() > 0) {
                        this.field.set(this.owner, string);
                    }
                }
            };
            this.addAttr(string, fieldAttr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addStringTag(String string) {
        try {
            Field field = this.getClass().getField(string);
            FieldTag fieldTag = new FieldTag(field, this){

                public void load(Element element) throws Exception {
                    String string = element.getText();
                    if (string != null && string.length() > 0) {
                        this.field.set(this.owner, string);
                    }
                }
            };
            this.addTag(string, fieldTag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addIntTag(String string) {
        try {
            Field field = this.getClass().getField(string);
            FieldTag fieldTag = new FieldTag(field, this){

                public void load(Element element) throws Exception {
                    this.field.setInt(this.owner, Integer.parseInt(element.getText()));
                }
            };
            this.addTag(string, fieldTag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addFlagTag(String string) {
        try {
            Field field = this.getClass().getField(string);
            FieldTag fieldTag = new FieldTag(field, this){

                public void load(Element element) throws Exception {
                    this.field.setBoolean(this.owner, true);
                }
            };
            this.addTag(string, fieldTag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addToggleTag(String string) {
        try {
            Field field = this.getClass().getField(string);
            FieldTag fieldTag = new FieldTag(field, this){

                public void load(Element element) throws Exception {
                    boolean bl = this.field.getBoolean(this);
                    this.field.setBoolean(this.owner, !bl);
                }
            };
            this.addTag(string, fieldTag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addSubLoaderTag(String string) {
        try {
            Class[] classArray = new Class[]{class$org$jdom$Element == null ? (class$org$jdom$Element = AASLoader.class$("org.jdom.Element")) : class$org$jdom$Element};
            Method method = this.getClass().getMethod("load_" + string, classArray);
            MethodTag methodTag = new MethodTag(method, this){

                public void load(Element element) throws Exception {
                    Object[] objectArray = new Object[]{element};
                    this.method.invoke(this.owner, objectArray);
                }
            };
            this.addTag(string, methodTag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addTag(String string, Tag tag) {
        this.tagLoadables.put(string, tag);
    }

    public void addAttr(String string, Attr attr) {
        this.attributeLoadables.put(string, attr);
    }

    protected void preload(Element element) {
    }

    protected void postload(Element element) {
    }

    void load(Element element) {
        Object object;
        Attribute attribute;
        this.preload(element);
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            object = (Attr)this.attributeLoadables.get(attribute.getName());
            if (object == null) {
                System.err.println("Skipping unknown attribute: " + attribute.getName());
                continue;
            }
            try {
                object.load(attribute);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            attribute = (Element)iterator.next();
            object = (Tag)this.tagLoadables.get(attribute.getName());
            if (object == null) {
                System.err.println("Skipping unknown tag: " + attribute.getName());
                continue;
            }
            try {
                object.load((Element)attribute);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.postload(element);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static abstract class MethodTag
    implements Tag {
        Method method;
        Object owner;

        MethodTag(Method method, Object object) {
            this.method = method;
            this.owner = object;
        }
    }

    static abstract class FieldTag
    implements Tag {
        Field field;
        Object owner;

        FieldTag(Field field, Object object) {
            this.field = field;
            this.owner = object;
        }
    }

    static abstract class FieldAttr
    implements Attr {
        Field field;
        Object owner;

        FieldAttr(Field field, Object object) {
            this.field = field;
            this.owner = object;
        }
    }

    public static interface Attr {
        public void load(Attribute var1) throws Exception;
    }

    public static interface Tag {
        public void load(Element var1) throws Exception;
    }
}

