/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;

public class AASApplet
extends Applet
implements AAS.IO {
    TextField inputField = new TextField();
    TextArea outputField = new TextArea("", 10, 30, 1);
    AAS aas;
    String lastInput;
    boolean waitingForInput = false;
    public String file;

    public void init() {
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)this.inputField, "South");
        this.add((Component)this.outputField, "Center");
        this.outputField.setEditable(false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AASApplet.this.gotInput();
            }
        };
        this.inputField.addActionListener(actionListener);
        this.aas = new AAS(this);
    }

    public void print(String string) {
        this.outputField.append(string);
    }

    public void alert(String string) {
        this.print(string);
    }

    public synchronized void gotInput() {
        this.lastInput = this.inputField.getText();
        this.inputField.setText("");
        if (this.waitingForInput) {
            this.aas.runNext(this.lastInput);
        } else {
            this.notify();
        }
    }

    public synchronized String input() {
        try {
            this.wait();
            return this.lastInput;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void clear() {
        this.outputField.setText("");
    }

    public void setColour(int n, int n2, int n3) {
        this.outputField.setBackground(new Color(n, n2, n3));
        this.outputField.setForeground(new Color(255 - n, 255 - n2, 255 - n3));
    }

    public void enterNewRoom() {
    }

    String loadGPL() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nGNU GPL Port of AAS maintained by thetuxedo@linuxmail.org\n\n");
        return stringBuffer.toString();
    }

    public void start() {
        block3: {
            try {
                if (this.file == null) {
                    String string = this.getParameter("gamefile");
                    URL uRL = new URL(this.getDocumentBase(), string);
                    this.aas.loadURL(uRL);
                    this.print(this.loadGPL());
                    this.aas.runInit();
                    this.waitingForInput = true;
                    break block3;
                }
                this.aas.loadFile(this.file);
                this.print(this.loadGPL());
                this.aas.run();
                this.waitingForInput = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.print(exception.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AASApplet aASApplet = new AASApplet();
        aASApplet.file = stringArray[0];
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Frame frame = (Frame)windowEvent.getSource();
                frame.setVisible(false);
                frame.dispose();
                System.exit(0);
            }
        };
        Frame frame = new Frame();
        frame.addWindowListener(windowAdapter);
        frame.add((Component)aASApplet, "Center");
        aASApplet.init();
        frame.setSize(400, 300);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((dimension.width - 400) / 2, (dimension.height - 300) / 2);
        frame.setVisible(true);
        aASApplet.start();
    }
}

